/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apptest.model.CloudFormation;
import java.util.Map;

@SdkInternalApi
public class CloudFormationMarshaller {
    private static final MarshallingInfo<String> TEMPLATELOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("templateLocation").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").build();
    private static final CloudFormationMarshaller instance = new CloudFormationMarshaller();

    public static CloudFormationMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudFormation cloudFormation, ProtocolMarshaller protocolMarshaller) {
        if (cloudFormation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudFormation.getTemplateLocation(), TEMPLATELOCATION_BINDING);
            protocolMarshaller.marshall(cloudFormation.getParameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

