/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSExtendedClientBase;
import com.amazon.sqs.javamessaging.AmazonSQSExtendedClientUtil;
import com.amazon.sqs.javamessaging.ExtendedClientConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.payloadoffloading.PayloadStore;
import software.amazon.payloadoffloading.S3BackedPayloadStore;
import software.amazon.payloadoffloading.S3Dao;
import software.amazon.payloadoffloading.Util;

public class AmazonSQSExtendedClient
extends AmazonSQSExtendedClientBase
implements SqsClient {
    static final String USER_AGENT_NAME = AmazonSQSExtendedClient.class.getSimpleName();
    static final String USER_AGENT_VERSION = "2.25.6";
    private static final Log LOG = LogFactory.getLog(AmazonSQSExtendedClient.class);
    private ExtendedClientConfiguration clientConfiguration;
    private PayloadStore payloadStore;

    public AmazonSQSExtendedClient(SqsClient sqsClient) {
        this(sqsClient, new ExtendedClientConfiguration());
    }

    public AmazonSQSExtendedClient(SqsClient sqsClient, ExtendedClientConfiguration extendedClientConfig) {
        super(sqsClient);
        this.clientConfiguration = new ExtendedClientConfiguration(extendedClientConfig);
        S3Dao s3Dao = new S3Dao(this.clientConfiguration.getS3Client(), this.clientConfiguration.getServerSideEncryptionStrategy(), this.clientConfiguration.getObjectCannedACL());
        this.payloadStore = new S3BackedPayloadStore(s3Dao, this.clientConfiguration.getS3BucketName());
    }

    @Override
    public SendMessageResponse sendMessage(SendMessageRequest sendMessageRequest) {
        if (sendMessageRequest == null) {
            String errorMessage = "sendMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        SendMessageRequest.Builder sendMessageRequestBuilder = sendMessageRequest.toBuilder();
        sendMessageRequest = (SendMessageRequest)AmazonSQSExtendedClient.appendUserAgent(sendMessageRequestBuilder).build();
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.sendMessage(sendMessageRequest);
        }
        if (StringUtils.isEmpty((CharSequence)sendMessageRequest.messageBody())) {
            String errorMessage = "messageBody cannot be null or empty.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        AmazonSQSExtendedClientUtil.checkMessageAttributes(this.clientConfiguration.getPayloadSizeThreshold(), sendMessageRequest.messageAttributes());
        if (this.clientConfiguration.isAlwaysThroughS3() || AmazonSQSExtendedClientUtil.isLarge(this.clientConfiguration.getPayloadSizeThreshold(), sendMessageRequest)) {
            sendMessageRequest = this.storeMessageInS3(sendMessageRequest);
        }
        return super.sendMessage(sendMessageRequest);
    }

    @Override
    public ReceiveMessageResponse receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        if (receiveMessageRequest == null) {
            String errorMessage = "receiveMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        ReceiveMessageRequest.Builder receiveMessageRequestBuilder = receiveMessageRequest.toBuilder();
        AmazonSQSExtendedClient.appendUserAgent(receiveMessageRequestBuilder);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.receiveMessage((ReceiveMessageRequest)receiveMessageRequestBuilder.build());
        }
        ArrayList<String> messageAttributeNames = new ArrayList<String>(receiveMessageRequest.messageAttributeNames());
        messageAttributeNames.removeAll(AmazonSQSExtendedClientUtil.RESERVED_ATTRIBUTE_NAMES);
        messageAttributeNames.addAll(AmazonSQSExtendedClientUtil.RESERVED_ATTRIBUTE_NAMES);
        receiveMessageRequestBuilder.messageAttributeNames(messageAttributeNames);
        receiveMessageRequest = (ReceiveMessageRequest)receiveMessageRequestBuilder.build();
        ReceiveMessageResponse receiveMessageResponse = super.receiveMessage(receiveMessageRequest);
        ReceiveMessageResponse.Builder receiveMessageResponseBuilder = receiveMessageResponse.toBuilder();
        List messages = receiveMessageResponse.messages();
        ArrayList<Message> modifiedMessages = new ArrayList<Message>(messages.size());
        for (Message message : messages) {
            Message.Builder messageBuilder = message.toBuilder();
            Optional<String> largePayloadAttributeName = AmazonSQSExtendedClientUtil.getReservedAttributeNameIfPresent(message.messageAttributes());
            if (largePayloadAttributeName.isPresent()) {
                String largeMessagePointer = message.body();
                largeMessagePointer = largeMessagePointer.replace("com.amazon.sqs.javamessaging.MessageS3Pointer", "software.amazon.payloadoffloading.PayloadS3Pointer");
                messageBuilder.body(this.payloadStore.getOriginalPayload(largeMessagePointer));
                HashMap messageAttributes = new HashMap(message.messageAttributes());
                messageAttributes.keySet().removeAll(AmazonSQSExtendedClientUtil.RESERVED_ATTRIBUTE_NAMES);
                messageBuilder.messageAttributes(messageAttributes);
                String modifiedReceiptHandle = AmazonSQSExtendedClientUtil.embedS3PointerInReceiptHandle(message.receiptHandle(), largeMessagePointer);
                messageBuilder.receiptHandle(modifiedReceiptHandle);
            }
            modifiedMessages.add((Message)messageBuilder.build());
        }
        receiveMessageResponseBuilder.messages(modifiedMessages);
        return (ReceiveMessageResponse)receiveMessageResponseBuilder.build();
    }

    @Override
    public DeleteMessageResponse deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        String receiptHandle;
        if (deleteMessageRequest == null) {
            String errorMessage = "deleteMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        DeleteMessageRequest.Builder deleteMessageRequestBuilder = deleteMessageRequest.toBuilder();
        AmazonSQSExtendedClient.appendUserAgent(deleteMessageRequestBuilder);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.deleteMessage((DeleteMessageRequest)deleteMessageRequestBuilder.build());
        }
        String origReceiptHandle = receiptHandle = deleteMessageRequest.receiptHandle();
        if (AmazonSQSExtendedClientUtil.isS3ReceiptHandle(receiptHandle)) {
            origReceiptHandle = AmazonSQSExtendedClientUtil.getOrigReceiptHandle(receiptHandle);
            if (this.clientConfiguration.doesCleanupS3Payload()) {
                String messagePointer = AmazonSQSExtendedClientUtil.getMessagePointerFromModifiedReceiptHandle(receiptHandle);
                this.payloadStore.deleteOriginalPayload(messagePointer);
            }
        }
        deleteMessageRequestBuilder.receiptHandle(origReceiptHandle);
        return super.deleteMessage((DeleteMessageRequest)deleteMessageRequestBuilder.build());
    }

    @Override
    public ChangeMessageVisibilityResponse changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AwsServiceException, SdkClientException {
        ChangeMessageVisibilityRequest.Builder changeMessageVisibilityRequestBuilder = changeMessageVisibilityRequest.toBuilder();
        if (AmazonSQSExtendedClientUtil.isS3ReceiptHandle(changeMessageVisibilityRequest.receiptHandle())) {
            changeMessageVisibilityRequestBuilder.receiptHandle(AmazonSQSExtendedClientUtil.getOrigReceiptHandle(changeMessageVisibilityRequest.receiptHandle()));
        }
        return this.amazonSqsToBeExtended.changeMessageVisibility((ChangeMessageVisibilityRequest)changeMessageVisibilityRequestBuilder.build());
    }

    @Override
    public SendMessageBatchResponse sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) {
        if (sendMessageBatchRequest == null) {
            String errorMessage = "sendMessageBatchRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        SendMessageBatchRequest.Builder sendMessageBatchRequestBuilder = sendMessageBatchRequest.toBuilder();
        AmazonSQSExtendedClient.appendUserAgent(sendMessageBatchRequestBuilder);
        sendMessageBatchRequest = (SendMessageBatchRequest)sendMessageBatchRequestBuilder.build();
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.sendMessageBatch(sendMessageBatchRequest);
        }
        ArrayList<SendMessageBatchRequestEntry> batchEntries = new ArrayList<SendMessageBatchRequestEntry>(sendMessageBatchRequest.entries().size());
        boolean hasS3Entries = false;
        for (SendMessageBatchRequestEntry entry : sendMessageBatchRequest.entries()) {
            AmazonSQSExtendedClientUtil.checkMessageAttributes(this.clientConfiguration.getPayloadSizeThreshold(), entry.messageAttributes());
            if (this.clientConfiguration.isAlwaysThroughS3() || AmazonSQSExtendedClientUtil.isLarge(this.clientConfiguration.getPayloadSizeThreshold(), entry)) {
                entry = this.storeMessageInS3(entry);
                hasS3Entries = true;
            }
            batchEntries.add(entry);
        }
        if (hasS3Entries) {
            sendMessageBatchRequest = (SendMessageBatchRequest)sendMessageBatchRequest.toBuilder().entries(batchEntries).build();
        }
        return super.sendMessageBatch(sendMessageBatchRequest);
    }

    @Override
    public DeleteMessageBatchResponse deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        if (deleteMessageBatchRequest == null) {
            String errorMessage = "deleteMessageBatchRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        DeleteMessageBatchRequest.Builder deleteMessageBatchRequestBuilder = deleteMessageBatchRequest.toBuilder();
        AmazonSQSExtendedClient.appendUserAgent(deleteMessageBatchRequestBuilder);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.deleteMessageBatch(deleteMessageBatchRequest);
        }
        ArrayList<DeleteMessageBatchRequestEntry> entries = new ArrayList<DeleteMessageBatchRequestEntry>(deleteMessageBatchRequest.entries().size());
        for (DeleteMessageBatchRequestEntry entry : deleteMessageBatchRequest.entries()) {
            String receiptHandle;
            DeleteMessageBatchRequestEntry.Builder entryBuilder = entry.toBuilder();
            String origReceiptHandle = receiptHandle = entry.receiptHandle();
            if (AmazonSQSExtendedClientUtil.isS3ReceiptHandle(receiptHandle)) {
                origReceiptHandle = AmazonSQSExtendedClientUtil.getOrigReceiptHandle(receiptHandle);
                if (this.clientConfiguration.doesCleanupS3Payload()) {
                    String messagePointer = AmazonSQSExtendedClientUtil.getMessagePointerFromModifiedReceiptHandle(receiptHandle);
                    this.payloadStore.deleteOriginalPayload(messagePointer);
                }
            }
            entryBuilder.receiptHandle(origReceiptHandle);
            entries.add((DeleteMessageBatchRequestEntry)entryBuilder.build());
        }
        deleteMessageBatchRequestBuilder.entries(entries);
        return super.deleteMessageBatch((DeleteMessageBatchRequest)deleteMessageBatchRequestBuilder.build());
    }

    @Override
    public ChangeMessageVisibilityBatchResponse changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws AwsServiceException, SdkClientException {
        ArrayList<ChangeMessageVisibilityBatchRequestEntry> entries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(changeMessageVisibilityBatchRequest.entries().size());
        for (ChangeMessageVisibilityBatchRequestEntry entry : changeMessageVisibilityBatchRequest.entries()) {
            ChangeMessageVisibilityBatchRequestEntry.Builder entryBuilder = entry.toBuilder();
            if (AmazonSQSExtendedClientUtil.isS3ReceiptHandle(entry.receiptHandle())) {
                entryBuilder.receiptHandle(AmazonSQSExtendedClientUtil.getOrigReceiptHandle(entry.receiptHandle()));
            }
            entries.add((ChangeMessageVisibilityBatchRequestEntry)entryBuilder.build());
        }
        return this.amazonSqsToBeExtended.changeMessageVisibilityBatch((ChangeMessageVisibilityBatchRequest)changeMessageVisibilityBatchRequest.toBuilder().entries(entries).build());
    }

    @Override
    public PurgeQueueResponse purgeQueue(PurgeQueueRequest purgeQueueRequest) throws AwsServiceException, SdkClientException {
        LOG.warn((Object)"Calling purgeQueue deletes SQS messages without deleting their payload from S3.");
        if (purgeQueueRequest == null) {
            String errorMessage = "purgeQueueRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        PurgeQueueRequest.Builder purgeQueueRequestBuilder = purgeQueueRequest.toBuilder();
        AmazonSQSExtendedClient.appendUserAgent(purgeQueueRequestBuilder);
        return super.purgeQueue((PurgeQueueRequest)purgeQueueRequestBuilder.build());
    }

    private SendMessageBatchRequestEntry storeMessageInS3(SendMessageBatchRequestEntry batchEntry) {
        String messageContentStr = batchEntry.messageBody();
        Long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        SendMessageBatchRequestEntry.Builder batchEntryBuilder = batchEntry.toBuilder();
        batchEntryBuilder.messageAttributes(AmazonSQSExtendedClientUtil.updateMessageAttributePayloadSize(batchEntry.messageAttributes(), messageContentSize, this.clientConfiguration.usesLegacyReservedAttributeName()));
        String largeMessagePointer = this.storeOriginalPayload(messageContentStr);
        batchEntryBuilder.messageBody(largeMessagePointer);
        return (SendMessageBatchRequestEntry)batchEntryBuilder.build();
    }

    private SendMessageRequest storeMessageInS3(SendMessageRequest sendMessageRequest) {
        String messageContentStr = sendMessageRequest.messageBody();
        Long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        SendMessageRequest.Builder sendMessageRequestBuilder = sendMessageRequest.toBuilder();
        sendMessageRequestBuilder.messageAttributes(AmazonSQSExtendedClientUtil.updateMessageAttributePayloadSize(sendMessageRequest.messageAttributes(), messageContentSize, this.clientConfiguration.usesLegacyReservedAttributeName()));
        String largeMessagePointer = this.storeOriginalPayload(messageContentStr);
        sendMessageRequestBuilder.messageBody(largeMessagePointer);
        return (SendMessageRequest)sendMessageRequestBuilder.build();
    }

    private String storeOriginalPayload(String messageContentStr) {
        String s3KeyPrefix = this.clientConfiguration.getS3KeyPrefix();
        if (StringUtils.isBlank((CharSequence)s3KeyPrefix)) {
            return this.payloadStore.storeOriginalPayload(messageContentStr);
        }
        return this.payloadStore.storeOriginalPayload(messageContentStr, s3KeyPrefix + UUID.randomUUID());
    }

    private static <T extends AwsRequest.Builder> T appendUserAgent(T builder) {
        return AmazonSQSExtendedClientUtil.appendUserAgent(builder, USER_AGENT_NAME, USER_AGENT_VERSION);
    }

    @Override
    public void close() {
        super.close();
        this.clientConfiguration.getS3Client().close();
    }
}

