/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.util.Base64;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public final class JSONScanner
extends JSONLexer {
    private final String text;
    public final int ISO8601_LEN_0 = "0000-00-00".length();
    public final int ISO8601_LEN_1 = "0000-00-00T00:00:00".length();
    public final int ISO8601_LEN_2 = "0000-00-00T00:00:00.000".length();

    public JSONScanner(String input) {
        this(input, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(String input, int features) {
        this.features = features;
        this.text = input;
        this.bp = -1;
        this.next();
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    public final char charAt(int index) {
        if (index >= this.text.length()) {
            return '\u001a';
        }
        return this.text.charAt(index);
    }

    public final char next() {
        this.ch = this.charAt(++this.bp);
        return this.ch;
    }

    public JSONScanner(char[] input, int inputLength) {
        this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(char[] input, int inputLength, int features) {
        this(new String(input, 0, inputLength), features);
    }

    protected final void copyTo(int offset, int count, char[] dest) {
        this.text.getChars(offset, offset + count, dest, 0);
    }

    static final boolean charArrayCompare(String src, int offset, char[] dest) {
        int destLen = dest.length;
        if (destLen + offset > src.length()) {
            return false;
        }
        for (int i = 0; i < destLen; ++i) {
            if (dest[i] == src.charAt(offset + i)) continue;
            return false;
        }
        return true;
    }

    public final boolean charArrayCompare(char[] chars) {
        return JSONScanner.charArrayCompare(this.text, this.bp, chars);
    }

    public final int indexOf(char ch, int startIndex) {
        return this.text.indexOf(ch, startIndex);
    }

    public final String addSymbol(int offset, int len, int hash, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.text, offset, len, hash);
    }

    public byte[] bytesValue() {
        return Base64.decodeFast(this.text, this.np + 1, this.sp);
    }

    protected void arrayCopy(int srcPos, char[] dest, int destPos, int length) {
        this.text.getChars(srcPos, srcPos + length, dest, destPos);
    }

    public final String stringVal() {
        if (!this.hasSpecial) {
            return this.text.substring(this.np + 1, this.np + 1 + this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    public final String subString(int offset, int count) {
        return this.text.substring(offset, offset + count);
    }

    public final String numberString() {
        char chLocal = this.charAt(this.np + this.sp - 1);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        return this.text.substring(this.np, this.np + sp);
    }

    public boolean scanISO8601DateIfMatch() {
        return this.scanISO8601DateIfMatch(true);
    }

    public boolean scanISO8601DateIfMatch(boolean strict) {
        char s1;
        char s0;
        char m1;
        char m0;
        char h1;
        char d1;
        char d0;
        char M1;
        char M0;
        char y3;
        char y2;
        char y1;
        char y0;
        int rest = this.text.length() - this.bp;
        if (!strict && rest > 13) {
            char c0 = this.charAt(this.bp);
            char c1 = this.charAt(this.bp + 1);
            char c2 = this.charAt(this.bp + 2);
            char c3 = this.charAt(this.bp + 3);
            char c4 = this.charAt(this.bp + 4);
            char c5 = this.charAt(this.bp + 5);
            char c_r0 = this.charAt(this.bp + rest - 1);
            char c_r1 = this.charAt(this.bp + rest - 2);
            if (c0 == '/' && c1 == 'D' && c2 == 'a' && c3 == 't' && c4 == 'e' && c5 == '(' && c_r0 == '/' && c_r1 == ')') {
                int plusIndex = -1;
                for (int i = 6; i < rest; ++i) {
                    char c = this.charAt(this.bp + i);
                    if (c == '+') {
                        plusIndex = i;
                        continue;
                    }
                    if (c < '0' || c > '9') break;
                }
                if (plusIndex == -1) {
                    return false;
                }
                int offset = this.bp + 6;
                String numberText = this.subString(offset, plusIndex - offset);
                long millis = Long.parseLong(numberText);
                Locale local = Locale.getDefault();
                this.calendar = Calendar.getInstance(TimeZone.getDefault(), local);
                this.calendar.setTimeInMillis(millis);
                this.token = 5;
                return true;
            }
        }
        if (rest == 8 || rest == 14 || rest == 17) {
            int seconds;
            int minute;
            int hour;
            int millis;
            if (strict) {
                return false;
            }
            y0 = this.charAt(this.bp);
            if (!JSONScanner.checkDate(y0, y1 = this.charAt(this.bp + 1), y2 = this.charAt(this.bp + 2), y3 = this.charAt(this.bp + 3), M0 = this.charAt(this.bp + 4), M1 = this.charAt(this.bp + 5), d0 = this.charAt(this.bp + 6), d1 = this.charAt(this.bp + 7))) {
                return false;
            }
            this.setCalendar(y0, y1, y2, y3, M0, M1, d0, d1);
            if (rest != 8) {
                char s12;
                char s02;
                char m12;
                char m02;
                char h12;
                char h0 = this.charAt(this.bp + 8);
                if (!this.checkTime(h0, h12 = this.charAt(this.bp + 9), m02 = this.charAt(this.bp + 10), m12 = this.charAt(this.bp + 11), s02 = this.charAt(this.bp + 12), s12 = this.charAt(this.bp + 13))) {
                    return false;
                }
                if (rest == 17) {
                    char S0 = this.charAt(this.bp + 14);
                    char S1 = this.charAt(this.bp + 15);
                    char S2 = this.charAt(this.bp + 16);
                    if (S0 < '0' || S0 > '9') {
                        return false;
                    }
                    if (S1 < '0' || S1 > '9') {
                        return false;
                    }
                    if (S2 < '0' || S2 > '9') {
                        return false;
                    }
                    millis = digits[S0] * 100 + digits[S1] * 10 + digits[S2];
                } else {
                    millis = 0;
                }
                hour = digits[h0] * 10 + digits[h12];
                minute = digits[m02] * 10 + digits[m12];
                seconds = digits[s02] * 10 + digits[s12];
            } else {
                hour = 0;
                minute = 0;
                seconds = 0;
                millis = 0;
            }
            this.calendar.set(11, hour);
            this.calendar.set(12, minute);
            this.calendar.set(13, seconds);
            this.calendar.set(14, millis);
            this.token = 5;
            return true;
        }
        if (rest < this.ISO8601_LEN_0) {
            return false;
        }
        if (this.charAt(this.bp + 4) != '-') {
            return false;
        }
        if (this.charAt(this.bp + 7) != '-') {
            return false;
        }
        y0 = this.charAt(this.bp);
        if (!JSONScanner.checkDate(y0, y1 = this.charAt(this.bp + 1), y2 = this.charAt(this.bp + 2), y3 = this.charAt(this.bp + 3), M0 = this.charAt(this.bp + 5), M1 = this.charAt(this.bp + 6), d0 = this.charAt(this.bp + 8), d1 = this.charAt(this.bp + 9))) {
            return false;
        }
        this.setCalendar(y0, y1, y2, y3, M0, M1, d0, d1);
        char t = this.charAt(this.bp + 10);
        if (t == 'T' || t == ' ' && !strict) {
            if (rest < this.ISO8601_LEN_1) {
                return false;
            }
        } else {
            if (t == '\"' || t == '\u001a') {
                this.calendar.set(11, 0);
                this.calendar.set(12, 0);
                this.calendar.set(13, 0);
                this.calendar.set(14, 0);
                this.ch = this.charAt(this.bp += 10);
                this.token = 5;
                return true;
            }
            return false;
        }
        if (this.charAt(this.bp + 13) != ':') {
            return false;
        }
        if (this.charAt(this.bp + 16) != ':') {
            return false;
        }
        char h0 = this.charAt(this.bp + 11);
        if (!this.checkTime(h0, h1 = this.charAt(this.bp + 12), m0 = this.charAt(this.bp + 14), m1 = this.charAt(this.bp + 15), s0 = this.charAt(this.bp + 17), s1 = this.charAt(this.bp + 18))) {
            return false;
        }
        int hour = digits[h0] * 10 + digits[h1];
        int minute = digits[m0] * 10 + digits[m1];
        int seconds = digits[s0] * 10 + digits[s1];
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, seconds);
        char dot = this.charAt(this.bp + 19);
        if (dot == '.') {
            if (rest < this.ISO8601_LEN_2) {
                return false;
            }
        } else {
            this.calendar.set(14, 0);
            this.ch = this.charAt(this.bp += 19);
            this.token = 5;
            return true;
        }
        char S0 = this.charAt(this.bp + 20);
        char S1 = this.charAt(this.bp + 21);
        char S2 = this.charAt(this.bp + 22);
        if (S0 < '0' || S0 > '9') {
            return false;
        }
        if (S1 < '0' || S1 > '9') {
            return false;
        }
        if (S2 < '0' || S2 > '9') {
            return false;
        }
        int millis = digits[S0] * 100 + digits[S1] * 10 + digits[S2];
        this.calendar.set(14, millis);
        this.ch = this.charAt(this.bp += 23);
        this.token = 5;
        return true;
    }

    private boolean checkTime(char h0, char h1, char m0, char m1, char s0, char s1) {
        if (h0 == '0') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '1') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '2') {
            if (h1 < '0' || h1 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (m0 >= '0' && m0 <= '5') {
            if (m1 < '0' || m1 > '9') {
                return false;
            }
        } else if (m0 == '6') {
            if (m1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (s0 >= '0' && s0 <= '5') {
            if (s1 < '0' || s1 > '9') {
                return false;
            }
        } else if (s0 == '6') {
            if (s1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void setCalendar(char y0, char y1, char y2, char y3, char M0, char M1, char d0, char d1) {
        Locale local = Locale.getDefault();
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), local);
        int year = digits[y0] * 1000 + digits[y1] * 100 + digits[y2] * 10 + digits[y3];
        int month = digits[M0] * 10 + digits[M1] - 1;
        int day = digits[d0] * 10 + digits[d1];
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
    }

    static boolean checkDate(char y0, char y1, char y2, char y3, char M0, char M1, int d0, int d1) {
        if (y0 != '1' && y0 != '2') {
            return false;
        }
        if (y1 < '0' || y1 > '9') {
            return false;
        }
        if (y2 < '0' || y2 > '9') {
            return false;
        }
        if (y3 < '0' || y3 > '9') {
            return false;
        }
        if (M0 == '0') {
            if (M1 < '1' || M1 > '9') {
                return false;
            }
        } else if (M0 == '1') {
            if (M1 != '0' && M1 != '1' && M1 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (d0 == 48) {
            if (d1 < 49 || d1 > 57) {
                return false;
            }
        } else if (d0 == 49 || d0 == 50) {
            if (d1 < 48 || d1 > 57) {
                return false;
            }
        } else if (d0 == 51) {
            if (d1 != 48 && d1 != 49) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isEOF() {
        return this.bp == this.text.length() || this.ch == '\u001a' && this.bp + 1 == this.text.length();
    }
}

