/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm.agent;

import com.alibaba.dcm.DnsCache;
import com.alibaba.dcm.DnsCacheEntry;
import com.alibaba.dcm.DnsCacheManipulator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DcmAgent {
    private static final Logger logger = Logger.getLogger(DcmAgent.class.getName());
    private static final String FILE_KEY = "file";
    private static final String DCM_AGENT_SUPPRESS_EXCEPTION_STACK = "DCM_AGENT_SUPPRESS_EXCEPTION_STACK";
    static final String DCM_AGENT_SUCCESS_MARK_LINE = "!!DCM SUCCESS!!";
    private static volatile Map<String, Method> action2Method;
    private static volatile ArrayList<String> actionList;

    public static void premain(@Nonnull String agentArgument) throws Exception {
        DcmAgent.agentmain(agentArgument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
    public static void agentmain(@Nonnull String agentArgument) throws Exception {
        logger.info(String.format("%s: attached with agent argument: %s.%n", DcmAgent.class.getName(), agentArgument));
        agentArgument = agentArgument.trim();
        if (agentArgument.isEmpty()) {
            logger.info(DcmAgent.class.getName() + ": agent argument is blank, do nothing!");
            return;
        }
        DcmAgent.initAction2Method();
        PrintWriter filePrinter = null;
        try {
            Map<String, List<String>> action2Arguments = DcmAgent.parseAgentArgument(agentArgument);
            filePrinter = DcmAgent.getFilePrintWriter(action2Arguments.remove(FILE_KEY));
            if (action2Arguments.isEmpty()) {
                logger.info(DcmAgent.class.getName() + ": No action in agent argument, do nothing!");
                if (filePrinter != null) {
                    filePrinter.printf("No action in agent argument, do nothing! agent argument: %s.%n", agentArgument);
                }
                return;
            }
            boolean allSuccess = true;
            for (Map.Entry<String, List<String>> entry : action2Arguments.entrySet()) {
                List<String> arguments;
                String action = entry.getKey();
                boolean success = DcmAgent.doAction(action, arguments = entry.getValue(), filePrinter);
                if (success) continue;
                allSuccess = false;
            }
            if (allSuccess && filePrinter != null) {
                filePrinter.println(DCM_AGENT_SUCCESS_MARK_LINE);
            }
        }
        finally {
            if (filePrinter != null) {
                try {
                    filePrinter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Nonnull
    private static Map<String, List<String>> parseAgentArgument(@Nonnull String argument) {
        String[] split = argument.split("\\s+");
        int idx = 0;
        HashMap<String, List<String>> action2Arguments = new HashMap<String, List<String>>();
        while (idx < split.length) {
            String action;
            if (!action2Method.containsKey(action = split[idx++])) continue;
            ArrayList<String> arguments = new ArrayList<String>();
            while (idx < split.length && !action2Method.containsKey(split[idx])) {
                arguments.add(split[idx++]);
            }
            action2Arguments.put(action, arguments);
        }
        return action2Arguments;
    }

    @Nullable
    private static PrintWriter getFilePrintWriter(@Nullable List<String> files) throws FileNotFoundException {
        if (null == files) {
            return null;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(files.get(0), false);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
        return new PrintWriter((Writer)outputStreamWriter, true);
    }

    private static boolean doAction(String action, List<String> arguments, PrintWriter filePrinter) {
        String argumentString = DcmAgent.join(arguments);
        if (!action2Method.containsKey(action)) {
            logger.info(String.format("%s: Unknown action %s, ignore! action: %<s %s!%n", DcmAgent.class.getName(), action, argumentString));
            if (filePrinter != null) {
                filePrinter.printf("Unknown action %s, ignore! action: %<s %s !%n", action, argumentString);
            }
            return false;
        }
        try {
            Object result = DcmAgent.invokeAction(action, arguments.toArray(new String[0]));
            DcmAgent.printActionResult(action, result, filePrinter);
            return true;
        }
        catch (Exception e) {
            String exString = DcmAgent.throwable2StackString(e);
            String sdtoutExString = DcmAgent.isDcmAgentSuppressExceptionStack() ? e.toString() : exString;
            logger.info(String.format("%s: Error to do action %s %s, cause: %s%n", DcmAgent.class.getName(), action, argumentString, sdtoutExString));
            if (filePrinter != null) {
                filePrinter.printf("Error to do action %s %s, cause: %s%n", action, argumentString, exString);
            }
            return false;
        }
    }

    private static boolean isDcmAgentSuppressExceptionStack() {
        String suppressException = DcmAgent.getConfig(DCM_AGENT_SUPPRESS_EXCEPTION_STACK);
        if (suppressException == null) {
            return false;
        }
        if ((suppressException = suppressException.trim()).isEmpty()) {
            return false;
        }
        return "true".equalsIgnoreCase(suppressException);
    }

    private static Object invokeAction(String action, String[] arguments) throws InvocationTargetException, IllegalAccessException {
        Method method = action2Method.get(action);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] methodArgs = DcmAgent.convertStringArray2Arguments(action, arguments, parameterTypes);
        return method.invoke(null, methodArgs);
    }

    private static Object[] convertStringArray2Arguments(String action, String[] arguments, Class<?>[] parameterTypes) {
        if (arguments.length < parameterTypes.length) {
            String message = String.format("Action %s need more argument! arguments: %s", action, Arrays.toString(arguments));
            throw new IllegalStateException(message);
        }
        if (parameterTypes.length == 0) {
            return new Object[0];
        }
        Object[] methodArgs = new Object[parameterTypes.length];
        int lastArgumentIdx = parameterTypes.length - 1;
        if (parameterTypes[lastArgumentIdx] == String[].class) {
            String[] varArgs = new String[arguments.length - lastArgumentIdx];
            System.arraycopy(arguments, lastArgumentIdx, varArgs, 0, varArgs.length);
            methodArgs[lastArgumentIdx] = varArgs;
        } else if (arguments.length > parameterTypes.length) {
            String message = String.format("Too many arguments for action %s! arguments: %s", action, Arrays.toString(arguments));
            throw new IllegalStateException(message);
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (methodArgs[i] != null) continue;
            Class<?> parameterType = parameterTypes[i];
            String argument = arguments[i];
            if (parameterType.equals(String.class)) {
                methodArgs[i] = argument;
                continue;
            }
            if (parameterType.equals(Integer.TYPE)) {
                methodArgs[i] = Integer.parseInt(argument);
                continue;
            }
            String message = String.format("Unexpected method type %s! Misused or Bug!!", parameterType.getName());
            throw new IllegalStateException(message);
        }
        return methodArgs;
    }

    private static void printActionResult(String action, Object result, PrintWriter writer) {
        if (writer == null) {
            return;
        }
        Method method = action2Method.get(action);
        if (method.getReturnType() == Void.TYPE) {
            return;
        }
        if (result == null) {
            writer.println((Object)null);
        } else if (result instanceof DnsCacheEntry) {
            DcmAgent.printDnsCacheEntry((DnsCacheEntry)result, writer);
        } else if (result instanceof DnsCache) {
            DnsCache dnsCache = (DnsCache)result;
            DcmAgent.printDnsCacheEntryList("Dns cache: ", dnsCache.getCache(), writer);
            writer.println();
            DcmAgent.printDnsCacheEntryList("Dns negative cache: ", dnsCache.getNegativeCache(), writer);
        } else {
            writer.println(result);
        }
    }

    private static void printDnsCacheEntryList(String msg, List<DnsCacheEntry> dnsCacheEntries, PrintWriter writer) {
        writer.println(msg);
        for (DnsCacheEntry entry : dnsCacheEntries) {
            DcmAgent.printDnsCacheEntry(entry, writer);
        }
    }

    private static void printDnsCacheEntry(DnsCacheEntry entry, PrintWriter writer) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        writer.printf("    %s %s %s%n", entry.getHost(), DcmAgent.join(Arrays.asList(entry.getIps()), ","), dateFormat.format(entry.getExpiration()));
    }

    private static synchronized void initAction2Method() throws NoSuchMethodException {
        if (action2Method != null) {
            return;
        }
        LinkedHashMap<String, Method> map = new LinkedHashMap<String, Method>();
        map.put("set", DnsCacheManipulator.class.getMethod("setDnsCache", String.class, String[].class));
        map.put("get", DnsCacheManipulator.class.getMethod("getDnsCache", String.class));
        map.put("rm", DnsCacheManipulator.class.getMethod("removeDnsCache", String.class));
        map.put("list", DnsCacheManipulator.class.getMethod("getWholeDnsCache", new Class[0]));
        map.put("ls", DnsCacheManipulator.class.getMethod("getWholeDnsCache", new Class[0]));
        map.put("clear", DnsCacheManipulator.class.getMethod("clearDnsCache", new Class[0]));
        map.put("load", DnsCacheManipulator.class.getMethod("loadDnsCacheConfigFromFileSystem", String.class));
        map.put("setPolicy", DnsCacheManipulator.class.getMethod("setDnsCachePolicy", Integer.TYPE));
        map.put("getPolicy", DnsCacheManipulator.class.getMethod("getDnsCachePolicy", new Class[0]));
        map.put("setNegativePolicy", DnsCacheManipulator.class.getMethod("setDnsNegativeCachePolicy", Integer.TYPE));
        map.put("getNegativePolicy", DnsCacheManipulator.class.getMethod("getDnsNegativeCachePolicy", new Class[0]));
        actionList = new ArrayList(map.keySet());
        map.put(FILE_KEY, null);
        action2Method = map;
    }

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"})
    public static List<String> getActionList() {
        try {
            DcmAgent.initAction2Method();
            return (List)actionList.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("fail to getActionList, cause: " + e, e);
        }
    }

    @Nullable
    private static String getConfig(@Nonnull String name) {
        String var = System.getenv(name);
        if (var == null || var.trim().isEmpty()) {
            var = System.getProperty(name);
        }
        return var;
    }

    @Nonnull
    private static String join(@Nonnull List<String> list) {
        return DcmAgent.join(list, " ");
    }

    @Nonnull
    private static String join(@Nonnull List<String> list, @Nonnull String separator) {
        StringBuilder ret = new StringBuilder();
        for (String argument : list) {
            if (ret.length() > 0) {
                ret.append(separator);
            }
            ret.append(argument);
        }
        return ret.toString();
    }

    @Nonnull
    private static String throwable2StackString(@Nonnull Throwable e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)w, true));
        return w.toString();
    }
}

