/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.color;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.FloatRange;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.afollestad.materialdialogs.util.DialogUtils;

public class CircleView
extends FrameLayout {
    private final int borderWidthSmall;
    private final int borderWidthLarge;
    private final Paint outerPaint;
    private final Paint whitePaint;
    private final Paint innerPaint;
    private boolean selected;

    public CircleView(Context context) {
        this(context, null, 0);
    }

    public CircleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources r = this.getResources();
        this.borderWidthSmall = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)r.getDisplayMetrics());
        this.borderWidthLarge = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)r.getDisplayMetrics());
        this.whitePaint = new Paint();
        this.whitePaint.setAntiAlias(true);
        this.whitePaint.setColor(-1);
        this.innerPaint = new Paint();
        this.innerPaint.setAntiAlias(true);
        this.outerPaint = new Paint();
        this.outerPaint.setAntiAlias(true);
        this.update(-12303292);
        this.setWillNotDraw(false);
    }

    @ColorInt
    private static int translucentColor(int color) {
        float factor = 0.7f;
        int alpha = Math.round((float)Color.alpha((int)color) * 0.7f);
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    @ColorInt
    public static int shiftColor(@ColorInt int color, @FloatRange(from=0.0, to=2.0) float by) {
        if (by == 1.0f) {
            return color;
        }
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[2] = hsv[2] * by;
        return Color.HSVToColor((float[])hsv);
    }

    @ColorInt
    public static int shiftColorDown(@ColorInt int color) {
        return CircleView.shiftColor(color, 0.9f);
    }

    @ColorInt
    public static int shiftColorUp(@ColorInt int color) {
        return CircleView.shiftColor(color, 1.1f);
    }

    private void update(@ColorInt int color) {
        this.innerPaint.setColor(color);
        this.outerPaint.setColor(CircleView.shiftColorDown(color));
        Drawable selector = this.createSelector(color);
        if (Build.VERSION.SDK_INT >= 21) {
            int[][] states = new int[][]{{16842919}};
            int[] colors = new int[]{CircleView.shiftColorUp(color)};
            ColorStateList rippleColors = new ColorStateList((int[][])states, colors);
            this.setForeground((Drawable)new RippleDrawable(rippleColors, selector, null));
        } else {
            this.setForeground(selector);
        }
    }

    public void setBackgroundColor(@ColorInt int color) {
        this.update(color);
        this.requestLayout();
        this.invalidate();
    }

    public void setBackgroundResource(@ColorRes int color) {
        this.setBackgroundColor(DialogUtils.getColor((Context)this.getContext(), (int)color));
    }

    @Deprecated
    public void setBackground(Drawable background) {
        throw new IllegalStateException("Cannot use setBackground() on CircleView.");
    }

    @Deprecated
    public void setBackgroundDrawable(Drawable background) {
        throw new IllegalStateException("Cannot use setBackgroundDrawable() on CircleView.");
    }

    @Deprecated
    public void setActivated(boolean activated) {
        throw new IllegalStateException("Cannot use setActivated() on CircleView.");
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.requestLayout();
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, widthMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredWidth(), this.getMeasuredWidth());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int outerRadius = this.getMeasuredWidth() / 2;
        if (this.selected) {
            int whiteRadius = outerRadius - this.borderWidthLarge;
            int innerRadius = whiteRadius - this.borderWidthSmall;
            canvas.drawCircle((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), (float)outerRadius, this.outerPaint);
            canvas.drawCircle((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), (float)whiteRadius, this.whitePaint);
            canvas.drawCircle((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), (float)innerRadius, this.innerPaint);
        } else {
            canvas.drawCircle((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), (float)outerRadius, this.innerPaint);
        }
    }

    private Drawable createSelector(int color) {
        ShapeDrawable darkerCircle = new ShapeDrawable((Shape)new OvalShape());
        darkerCircle.getPaint().setColor(CircleView.translucentColor(CircleView.shiftColorUp(color)));
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)darkerCircle);
        return stateListDrawable;
    }

    public void showHint(int color) {
        int[] screenPos = new int[2];
        Rect displayFrame = new Rect();
        this.getLocationOnScreen(screenPos);
        this.getWindowVisibleDisplayFrame(displayFrame);
        Context context = this.getContext();
        int width = this.getWidth();
        int height = this.getHeight();
        int midy = screenPos[1] + height / 2;
        int referenceX = screenPos[0] + width / 2;
        if (ViewCompat.getLayoutDirection((View)this) == 0) {
            int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
            referenceX = screenWidth - referenceX;
        }
        Toast cheatSheet = Toast.makeText((Context)context, (CharSequence)String.format("#%06X", 0xFFFFFF & color), (int)0);
        if (midy < displayFrame.height()) {
            cheatSheet.setGravity(8388661, referenceX, screenPos[1] + height - displayFrame.top);
        } else {
            cheatSheet.setGravity(81, 0, height);
        }
        cheatSheet.show();
    }
}

