/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;

public final class HeaderUtil {
    public static final String HEADER_X_AMZ_META_PREFIX = "x-amz-meta-";
    private static final String RESPONSE_HEADER_CONTENT_TYPE = "response-content-type";
    private static final String RESPONSE_HEADER_CONTENT_LANGUAGE = "response-content-language";
    private static final String RESPONSE_HEADER_EXPIRES = "response-expires";
    private static final String RESPONSE_HEADER_CACHE_CONTROL = "response-cache-control";
    private static final String RESPONSE_HEADER_CONTENT_DISPOSITION = "response-content-disposition";
    private static final String RESPONSE_HEADER_CONTENT_ENCODING = "response-content-encoding";
    private static final String STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final String STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD_TRAILER = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD-TRAILER";
    private static final MediaType FALLBACK_MEDIA_TYPE = MediaType.APPLICATION_OCTET_STREAM;

    private HeaderUtil() {
    }

    public static Map<String, String> userMetadataHeadersFrom(S3ObjectMetadata s3ObjectMetadata) {
        HashMap<String, String> metadataHeaders = new HashMap<String, String>();
        if (s3ObjectMetadata.userMetadata() != null) {
            s3ObjectMetadata.userMetadata().forEach((key, value) -> {
                if (key.regionMatches(true, 0, HEADER_X_AMZ_META_PREFIX, 0, HEADER_X_AMZ_META_PREFIX.length())) {
                    metadataHeaders.put((String)key, (String)value);
                } else {
                    metadataHeaders.put(HEADER_X_AMZ_META_PREFIX + key, (String)value);
                }
            });
        }
        return metadataHeaders;
    }

    public static Map<String, String> storageClassHeadersFrom(S3ObjectMetadata s3ObjectMetadata) {
        HashMap<String, String> headers = new HashMap<String, String>();
        StorageClass storageClass = s3ObjectMetadata.storageClass();
        if (storageClass != null) {
            headers.put("x-amz-storage-class", storageClass.toString());
        }
        return headers;
    }

    public static Map<String, String> userMetadataFrom(HttpHeaders headers) {
        return HeaderUtil.parseHeadersToMap(headers, header -> header.regionMatches(true, 0, HEADER_X_AMZ_META_PREFIX, 0, HEADER_X_AMZ_META_PREFIX.length()));
    }

    public static Map<String, String> storeHeadersFrom(HttpHeaders headers) {
        return HeaderUtil.parseHeadersToMap(headers, header -> "Expires".equalsIgnoreCase((String)header) || "Content-Language".equalsIgnoreCase((String)header) || "Content-Disposition".equalsIgnoreCase((String)header) || "Content-Encoding".equalsIgnoreCase((String)header) && !HeaderUtil.isOnlyChunkedEncoding(headers) || "Cache-Control".equalsIgnoreCase((String)header));
    }

    public static Map<String, String> encryptionHeadersFrom(HttpHeaders headers) {
        return HeaderUtil.parseHeadersToMap(headers, header -> header.regionMatches(true, 0, "x-amz-server-side-encryption", 0, "x-amz-server-side-encryption".length()));
    }

    private static Map<String, String> parseHeadersToMap(HttpHeaders headers, Predicate<String> matcher) {
        return headers.entrySet().stream().map(entry -> {
            if (matcher.test((String)entry.getKey()) && entry.getValue() != null && !((List)entry.getValue()).isEmpty()) {
                String value = (String)((List)entry.getValue()).get(0);
                if (value != null && !value.isBlank()) {
                    return new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                }
                return null;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    public static boolean isV4Signed(HttpHeaders headers) {
        String sha256Header = headers.getFirst("x-amz-content-sha256");
        return sha256Header != null && (sha256Header.equals(STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD) || sha256Header.equals(STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD_TRAILER));
    }

    public static boolean isChunkedEncoding(HttpHeaders headers) {
        List contentEncodingHeaders = headers.get((Object)"Content-Encoding");
        return contentEncodingHeaders != null && contentEncodingHeaders.contains("aws-chunked");
    }

    private static boolean isOnlyChunkedEncoding(HttpHeaders headers) {
        List contentEncodingHeaders = headers.get((Object)"Content-Encoding");
        return contentEncodingHeaders != null && contentEncodingHeaders.size() == 1 && contentEncodingHeaders.contains("aws-chunked");
    }

    public static MediaType mediaTypeFrom(@Nullable String contentType) {
        try {
            return MediaType.parseMediaType((String)contentType);
        }
        catch (InvalidMediaTypeException e) {
            return FALLBACK_MEDIA_TYPE;
        }
    }

    public static Map<String, String> overrideHeadersFrom(Map<String, String> queryParams) {
        return queryParams.entrySet().stream().map(entry -> {
            String mapHeaderName = HeaderUtil.mapHeaderName((String)entry.getKey());
            if (!mapHeaderName.isBlank()) {
                return new AbstractMap.SimpleEntry<String, String>(mapHeaderName, (String)entry.getValue());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    public static Map<String, String> checksumHeaderFrom(S3ObjectMetadata s3ObjectMetadata) {
        ChecksumAlgorithm checksumAlgorithm = s3ObjectMetadata.checksumAlgorithm();
        String checksum = s3ObjectMetadata.checksum();
        return HeaderUtil.checksumHeaderFrom(checksum, checksumAlgorithm);
    }

    public static Map<String, String> checksumHeaderFrom(@Nullable String checksum, @Nullable ChecksumAlgorithm checksumAlgorithm) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (checksumAlgorithm != null && checksum != null) {
            headers.put(HeaderUtil.mapChecksumToHeader(checksumAlgorithm), checksum);
        }
        return headers;
    }

    public static @Nullable ChecksumAlgorithm checksumAlgorithmFromHeader(HttpHeaders headers) {
        if (headers.containsKey((Object)"x-amz-checksum-sha256")) {
            return ChecksumAlgorithm.SHA256;
        }
        if (headers.containsKey((Object)"x-amz-checksum-sha1")) {
            return ChecksumAlgorithm.SHA1;
        }
        if (headers.containsKey((Object)"x-amz-checksum-crc32")) {
            return ChecksumAlgorithm.CRC32;
        }
        if (headers.containsKey((Object)"x-amz-checksum-crc32c")) {
            return ChecksumAlgorithm.CRC32C;
        }
        if (headers.containsKey((Object)"x-amz-checksum-crc64nvme")) {
            return ChecksumAlgorithm.CRC64NVME;
        }
        if (headers.containsKey((Object)"x-amz-checksum-algorithm")) {
            String checksumAlgorithm = headers.getFirst("x-amz-checksum-algorithm");
            return ChecksumAlgorithm.fromString(checksumAlgorithm);
        }
        return null;
    }

    public static @Nullable ChecksumAlgorithm checksumAlgorithmFromSdk(HttpHeaders headers) {
        if (headers.containsKey((Object)"x-amz-sdk-checksum-algorithm")) {
            return ChecksumAlgorithm.fromString(headers.getFirst("x-amz-sdk-checksum-algorithm"));
        }
        return null;
    }

    public static @Nullable String checksumFrom(HttpHeaders headers) {
        if (headers.containsKey((Object)"x-amz-checksum-sha256")) {
            return headers.getFirst("x-amz-checksum-sha256");
        }
        if (headers.containsKey((Object)"x-amz-checksum-sha1")) {
            return headers.getFirst("x-amz-checksum-sha1");
        }
        if (headers.containsKey((Object)"x-amz-checksum-crc32")) {
            return headers.getFirst("x-amz-checksum-crc32");
        }
        if (headers.containsKey((Object)"x-amz-checksum-crc32c")) {
            return headers.getFirst("x-amz-checksum-crc32c");
        }
        if (headers.containsKey((Object)"x-amz-checksum-crc64nvme")) {
            return headers.getFirst("x-amz-checksum-crc64nvme");
        }
        return null;
    }

    public static String mapChecksumToHeader(ChecksumAlgorithm checksumAlgorithm) {
        return switch (checksumAlgorithm) {
            default -> throw new IncompatibleClassChangeError();
            case ChecksumAlgorithm.SHA256 -> "x-amz-checksum-sha256";
            case ChecksumAlgorithm.SHA1 -> "x-amz-checksum-sha1";
            case ChecksumAlgorithm.CRC32 -> "x-amz-checksum-crc32";
            case ChecksumAlgorithm.CRC32C -> "x-amz-checksum-crc32c";
            case ChecksumAlgorithm.CRC64NVME -> "x-amz-checksum-crc64nvme";
        };
    }

    private static String mapHeaderName(String name) {
        return switch (name) {
            case RESPONSE_HEADER_CACHE_CONTROL -> "Cache-Control";
            case RESPONSE_HEADER_CONTENT_DISPOSITION -> "Content-Disposition";
            case RESPONSE_HEADER_CONTENT_ENCODING -> "Content-Encoding";
            case RESPONSE_HEADER_CONTENT_LANGUAGE -> "Content-Language";
            case RESPONSE_HEADER_CONTENT_TYPE -> "Content-Type";
            case RESPONSE_HEADER_EXPIRES -> "Expires";
            default -> "";
        };
    }
}

