/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;

public class StoreCleaner
implements CommandLineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(StoreCleaner.class);
    private final File rootFolder;
    private final boolean retainFilesOnExit;

    public StoreCleaner(File rootFolder, boolean retainFilesOnExit) {
        this.rootFolder = rootFolder;
        this.retainFilesOnExit = retainFilesOnExit;
    }

    public void run(String ... args) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                LOG.info("Calling StoreCleaner destroy() with retainFilesOnExit={}", (Object)this.retainFilesOnExit);
                if (!this.retainFilesOnExit && this.rootFolder.exists()) {
                    Files.walk(this.rootFolder.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    LOG.info("Directory {} cleaned up via shutdown hook.", (Object)this.rootFolder);
                }
            }
            catch (IOException e) {
                LOG.error("Error cleaning up directory {}", (Object)this.rootFolder, (Object)e);
            }
        }));
    }
}

