/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.ChecksumType;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CompletedPart;
import com.adobe.testing.s3mock.dto.MultipartUpload;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Part;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.MultipartUploadInfo;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.store.StoreBase;
import com.adobe.testing.s3mock.util.DigestUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRange;

public class MultipartStore
extends StoreBase {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartStore.class);
    private static final String PART_SUFFIX = ".part";
    private static final String MULTIPART_UPLOAD_META_FILE = "multipartMetadata.json";
    static final String MULTIPARTS_FOLDER = "multiparts";
    private final Map<UUID, Object> lockStore = new ConcurrentHashMap<UUID, Object>();
    private final ObjectStore objectStore;
    private final ObjectMapper objectMapper;

    public MultipartStore(ObjectStore objectStore, ObjectMapper objectMapper) {
        this.objectStore = objectStore;
        this.objectMapper = objectMapper;
    }

    public MultipartUpload createMultipartUpload(BucketMetadata bucket, String key, UUID id, @Nullable String contentType, Map<String, String> storeHeaders, Owner owner, Owner initiator, Map<String, String> userMetadata, Map<String, String> encryptionHeaders, @Nullable List<Tag> tags, StorageClass storageClass, @Nullable ChecksumType checksumType, @Nullable ChecksumAlgorithm checksumAlgorithm) {
        UUID uploadId = UUID.randomUUID();
        if (!this.createPartsFolder(bucket, uploadId)) {
            LOG.error("Directories for storing multipart uploads couldn't be created. bucket={}, key={}, id={}, uploadId={}", new Object[]{bucket, key, id, uploadId});
            throw new IllegalStateException("Directories for storing multipart uploads couldn't be created.");
        }
        MultipartUpload upload = new MultipartUpload(checksumAlgorithm, ChecksumType.FULL_OBJECT, new Date(), initiator, key, owner, storageClass, uploadId.toString());
        MultipartUploadInfo multipartUploadInfo = new MultipartUploadInfo(upload, contentType, userMetadata, storeHeaders, encryptionHeaders, bucket.name(), storageClass, tags, null, checksumType, checksumAlgorithm, false);
        this.lockStore.putIfAbsent(uploadId, new Object());
        this.writeMetafile(bucket, multipartUploadInfo);
        return upload;
    }

    public List<MultipartUpload> listMultipartUploads(BucketMetadata bucketMetadata, @Nullable String prefix) {
        List<MultipartUpload> list;
        block9: {
            Path multipartsFolder = this.getMultipartsFolder(bucketMetadata);
            if (!multipartsFolder.toFile().exists()) {
                return Collections.emptyList();
            }
            DirectoryStream<Path> paths = Files.newDirectoryStream(multipartsFolder);
            try {
                list = StreamSupport.stream(paths.spliterator(), false).map(path -> {
                    String fileName = path.getFileName().toString();
                    return this.getUploadMetadata(bucketMetadata, UUID.fromString(fileName));
                }).filter(Objects::nonNull).filter(uploadMetadata -> !uploadMetadata.completed()).map(MultipartUploadInfo::upload).filter(upload -> prefix == null || prefix.isBlank() || upload.key().startsWith(prefix)).toList();
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not load buckets from data directory ", e);
                }
            }
            paths.close();
        }
        return list;
    }

    public @Nullable MultipartUploadInfo getMultipartUploadInfo(BucketMetadata bucketMetadata, UUID uploadId) {
        return this.getUploadMetadata(bucketMetadata, uploadId);
    }

    public MultipartUpload getMultipartUpload(BucketMetadata bucketMetadata, UUID uploadId, boolean includeCompleted) {
        MultipartUploadInfo uploadMetadata = this.getUploadMetadata(bucketMetadata, uploadId);
        if (uploadMetadata != null) {
            if (includeCompleted) {
                return uploadMetadata.upload();
            }
            if (uploadMetadata.completed()) {
                throw new IllegalArgumentException("No active MultipartUpload found with uploadId: " + String.valueOf(uploadId));
            }
            return uploadMetadata.upload();
        }
        throw new IllegalArgumentException("No MultipartUpload found with uploadId: " + String.valueOf(uploadId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortMultipartUpload(BucketMetadata bucket, UUID id, UUID uploadId) {
        MultipartUploadInfo multipartUploadInfo = this.getMultipartUploadInfo(bucket, uploadId);
        if (multipartUploadInfo != null) {
            Object object = this.lockStore.get(uploadId);
            synchronized (object) {
                try {
                    FileUtils.deleteDirectory((File)this.getPartsFolder(bucket, uploadId).toFile());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not delete multipart-directory " + String.valueOf(uploadId), e);
                }
                this.lockStore.remove(uploadId);
            }
        }
    }

    public String putPart(BucketMetadata bucket, UUID id, UUID uploadId, Integer partNumber, Path path, Map<String, String> encryptionHeaders) {
        File file = this.inputPathToFile(path, this.getPartPath(bucket, uploadId, partNumber));
        return DigestUtil.hexDigest(encryptionHeaders.get("x-amz-server-side-encryption-aws-kms-key-id"), file);
    }

    /*
     * Exception decompiling
     */
    public CompleteMultipartUploadResult completeMultipartUpload(BucketMetadata bucket, String key, UUID id, UUID uploadId, List<CompletedPart> parts, Map<String, String> encryptionHeaders, @Nullable MultipartUploadInfo uploadInfo, String location, @Nullable String checksum, @Nullable ChecksumAlgorithm checksumAlgorithm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private @Nullable String validateChecksums(MultipartUploadInfo uploadInfo, List<CompletedPart> completedParts, List<Path> partsPaths, @Nullable String checksum, @Nullable ChecksumAlgorithm checksumAlgorithm) {
        String checksumToValidate = checksum != null ? checksum : uploadInfo.checksum();
        ChecksumAlgorithm checksumAlgorithmToValidate = checksumAlgorithm != null ? checksumAlgorithm : uploadInfo.checksumAlgorithm();
        String checksumFor = this.checksumFor(partsPaths, uploadInfo);
        if (checksumAlgorithmToValidate != null) {
            for (CompletedPart part : completedParts) {
                if (part.checksum(checksumAlgorithmToValidate) != null) continue;
                throw S3Exception.completeRequestMissingChecksum(checksumAlgorithmToValidate.toString().toLowerCase(), part.partNumber());
            }
            if (checksumToValidate != null) {
                DigestUtil.verifyChecksum(checksumToValidate, checksumFor, checksumAlgorithmToValidate);
            }
        }
        return checksumFor;
    }

    private @Nullable String checksumFor(List<Path> paths, MultipartUploadInfo uploadInfo) {
        if (uploadInfo.checksumAlgorithm() != null) {
            return DigestUtil.checksumMultipart(paths, uploadInfo.checksumAlgorithm().toChecksumAlgorithm());
        }
        return null;
    }

    public List<Part> getMultipartUploadParts(BucketMetadata bucket, UUID id, UUID uploadId) {
        List<Part> list;
        block8: {
            Path partsPath = this.getPartsFolder(bucket, uploadId);
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(partsPath, path -> path.getFileName().toString().endsWith(PART_SUFFIX));
            try {
                list = StreamSupport.stream(directoryStream.spliterator(), false).map(path -> {
                    String name = path.getFileName().toString();
                    String prefix = name.substring(0, name.indexOf(46));
                    int partNumber = Integer.parseInt(prefix);
                    String partMd5 = DigestUtil.hexDigest(path.toFile());
                    Date lastModified = new Date(path.toFile().lastModified());
                    return new Part(partNumber, partMd5, lastModified, path.toFile().length());
                }).sorted(Comparator.comparing(Part::partNumber)).toList();
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format("Could not read all parts. bucket=%s, id=%s, uploadId=%s", bucket, id, uploadId), e);
                }
            }
            directoryStream.close();
        }
        return list;
    }

    public String copyPart(BucketMetadata bucket, UUID id, @Nullable HttpRange copyRange, Integer partNumber, BucketMetadata destinationBucket, UUID destinationId, UUID uploadId, @Nullable Map<String, String> encryptionHeaders, @Nullable String versionId) {
        this.verifyMultipartUploadPreparation(destinationBucket, destinationId, uploadId);
        return this.copyPartToFile(bucket, id, copyRange, this.createPartFile(destinationBucket, destinationId, uploadId, partNumber), versionId);
    }

    private static InputStream toInputStream(List<Path> paths) {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        for (Path path : paths) {
            try {
                result.add(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't access path " + String.valueOf(path), e);
            }
        }
        return new SequenceInputStream(Collections.enumeration(result));
    }

    private String copyPartToFile(BucketMetadata bucket, UUID id, @Nullable HttpRange copyRange, File partFile, @Nullable String versionId) {
        block22: {
            long from = 0L;
            S3ObjectMetadata s3ObjectMetadata = this.objectStore.getS3ObjectMetadata(bucket, id, versionId);
            long len = s3ObjectMetadata.dataPath().toFile().length();
            if (copyRange != null) {
                from = copyRange.getRangeStart(len);
                len = copyRange.getRangeEnd(len) - copyRange.getRangeStart(len) + 1L;
            }
            try (FileInputStream sourceStream = FileUtils.openInputStream((File)s3ObjectMetadata.dataPath().toFile());
                 OutputStream targetStream = Files.newOutputStream(partFile.toPath(), new OpenOption[0]);){
                long skip = sourceStream.skip(from);
                if (skip == from) {
                    try (BoundedInputStream bis = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)sourceStream)).setMaxCount(len)).get();){
                        bis.transferTo(targetStream);
                        break block22;
                    }
                }
                throw new IllegalStateException("Could not skip exact byte range");
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not copy object. bucket=%s, id=%s, range=%s, partFile=%s", bucket, id, copyRange, partFile), e);
            }
        }
        return DigestUtil.hexDigest(partFile);
    }

    private File createPartFile(BucketMetadata bucket, UUID id, UUID uploadId, Integer partNumber) {
        File partFile = this.getPartPath(bucket, uploadId, partNumber).toFile();
        try {
            if (!partFile.exists() && !partFile.createNewFile()) {
                throw new IllegalStateException(String.format("Could not create buffer file. bucket=%s, id=%s, uploadId=%s, partNumber=%s", bucket, id, uploadId, partNumber));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not create buffer file. bucket=%s, id=%s, uploadId=%s, partNumber=%s", bucket, id, uploadId, partNumber), e);
        }
        return partFile;
    }

    private void verifyMultipartUploadPreparation(BucketMetadata bucket, @Nullable UUID id, UUID uploadId) {
        Path partsFolder = null;
        MultipartUploadInfo multipartUploadInfo = this.getMultipartUploadInfo(bucket, uploadId);
        if (id != null) {
            partsFolder = this.getPartsFolder(bucket, uploadId);
        }
        if (multipartUploadInfo == null || partsFolder == null || !partsFolder.toFile().exists() || !partsFolder.toFile().isDirectory()) {
            throw new IllegalStateException(String.format("Multipart Request was not prepared. bucket=%s, id=%s, uploadId=%s, partsFolder=%s", bucket, id, uploadId, partsFolder));
        }
    }

    private boolean createPartsFolder(BucketMetadata bucket, UUID uploadId) {
        File partsFolder = this.getPartsFolder(bucket, uploadId).toFile();
        return partsFolder.mkdirs();
    }

    private Path getMultipartsFolder(BucketMetadata bucket) {
        return Paths.get(bucket.path().toString(), MULTIPARTS_FOLDER);
    }

    private Path getPartPath(BucketMetadata bucket, UUID uploadId, Integer partNumber) {
        return this.getPartsFolder(bucket, uploadId).resolve(partNumber + PART_SUFFIX);
    }

    private Path getUploadMetadataPath(BucketMetadata bucket, UUID uploadId) {
        return this.getPartsFolder(bucket, uploadId).resolve(MULTIPART_UPLOAD_META_FILE);
    }

    private Path getPartsFolder(BucketMetadata bucket, UUID uploadId) {
        return this.getMultipartsFolder(bucket).resolve(uploadId.toString());
    }

    private @Nullable MultipartUploadInfo getUploadMetadata(BucketMetadata bucket, UUID uploadId) {
        Path metaPath = this.getUploadMetadataPath(bucket, uploadId);
        if (Files.exists(metaPath, new LinkOption[0])) {
            Object object = this.lockStore.get(uploadId);
            synchronized (object) {
                try {
                    return (MultipartUploadInfo)this.objectMapper.readValue(metaPath.toFile(), MultipartUploadInfo.class);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read upload metadata-file " + String.valueOf(uploadId), e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetafile(BucketMetadata bucket, MultipartUploadInfo uploadInfo) {
        String uploadId = uploadInfo.upload().uploadId();
        try {
            Object object = this.lockStore.get(UUID.fromString(uploadId));
            synchronized (object) {
                File metaFile = this.getUploadMetadataPath(bucket, UUID.fromString(uploadId)).toFile();
                this.objectMapper.writeValue(metaFile, (Object)uploadInfo);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write upload metadata-file " + uploadId, e);
        }
    }

    private static /* synthetic */ void lambda$completeMultipartUpload$4(Path partPath) {
        FileUtils.deleteQuietly((File)partPath.toFile());
    }

    private static /* synthetic */ Path lambda$completeMultipartUpload$3(Path partFolder, CompletedPart part) {
        return Paths.get(partFolder.toString(), part.partNumber() + PART_SUFFIX);
    }
}

