/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.dto.BucketInfo;
import com.adobe.testing.s3mock.dto.BucketLifecycleConfiguration;
import com.adobe.testing.s3mock.dto.LocationInfo;
import com.adobe.testing.s3mock.dto.ObjectLockConfiguration;
import com.adobe.testing.s3mock.dto.ObjectOwnership;
import com.adobe.testing.s3mock.dto.VersioningConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jspecify.annotations.Nullable;

public record BucketMetadata(String name, String creationDate, @Nullable VersioningConfiguration versioningConfiguration, @Nullable ObjectLockConfiguration objectLockConfiguration, @Nullable BucketLifecycleConfiguration bucketLifecycleConfiguration, @Nullable ObjectOwnership objectOwnership, Path path, String bucketRegion, @Nullable BucketInfo bucketInfo, @Nullable LocationInfo locationInfo, Map<String, UUID> objects) {
    public BucketMetadata(String name, String creationDate, @Nullable VersioningConfiguration versioningConfiguration, @Nullable ObjectLockConfiguration objectLockConfiguration, @Nullable BucketLifecycleConfiguration bucketLifecycleConfiguration, @Nullable ObjectOwnership objectOwnership, Path path, String bucketRegion, @Nullable BucketInfo bucketInfo, @Nullable LocationInfo locationInfo) {
        this(name, creationDate, versioningConfiguration, objectLockConfiguration, bucketLifecycleConfiguration, objectOwnership, path, bucketRegion, bucketInfo, locationInfo, new HashMap<String, UUID>());
    }

    public BucketMetadata withVersioningConfiguration(VersioningConfiguration versioningConfiguration) {
        return new BucketMetadata(this.name(), this.creationDate(), versioningConfiguration, this.objectLockConfiguration(), this.bucketLifecycleConfiguration(), this.objectOwnership(), this.path(), this.bucketRegion(), this.bucketInfo(), this.locationInfo());
    }

    public BucketMetadata withObjectLockConfiguration(ObjectLockConfiguration objectLockConfiguration) {
        return new BucketMetadata(this.name(), this.creationDate(), this.versioningConfiguration(), objectLockConfiguration, this.bucketLifecycleConfiguration(), this.objectOwnership(), this.path(), this.bucketRegion(), this.bucketInfo(), this.locationInfo());
    }

    public BucketMetadata withBucketLifecycleConfiguration(@Nullable BucketLifecycleConfiguration bucketLifecycleConfiguration) {
        return new BucketMetadata(this.name(), this.creationDate(), this.versioningConfiguration(), this.objectLockConfiguration(), bucketLifecycleConfiguration, this.objectOwnership(), this.path(), this.bucketRegion(), this.bucketInfo(), this.locationInfo());
    }

    public boolean doesKeyExist(String key) {
        return this.getID(key) != null;
    }

    public UUID addKey(String key) {
        if (this.doesKeyExist(key)) {
            return this.getID(key);
        }
        UUID uuid = UUID.randomUUID();
        this.objects.put(key, uuid);
        return uuid;
    }

    public boolean removeKey(String key) {
        UUID removed = this.objects.remove(key);
        return removed != null;
    }

    public @Nullable UUID getID(String key) {
        return this.objects.get(key);
    }

    @JsonIgnore
    public boolean isVersioningEnabled() {
        return this.versioningConfiguration() != null && this.versioningConfiguration().status() != null && this.versioningConfiguration().status() == VersioningConfiguration.Status.ENABLED;
    }

    @JsonIgnore
    public boolean isVersioningSuspended() {
        return this.versioningConfiguration() != null && this.versioningConfiguration().status() != null && this.versioningConfiguration().status() == VersioningConfiguration.Status.SUSPENDED;
    }
}

