/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.S3Verified;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

@S3Verified(year=2025)
public enum ChecksumType {
    COMPOSITE("COMPOSITE"),
    FULL_OBJECT("FULL_OBJECT");

    private final String value;

    @JsonCreator
    private ChecksumType(String value) {
        this.value = value;
    }

    public static ChecksumType fromString(String value) {
        return switch (value) {
            case "composite" -> COMPOSITE;
            case "full_object" -> FULL_OBJECT;
            default -> null;
        };
    }

    @JsonValue
    public String toString() {
        return String.valueOf(this.value);
    }
}

