/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.S3Verified;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import software.amazon.awssdk.checksums.DefaultChecksumAlgorithm;

@S3Verified(year=2025)
public enum ChecksumAlgorithm {
    CRC32("CRC32"),
    CRC32C("CRC32C"),
    CRC64NVME("CRC64NVME"),
    SHA1("SHA1"),
    SHA256("SHA256");

    private final String value;

    @JsonCreator
    private ChecksumAlgorithm(String value) {
        this.value = value;
    }

    public static ChecksumAlgorithm fromString(String value) {
        return switch (value) {
            case "sha256", "SHA256" -> SHA256;
            case "sha1", "SHA1" -> SHA1;
            case "crc32", "CRC32" -> CRC32;
            case "crc32c", "CRC32C" -> CRC32C;
            case "crc64nvme", "CRC64NVME" -> CRC64NVME;
            default -> null;
        };
    }

    public static ChecksumAlgorithm fromHeader(String value) {
        return switch (value) {
            case "x-amz-checksum-sha256" -> SHA256;
            case "x-amz-checksum-sha1" -> SHA1;
            case "x-amz-checksum-crc32" -> CRC32;
            case "x-amz-checksum-crc32c" -> CRC32C;
            case "x-amz-checksum-crc64nvme" -> CRC64NVME;
            default -> null;
        };
    }

    public software.amazon.awssdk.checksums.spi.ChecksumAlgorithm toChecksumAlgorithm() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> DefaultChecksumAlgorithm.CRC32;
            case 1 -> DefaultChecksumAlgorithm.CRC32C;
            case 2 -> DefaultChecksumAlgorithm.CRC64NVME;
            case 3 -> DefaultChecksumAlgorithm.SHA1;
            case 4 -> DefaultChecksumAlgorithm.SHA256;
        };
    }

    @JsonValue
    public String toString() {
        return String.valueOf(this.value);
    }
}

