/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.S3Object;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.EtagUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public record ObjectVersion(@JsonProperty(value="Key") String key, @JsonProperty(value="LastModified") String lastModified, @JsonProperty(value="ETag") String etag, @JsonProperty(value="Size") String size, @JsonProperty(value="StorageClass") StorageClass storageClass, @JsonProperty(value="Owner") Owner owner, @JsonProperty(value="ChecksumAlgorithm") ChecksumAlgorithm checksumAlgorithm, @JsonProperty(value="IsLatest") Boolean isLatest, @JsonProperty(value="VersionId") String versionId) {
    public ObjectVersion {
        etag = EtagUtil.normalizeEtag(etag);
    }

    public static ObjectVersion from(S3ObjectMetadata s3ObjectMetadata) {
        return new ObjectVersion(s3ObjectMetadata.key(), s3ObjectMetadata.modificationDate(), s3ObjectMetadata.etag(), s3ObjectMetadata.size(), s3ObjectMetadata.storageClass(), s3ObjectMetadata.owner(), s3ObjectMetadata.checksumAlgorithm(), true, "staticVersion");
    }

    public static ObjectVersion from(S3Object s3Object) {
        return new ObjectVersion(s3Object.key(), s3Object.lastModified(), s3Object.etag(), s3Object.size(), s3Object.storageClass(), s3Object.owner(), s3Object.checksumAlgorithm(), true, "staticVersion");
    }
}

