/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ChecksumAlgorithm {
    CRC32("CRC32"),
    CRC32C("CRC32C"),
    SHA1("SHA1"),
    SHA256("SHA256");

    private final String value;

    @JsonCreator
    private ChecksumAlgorithm(String value) {
        this.value = value;
    }

    public static ChecksumAlgorithm fromString(String value) {
        return switch (value) {
            case "sha256", "SHA256" -> SHA256;
            case "sha1", "SHA1" -> SHA1;
            case "crc32", "CRC32" -> CRC32;
            case "crc32c", "CRC32C" -> CRC32C;
            default -> null;
        };
    }

    @JsonValue
    public String toString() {
        return String.valueOf(this.value);
    }
}

