/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.fd.content.fdinternal.exceptions.ContentException;
import com.adobe.fd.content.fdinternal.model.SchemaRefType;
import com.adobe.fd.content.fdinternal.util.ContentAssetUtil;
import com.adobe.fd.df.fdinternal.util.DFUtil;
import com.adobe.forms.foundation.service.util.FormsFoundationUtils;
import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.dbforms.obj.Asset;
import com.adobe.icc.dbforms.obj.AssetType;
import com.adobe.icc.dbforms.obj.ContainerLayout;
import com.adobe.icc.dbforms.obj.ContainerLayoutAssignment;
import com.adobe.icc.dbforms.obj.ExternalAssetType;
import com.adobe.icc.dbforms.obj.Letter;
import com.adobe.icc.dbforms.obj.TableRow;
import com.adobe.icc.dbforms.obj.TargetAreaAssignment;
import com.adobe.icc.dbforms.obj.VariableAssignment;
import com.adobe.icc.dbforms.util.JCRSessionUtils;
import com.adobe.icc.dbforms.util.TempFileManager;
import com.adobe.idp.um.api.infomodel.Role;
import com.adobe.livecycle.content.appcontext.AppContext;
import com.adobe.livecycle.content.appcontext.AppContextManager;
import com.adobe.livecycle.content.sling.ResourceResolverHolder;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ACMUtil {
    private static final String CONTENT_APPS_FOLDER = "/content/apps";
    public static final String DEFAULT_APPS_CONTEXT = "/content/apps/cm";
    private static final String ACM_CONFIGURATION_FOLDER = "fd/cm/config";
    public static final String DEFAULT_APP_CONFIG_FOLDER = "/defaultApp";
    private static final String RUN_MODE_PUBLISH = "publish";
    public static final String DEFAULT_EXTERNAL_ASSETS_FOLDER = "/content/dam";
    public static final String TAGS_FOLDER = "/content/cq:tags/";
    private static final String XDP = ".xdp";
    private static final Logger logger = LoggerFactory.getLogger((String)ACMUtil.class.getName());
    private static FormsFoundationUtils formsFoundationUtils;

    public static String getConfigFolderForBB() {
        return ACM_CONFIGURATION_FOLDER;
    }

    public static String getAppName() {
        String path = "";
        String contentAppFolder = "/content/apps/";
        AppContext appContext = AppContextManager.getCurrentAppContext();
        if (appContext == null) {
            throw new ICCException("ALC-ACM-004-003", 1);
        }
        String currentAppContext = appContext.getAppRoot();
        if (currentAppContext.startsWith(contentAppFolder)) {
            path = currentAppContext.substring(contentAppFolder.length());
        }
        return path;
    }

    public static String getSolutionSpecficConfigFolderForBB() throws ICCException {
        AppContext appContext = AppContextManager.getCurrentAppContext();
        if (appContext == null) {
            throw new ICCException("ALC-ACM-004-003", 1);
        }
        String currentAppContext = appContext.getAppRoot();
        if (DEFAULT_APPS_CONTEXT.equals(currentAppContext)) {
            return TempFileManager.getResolvedResourcePath(null, ACMUtil.getConfigFolderForBB() + DEFAULT_APP_CONFIG_FOLDER);
        }
        if (currentAppContext.startsWith(CONTENT_APPS_FOLDER)) {
            String path = TempFileManager.getResolvedResourcePath(null, ACMUtil.getConfigFolderForBB() + currentAppContext.substring(CONTENT_APPS_FOLDER.length()));
            try {
                if (path == null || path.isEmpty()) {
                    path = TempFileManager.getResolvedResourcePath(null, ACMUtil.getConfigFolderForBB() + DEFAULT_APP_CONFIG_FOLDER);
                    logger.info("Unable to find the Node in selected app context : " + path + " switching to default app context ");
                }
            }
            catch (ICCException ex) {
                logger.error("Error in checking nodeExists : ", (Throwable)ex);
                path = TempFileManager.getResolvedResourcePath(null, ACMUtil.getConfigFolderForBB() + DEFAULT_APP_CONFIG_FOLDER);
                logger.info("Unable to find the Node in selected app context : " + path + " switching to default app context ");
            }
            return path;
        }
        return TempFileManager.getResolvedResourcePath(null, ACMUtil.getConfigFolderForBB() + currentAppContext);
    }

    public static boolean loggedInUserHasRole(String roleName) throws ICCException {
        try {
            ResourceResolver resourceResolver = ResourceResolverHolder.getResourceResolver();
            if (resourceResolver != null) {
                com.adobe.idp.um.api.infomodel.User lcUser = (com.adobe.idp.um.api.infomodel.User)resourceResolver.adaptTo(com.adobe.idp.um.api.infomodel.User.class);
                if (lcUser == null) {
                    return ACMUtil.isLoggedInCRXUserMemberOf(resourceResolver, roleName);
                }
                return ACMUtil.isLoggedInLCUserMemberOf(resourceResolver, roleName);
            }
            return false;
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-004-002", 1, e);
        }
    }

    private static boolean isLoggedInCRXUserMemberOf(ResourceResolver resourceResolver, String groupName) throws ICCException {
        try {
            if (resourceResolver != null) {
                String userId = resourceResolver.getUserID();
                UserManager userManager = AccessControlUtil.getUserManager((Session)JCRSessionUtils.getCurrentSession());
                User user = (User)userManager.getAuthorizable(userId);
                if (user != null) {
                    if (user.isAdmin()) {
                        return true;
                    }
                    Iterator grpItr = user.memberOf();
                    while (grpItr.hasNext()) {
                        Group group = (Group)grpItr.next();
                        if (!groupName.equals(group.getID())) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-004-002", 1, e);
        }
    }

    private static boolean isLoggedInLCUserMemberOf(ResourceResolver resourceResolver, String groupName) throws ICCException {
        try {
            ArrayList<String> userGroups = new ArrayList<String>();
            ACMUtil.addGroupMembershipForLCUser(resourceResolver, userGroups);
            for (String groupID : userGroups) {
                if (!groupID.equals(groupName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-004-002", 1, e);
        }
    }

    public static void addGroupMembershipForLCUser(ResourceResolver resourceResolver, ArrayList<String> userGroups) {
        if (resourceResolver == null) {
            return;
        }
        com.adobe.idp.um.api.infomodel.User lcUser = (com.adobe.idp.um.api.infomodel.User)resourceResolver.adaptTo(com.adobe.idp.um.api.infomodel.User.class);
        if (lcUser != null) {
            Set roles = lcUser.getRoleMembership();
            if (roles != null) {
                for (Object objRole : roles) {
                    Role role = (Role)objRole;
                    if (role == null || userGroups.contains(role.getId())) continue;
                    userGroups.add(role.getId());
                    try {
                        UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
                        Group crxGroup = (Group)userManager.getAuthorizable(role.getId());
                        if (crxGroup == null) continue;
                        Iterator grpItr = crxGroup.memberOf();
                        while (grpItr.hasNext()) {
                            Group group = (Group)grpItr.next();
                            if (userGroups.contains(group.getID())) continue;
                            userGroups.add(group.getID());
                        }
                    }
                    catch (RepositoryException e) {
                        logger.error("Error occurred while retrieving CRX group membership of livecycle role " + role.getId(), (Throwable)e);
                    }
                }
            }
        } else {
            Object[] args = new Object[]{resourceResolver.getUserID()};
            logger.debug("The user {0} is not a Livecycle user. So no group added to the list provided.", args);
        }
    }

    public static boolean isAuthorInstance(SlingSettingsService slingSettingsService) {
        Set runModes = slingSettingsService.getRunModes();
        return !runModes.contains(RUN_MODE_PUBLISH);
    }

    public static AssetType getAssetType(String assetId) {
        return ContentAssetUtil.getAssetType((String)assetId);
    }

    public static ExternalAssetType getExternalAssetTypeName(String assetId) {
        return ContentAssetUtil.getExternalAssetTypeName((String)assetId);
    }

    public static Object xmlEscapeObject(Object object) {
        return DFUtil.xmlEscapeObject((Object)object);
    }

    public static String xmlEscapeTextContent(String content) {
        return DFUtil.xmlEscapeTextContent((String)content);
    }

    public static <T extends Asset> void findAllChildAssets(Object obj, Class assetType, Map<String, T> allAssets) throws ICCException {
        try {
            PropertyDescriptor[] propDescriptors;
            for (PropertyDescriptor propDescriptor : propDescriptors = PropertyUtils.getPropertyDescriptors((Object)obj)) {
                Object tempValue;
                List<Object> objValues = new ArrayList();
                Class<?> fieldClass = propDescriptor.getPropertyType();
                boolean isArray = fieldClass.isArray();
                boolean isCollection = false;
                if (!isArray && Collection.class.isAssignableFrom(fieldClass)) {
                    isCollection = true;
                }
                if (isArray) {
                    Class<?> arrayDataType = fieldClass.getComponentType();
                    if (Byte.class.isAssignableFrom(arrayDataType) || Byte.TYPE.isAssignableFrom(arrayDataType)) continue;
                    Object tempValue2 = PropertyUtils.getProperty((Object)obj, (String)propDescriptor.getName());
                    if (tempValue2 != null) {
                        objValues = Arrays.asList(tempValue2);
                    }
                } else if (isCollection && (tempValue = (Collection)PropertyUtils.getProperty((Object)obj, (String)propDescriptor.getName())) != null) {
                    objValues.addAll((Collection<Object>)tempValue);
                }
                if (isArray || isCollection) {
                    if (objValues == null || objValues.size() <= 0) continue;
                    tempValue = objValues.iterator();
                    while (tempValue.hasNext()) {
                        Object collObj = tempValue.next();
                        if (assetType.isAssignableFrom(collObj.getClass()) && !(collObj instanceof TableRow)) {
                            if (allAssets.containsKey(((Asset)collObj).getId())) continue;
                            allAssets.put(((Asset)collObj).getId(), (Asset)collObj);
                        }
                        if (collObj.getClass().getPackage() == null || !collObj.getClass().getPackage().getName().equals("com.adobe.icc.dbforms.obj")) continue;
                        ACMUtil.findAllChildAssets(collObj, assetType, allAssets);
                    }
                    continue;
                }
                Object childObj = PropertyUtils.getProperty((Object)obj, (String)propDescriptor.getName());
                if (childObj == null) continue;
                if (assetType.isAssignableFrom(childObj.getClass()) && !(childObj instanceof TableRow)) {
                    if (allAssets.containsKey(((Asset)childObj).getId())) continue;
                    allAssets.put(((Asset)childObj).getId(), (Asset)childObj);
                }
                if (childObj.getClass() == null || !childObj.getClass().getPackage().getName().equals("com.adobe.icc.dbforms.obj")) continue;
                ACMUtil.findAllChildAssets(childObj, assetType, allAssets);
            }
        }
        catch (Exception ex) {
            throw new ICCException("ALC-ACM-002-013", 1, ex);
        }
    }

    public static boolean usesFragments(Letter letter) {
        if (letter.getTargetAreaAssignments() != null) {
            for (TargetAreaAssignment taa : letter.getTargetAreaAssignments()) {
                if (taa.getContainerLayoutAssignmentList() == null || taa.getContainerLayoutAssignmentList().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean usesConditionalFragments(Set<TargetAreaAssignment> taaSet) {
        if (taaSet != null) {
            for (TargetAreaAssignment taa : taaSet) {
                if (taa.getContainerLayoutAssignmentList() == null) continue;
                for (ContainerLayoutAssignment cla : taa.getContainerLayoutAssignmentList()) {
                    if (cla.getExpression() != null && cla.getExpression().length() > 0) {
                        return true;
                    }
                    if (!ACMUtil.usesConditionalFragments(cla.getTargetAreaAssignments())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void populateAllFragments(Set<TargetAreaAssignment> taaSet, Map<String, Asset> assetMap) {
        if (taaSet != null) {
            for (TargetAreaAssignment taa : taaSet) {
                if (taa.getContainerLayoutAssignmentList() == null) continue;
                for (ContainerLayoutAssignment cla : taa.getContainerLayoutAssignmentList()) {
                    ContainerLayout cl = cla.getContainerLayout();
                    assetMap.put(cl.getId(), cl);
                    ACMUtil.populateAllFragments(cla.getTargetAreaAssignments(), assetMap);
                }
            }
        }
    }

    public static Map<String, Date> getLastModifyTimeForAssets(List<String> assetIds) {
        try {
            return ContentAssetUtil.getLastModifyTimeForAssets(assetIds);
        }
        catch (ContentException e) {
            throw new ICCException(e);
        }
    }

    public static boolean isExternalAsset(String assetId) {
        return ContentAssetUtil.isExternalAsset((String)assetId);
    }

    public static String getNameFromId(String id) {
        return ContentAssetUtil.getNameFromId((String)id);
    }

    public static void setFormsFoundationUtils(FormsFoundationUtils ffu) {
        formsFoundationUtils = ffu;
    }

    public static SchemaRefType getSchemaRefType(String schemaRefId) {
        if (!StringUtils.isEmpty((CharSequence)schemaRefId)) {
            if (schemaRefId.startsWith("/content/apps/cm/datadictionaries")) {
                return SchemaRefType.DATA_DICTIONARY;
            }
            if (schemaRefId.startsWith("/content/dam/formsanddocuments-fdm")) {
                return SchemaRefType.FORM_DATA_MODEL;
            }
        }
        return null;
    }

    public static Map<String, VariableAssignment> getVariableAssignmentsMap(Letter letter) {
        HashMap<String, VariableAssignment> varAssignmentsMap = new HashMap<String, VariableAssignment>();
        if (letter != null && letter.getVariableAssignments() != null) {
            letter.getVariableAssignments().forEach(va -> varAssignmentsMap.put(va.getVariable().getName(), (VariableAssignment)va));
        }
        return varAssignmentsMap;
    }
}

