/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.exceptions;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionMessages {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionMessages.class);
    private static final String BUNDLE_NAME = "com.adobe.icc.exceptions.exceptions";
    public static final int LOG_FATAL = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARN = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.adobe.icc.exceptions.exceptions");

    private ExceptionMessages() {
    }

    public static String getString(String key) {
        try {
            if (StringUtils.isNotEmpty((String)key)) {
                return RESOURCE_BUNDLE.getString(key);
            }
            return "";
        }
        catch (MissingResourceException e) {
            logger.debug("Error in finding resource.", (Throwable)e);
            return "";
        }
    }

    public static void logMessage(Class class1, int severity, String resourceID, String[] args) {
        Logger logger = LoggerFactory.getLogger((Class)class1);
        ExceptionMessages.logMessage(logger, ExceptionMessages.getString(resourceID, args), severity, null);
    }

    public static void logMessage(Class class1, int severity, String resourceID, String[] args, Throwable cause) {
        Logger logger = LoggerFactory.getLogger((Class)class1);
        String logMessage = ExceptionMessages.getString(resourceID, args);
        ExceptionMessages.logMessage(logger, logMessage, severity, cause);
    }

    private static void logMessage(Logger logger, String logString, int severity, Throwable cause) {
        switch (severity) {
            case 0: 
            case 1: {
                if (cause == null) {
                    logger.error(logString);
                    break;
                }
                logger.error(logString, cause);
                break;
            }
            case 2: {
                logger.warn(logString);
                break;
            }
            case 3: {
                logger.info(logString);
                break;
            }
            default: {
                logger.debug(logString);
            }
        }
    }

    public static void logMessage(Class class1, int severity, String resourceID) {
        Logger logger = LoggerFactory.getLogger((Class)class1);
        ExceptionMessages.logMessage(logger, ExceptionMessages.getString(resourceID), severity, null);
    }

    public static String getString(String resourceID, Object[] args) {
        String str = ExceptionMessages.getString(resourceID);
        if (args != null) {
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                str = str.replace("{" + i + "}", args[i].toString());
            }
        }
        return str;
    }
}

