/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.encryption.client;

import com.adobe.fd.encryption.client.XMLEncryptionTarget;
import java.io.Serializable;
import java.util.Map;

public class XMLEncryptionOptionSpec
implements Serializable {
    private static final long serialVersionUID = 5146133277516703675L;
    private XMLEncryptionTarget encTarget;
    private Map<String, String> prefixMap;
    private String trueXPath;

    public XMLEncryptionOptionSpec(XMLEncryptionTarget encTarget, Map<String, String> prefixMap) {
        if (encTarget == null) {
            throw new NullPointerException("Null Target");
        }
        String xpath = encTarget.getXPath();
        boolean containsNS = xpath.contains(":");
        if (containsNS && (prefixMap == null || prefixMap.isEmpty())) {
            throw new NullPointerException("Null Prefix Map");
        }
        this.encTarget = encTarget;
        this.prefixMap = prefixMap;
        if (containsNS) {
            for (Map.Entry<String, String> entry : prefixMap.entrySet()) {
                String prefix = entry.getKey();
                String nsURI = entry.getValue();
                xpath = xpath.replaceAll(prefix + ":", nsURI + ":");
            }
        }
        this.trueXPath = xpath;
    }

    public XMLEncryptionTarget getEncTarget() {
        return this.encTarget;
    }

    public Map<String, String> getPrefixMap() {
        return this.prefixMap;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.trueXPath == null ? 0 : this.trueXPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLEncryptionOptionSpec other = (XMLEncryptionOptionSpec)obj;
        return !(this.trueXPath == null ? other.trueXPath != null : !this.trueXPath.equals(other.trueXPath));
    }

    public String getTrueXPath() {
        return this.trueXPath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EncTarget --> ").append(this.encTarget).append(" ");
        sb.append("Mappings --> ").append(this.prefixMap).append(" ");
        sb.append("TrueXpath --> ").append(this.trueXPath);
        return sb.toString();
    }
}

