/*
 * Decompiled with CFR 0.152.
 */
package com.adarshr.gradle.testlogger.theme;

import com.adarshr.gradle.testlogger.TestDescriptorWrapper;
import com.adarshr.gradle.testlogger.TestLoggerExtension;
import com.adarshr.gradle.testlogger.TestResultWrapper;
import com.adarshr.gradle.testlogger.theme.AbstractTheme;
import com.adarshr.gradle.testlogger.util.RendererUtils;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.tasks.testing.TestResult;

public class StandardTheme
extends AbstractTheme {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public StandardTheme(TestLoggerExtension extension) {
        super(extension);
    }

    @Override
    protected String suiteTextInternal(TestDescriptorWrapper descriptor) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{descriptor.getClassDisplayName(), System.lineSeparator()}, new String[]{"[erase-ahead,bold]", "[/]", ""}));
    }

    @Override
    protected String testTextInternal(TestDescriptorWrapper descriptor, TestResultWrapper result) {
        return this.testTextInternal(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{descriptor.getDisplayName()}, new String[]{"[erase-ahead,bold]  Test [bold-off]", ""})), descriptor, result);
    }

    protected String testTextInternal(String start, TestDescriptorWrapper descriptor, TestResultWrapper result) {
        StringBuilder line;
        block1: {
            TestResult.ResultType resultType;
            block2: {
                block0: {
                    line = new StringBuilder(start);
                    resultType = result.getResultType();
                    if (!ScriptBytecodeAdapter.isCase((Object)resultType, (Object)TestResult.ResultType.SUCCESS)) break block0;
                    StringGroovyMethods.leftShift((StringBuilder)line, (Object)"[green] PASSED");
                    this.showDurationIfSlow(result, line);
                    break block1;
                }
                if (!ScriptBytecodeAdapter.isCase((Object)resultType, (Object)TestResult.ResultType.FAILURE)) break block2;
                StringGroovyMethods.leftShift((StringBuilder)line, (Object)"[red] FAILED");
                this.showDurationIfSlow(result, line);
                StringGroovyMethods.leftShift((StringBuilder)line, (Object)this.exceptionText(descriptor, result));
                break block1;
            }
            if (!ScriptBytecodeAdapter.isCase((Object)resultType, (Object)TestResult.ResultType.SKIPPED)) break block1;
            StringGroovyMethods.leftShift((StringBuilder)line, (Object)"[yellow] SKIPPED");
        }
        return ShortTypeHandling.castToString((Object)StringGroovyMethods.leftShift((StringBuilder)line, (Object)"[/]"));
    }

    private void showDurationIfSlow(TestResultWrapper result, StringBuilder line) {
        if (result.isTooSlow()) {
            StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{result.getDuration()}, new String[]{"[red] (", ")"}));
        } else if (result.isMediumSlow()) {
            StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{result.getDuration()}, new String[]{"[yellow] (", ")"}));
        }
    }

    @Override
    protected String exceptionText(TestDescriptorWrapper descriptor, TestResultWrapper result, int indent) {
        String exceptionText = super.exceptionText(descriptor, result, indent);
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)exceptionText) ? new GStringImpl(new Object[]{exceptionText}, new String[]{"[red]", ""}) : ""));
    }

    @Override
    public String summaryText(TestDescriptorWrapper descriptor, TestResultWrapper result) {
        if (!this.extension.getShowSummary()) {
            return "";
        }
        String colour = ScriptBytecodeAdapter.compareEqual((Object)result.getResultType(), (Object)TestResult.ResultType.FAILURE) ? "red" : "green";
        StringBuilder line = new StringBuilder();
        StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{colour, result.getResultType()}, new String[]{"[erase-ahead,bold,", "]", ": "}));
        StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{result.getTestCount(), result.getDuration()}, new String[]{"[default]Executed ", " tests in ", ""}));
        List breakdown = StandardTheme.getBreakdown(result);
        if (DefaultTypeTransformation.booleanUnbox((Object)breakdown)) {
            StringGroovyMethods.leftShift((StringBuilder)StringGroovyMethods.leftShift((StringBuilder)StringGroovyMethods.leftShift((StringBuilder)line, (Object)" ("), (Object)DefaultGroovyMethods.join((Iterable)breakdown, (String)", ")), (Object)")");
        }
        return ShortTypeHandling.castToString((Object)StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{System.lineSeparator()}, new String[]{"[/]", ""})));
    }

    private static List getBreakdown(TestResultWrapper result) {
        List breakdown = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (result.getFailedTestCount() != 0L) {
            DefaultGroovyMethods.leftShift((List)breakdown, (Object)new GStringImpl(new Object[]{result.getFailedTestCount()}, new String[]{"", " failed"}));
        }
        if (result.getSkippedTestCount() != 0L) {
            DefaultGroovyMethods.leftShift((List)breakdown, (Object)new GStringImpl(new Object[]{result.getSkippedTestCount()}, new String[]{"", " skipped"}));
        }
        return breakdown;
    }

    @Override
    protected String suiteStandardStreamTextInternal(String lines) {
        return this.standardStreamTextInternal(lines, 2);
    }

    @Override
    protected String testStandardStreamTextInternal(String lines) {
        return this.standardStreamTextInternal(lines, 4);
    }

    protected String standardStreamTextInternal(String lines, int indent) {
        String string;
        if (!this.extension.getShowStandardStreams() || !DefaultTypeTransformation.booleanUnbox((Object)lines)) {
            return "";
        }
        lines = string = RendererUtils.escape(lines);
        Reference indentation = new Reference((Object)StringGroovyMethods.multiply((CharSequence)" ", (Number)indent));
        StringBuilder line = new StringBuilder((CharSequence)new GStringImpl(new Object[]{System.lineSeparator()}, new String[]{"[default]", ""}));
        public class _standardStreamTextInternal_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference indentation;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _standardStreamTextInternal_closure1(Object _outerInstance, Object _thisObject, Reference indentation) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.indentation = reference = indentation;
            }

            public Object doCall(Object it) {
                return new GStringImpl(new Object[]{this.indentation.get(), it}, new String[]{"", "", ""});
            }

            public Object getIndentation() {
                return this.indentation.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _standardStreamTextInternal_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        StringGroovyMethods.leftShift((StringBuilder)line, (Object)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)lines.split(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{System.lineSeparator()}, new String[]{"", ""}))), (Closure)new _standardStreamTextInternal_closure1(this, this, indentation)), (String)System.lineSeparator()));
        return ShortTypeHandling.castToString((Object)StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{System.lineSeparator()}, new String[]{"[/]", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StandardTheme.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }
}

