package co.condorlabs.loggerlibrary

import android.util.Log

/**
 * @author Felipe E Guerrero
 */
class LoggerImp : Logger {

    private val loggers = mutableListOf<LogService>()

    fun add(logService: LogService) {
        loggers.add(logService)
    }

    override fun v(message: String) {
        for (logger in loggers) {
            logger.v(Log.VERBOSE, message)
        }
    }

    override fun v(t: Throwable) {
        for (logger in loggers) {
            logger.v(Log.VERBOSE, t)
        }
    }

    override fun d(message: String) {
        for (logger in loggers) {
            logger.d(Log.DEBUG, message)
        }
    }

    override fun d(t: Throwable) {
        for (logger in loggers) {
            logger.d(Log.DEBUG, t)
        }
    }

    override fun i(message: String) {
        for (logger in loggers) {
            logger.i(Log.INFO, message)
        }
    }

    override fun i(t: Throwable) {
        for (logger in loggers) {
            logger.i(Log.INFO, t)
        }
    }

    override fun e(message: String) {
        for (logger in loggers) {
            logger.e(Log.ERROR, message)
        }
    }

    override fun e(t: Throwable) {
        for (logger in loggers) {
            logger.e(Log.ERROR, t)
        }
    }

    override fun w(message: String) {
        for (logger in loggers) {
            logger.w(Log.WARN, message)
        }
    }

    override fun w(t: Throwable) {
        for (logger in loggers) {
            logger.w(Log.WARN, t)
        }
    }

    override fun log(priority: Int, message: String) {
        for (logger in loggers) {
            logger.log(priority, message)
        }
    }

    override fun log(priority: Int, t: Throwable) {
        for (logger in loggers) {
            logger.log(priority, t)
        }
    }

    override fun logEvent(wEvent: LogEvent) {
        for (logger in loggers) {
            logger.logEvent(wEvent)
        }
    }

    override fun logKeyEvent(
        key: String,
        value: String
    ) {
        for (logger in loggers) {
            logger.logKeyEvent(key, value)
        }
    }

    override fun logKeyEvent(
        key: String,
        value: Boolean
    ) {
        for (logger in loggers) {
            logger.logKeyEvent(key, value)
        }
    }

    override fun logKeyEvent(
        key: String,
        value: Float
    ) {
        for (logger in loggers) {
            logger.logKeyEvent(key, value)
        }
    }

    override fun logKeyEvent(
        key: String,
        value: Double
    ) {
        for (logger in loggers) {
            logger.logKeyEvent(key, value)
        }
    }

    override fun logKeyEvent(
        key: String,
        value: Int
    ) {
        for (logger in loggers) {
            logger.logKeyEvent(key, value)
        }
    }
}
