/*
 * Decompiled with CFR 0.152.
 */
package cn.ymex.effect.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import cn.ymex.clickeffect.R;
import cn.ymex.effect.AlphaEffect;
import cn.ymex.effect.Effect;
import cn.ymex.effect.SelectorEffect;
import cn.ymex.effect.widget.ViewSurface;

public class ViewDepute {
    private Effect effect;
    private ViewSurface surface = new ViewSurface();
    public static final int EFFECT_MODEL_PRESS = 1;
    public static final int EFFECT_MODEL_FOCUS = 2;
    public static final int EFFECT_MODEL_BOTH = 3;
    public static final int EFFECT_MODEL_MANUAL = 4;
    private int effectModel = 3;

    private ViewDepute() {
    }

    public static ViewDepute instance() {
        return new ViewDepute();
    }

    public void dealAttrs(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EffectViewContainer);
        this.surface.defSelector = typedArray.getBoolean(R.styleable.EffectViewContainer_effect_xml_selector, false);
        this.surface.roundRadius = typedArray.getDimensionPixelSize(R.styleable.EffectViewContainer_effect_round_radius, 0);
        this.surface.topLeftRadius = typedArray.getDimensionPixelSize(R.styleable.EffectViewContainer_effect_top_left_radius, 0);
        this.surface.topRightRadius = typedArray.getDimensionPixelSize(R.styleable.EffectViewContainer_effect_top_right_radius, 0);
        this.surface.bottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.EffectViewContainer_effect_bottom_left_radius, 0);
        this.surface.bottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.EffectViewContainer_effect_bottom_right_radius, 0);
        this.surface.selectedBg = typedArray.getDrawable(R.styleable.EffectViewContainer_effect_selected_background);
        this.surface.selectedTextColor = typedArray.getColor(R.styleable.EffectViewContainer_effect_selected_text_color, 0);
        this.surface.strokeColor = typedArray.getColor(R.styleable.EffectViewContainer_effect_stroke_color, 0);
        this.surface.selectedStrokeColor = typedArray.getColor(R.styleable.EffectViewContainer_effect_selected_stroke_color, 0);
        this.surface.strokeWidth = typedArray.getDimensionPixelSize(R.styleable.EffectViewContainer_effect_stroke_width, 0);
        this.surface.selectedImage = typedArray.getDrawable(R.styleable.EffectViewContainer_effect_selected_image);
        if (this.surface.strokeWidth > 0 && this.surface.strokeColor != 0) {
            this.surface.selectedStrokeColor = this.surface.selectedStrokeColor != 0 ? this.surface.selectedStrokeColor : this.surface.strokeColor;
        }
        this.setEffectModel(typedArray.getInt(R.styleable.EffectViewContainer_effect_model, 3));
        String effectC = typedArray.getString(R.styleable.EffectViewContainer_effect);
        if (!TextUtils.isEmpty((CharSequence)effectC)) {
            try {
                Class<?> c = Class.forName(effectC);
                Object o = c.newInstance();
                if (o instanceof Effect) {
                    this.effect = (Effect)o;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        typedArray.recycle();
    }

    public void onViewFinishInflate(View proView) {
        View view;
        proView.setClickable(true);
        if (proView instanceof ViewGroup) {
            int childCount = ((ViewGroup)proView).getChildCount();
            if (childCount > 1) {
                throw new RuntimeException("just allow single view!");
            }
            view = ((ViewGroup)proView).getChildAt(0);
            if (view instanceof Button || view instanceof ImageButton) {
                view.setFocusable(false);
            }
        } else {
            proView.setFocusable(true);
            view = proView;
        }
        if (view == null) {
            return;
        }
        this.surface.bg = view.getBackground();
        this.setRoundRect(view);
        if (view instanceof TextView) {
            this.surface.textColor = ((TextView)view).getCurrentTextColor();
        }
        if (view instanceof ImageView) {
            this.surface.image = ((ImageView)view).getDrawable();
        }
        if (this.effect != null) {
            return;
        }
        this.effect = this.surface.defSelector ? new SelectorEffect() : (this.surface.selectedBg != null || this.surface.selectedTextColor != 0 || this.surface.selectedImage != null ? new SelectorEffect() : new AlphaEffect());
    }

    private void setRoundRect(View view) {
        if (this.surface.bg != null && this.surface.bg instanceof ColorDrawable) {
            int bgColor = ((ColorDrawable)this.surface.bg).getColor();
            this.surface.bg = this.createRoundRectDrawable(bgColor, this.surface.strokeWidth, this.surface.strokeColor);
            if (!this.surface.defSelector) {
                if (Build.VERSION.SDK_INT >= 16) {
                    view.setBackground(this.surface.bg);
                } else {
                    view.setBackgroundDrawable(this.surface.bg);
                }
            }
        }
        if (this.surface.selectedBg != null && this.surface.selectedBg instanceof ColorDrawable) {
            this.surface.selectedBg = this.createRoundRectDrawable(((ColorDrawable)this.surface.selectedBg).getColor(), this.surface.strokeWidth, this.surface.selectedStrokeColor);
        }
    }

    private Drawable createRoundRectDrawable(int bgcolor, int strokeWidth, int strokeColor) {
        float[] outerR = new float[]{this.surface.topLeftRadius, this.surface.topLeftRadius, this.surface.topRightRadius, this.surface.topRightRadius, this.surface.bottomRightRadius, this.surface.bottomRightRadius, this.surface.bottomLeftRadius, this.surface.bottomLeftRadius};
        if (this.surface.roundRadius > 0) {
            outerR = new float[]{this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius};
        }
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(bgcolor);
        gradientDrawable.setCornerRadii(outerR);
        if (strokeWidth > 0 && strokeColor != 0) {
            gradientDrawable.setStroke(strokeWidth, strokeColor);
        }
        return gradientDrawable;
    }

    public ViewSurface getSurface() {
        return this.surface;
    }

    public Effect getEffect() {
        return this.effect;
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public void dispatchSetPressed(View view, boolean pressed) {
        if (this.effectModel == 3 || this.effectModel == 1) {
            this.effect(view, pressed, -1, null);
        }
    }

    private void effect(View view, boolean flag, int direction, @Nullable Rect previouslyFocusedRect) {
        if (view instanceof ViewGroup) {
            int childCount = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View childView = ((ViewGroup)view).getChildAt(i);
                this.effect.onStateChange(childView, this.surface, flag);
            }
        } else {
            this.effect.onStateChange(view, this.surface, flag);
        }
    }

    public void onFocusChanged(View view, boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        if (this.effectModel == 3 || this.effectModel == 2) {
            this.effect(view, gainFocus, direction, previouslyFocusedRect);
        }
    }

    public void dispatchSetEffect(View view, boolean flag) {
        if (this.effectModel == 4) {
            this.effect(view, flag, -1, null);
        }
    }

    public void setEffectModel(int effectModel) {
        this.effectModel = effectModel;
    }
}

