/*
 * Decompiled with CFR 0.152.
 */
package cn.ymex.effect.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import cn.ymex.clickeffect.R;
import cn.ymex.effect.AlphaEffect;
import cn.ymex.effect.Effect;
import cn.ymex.effect.SelectorEffect;
import cn.ymex.effect.view.ViewSurface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Deputer {
    private List<Effect> effects = new ArrayList<Effect>();
    private ViewSurface surface = new ViewSurface();

    private Deputer() {
    }

    public static Deputer instance() {
        return new Deputer();
    }

    public void dealAttrs(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EffectView);
        this.surface.defSelector = typedArray.getBoolean(R.styleable.EffectView_effect_xml_selector, false);
        this.surface.roundRadius = typedArray.getDimensionPixelSize(R.styleable.EffectView_effect_round_radius, 0);
        this.surface.topLeftRadius = typedArray.getDimensionPixelSize(R.styleable.EffectView_effect_top_left_radius, 0);
        this.surface.topRightRadius = typedArray.getDimensionPixelSize(R.styleable.EffectView_effect_top_right_radius, 0);
        this.surface.bottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.EffectView_effect_bottom_left_radius, 0);
        this.surface.bottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.EffectView_effect_bottom_right_radius, 0);
        this.surface.pressedBg = typedArray.getDrawable(R.styleable.EffectView_effect_pressed_background);
        this.surface.pressedTextColor = typedArray.getColor(R.styleable.EffectView_effect_pressed_text_color, 0);
        this.surface.strokeColor = typedArray.getColor(R.styleable.EffectView_effect_stroke_color, 0);
        this.surface.pressedStrokeColor = typedArray.getColor(R.styleable.EffectView_effect_pressed_stroke_color, 0);
        this.surface.strokeWidth = typedArray.getDimensionPixelSize(R.styleable.EffectView_effect_stroke_width, 0);
        this.surface.pressedImage = typedArray.getDrawable(R.styleable.EffectView_effect_pressed_image);
        if (this.surface.strokeWidth > 0 && this.surface.strokeColor != 0) {
            this.surface.pressedStrokeColor = this.surface.pressedStrokeColor != 0 ? this.surface.pressedStrokeColor : this.surface.strokeColor;
        }
        typedArray.recycle();
    }

    public void onViewFinishInflate(View proView) {
        proView.setClickable(true);
        View view = null;
        if (proView instanceof ViewGroup) {
            int childCount = ((ViewGroup)proView).getChildCount();
            if (childCount > 1) {
                throw new RuntimeException("just allow single view!");
            }
            view = ((ViewGroup)proView).getChildAt(0);
            if (view instanceof Button || view instanceof ImageButton) {
                view.setFocusable(false);
            }
        } else {
            proView.setFocusable(true);
            view = proView;
        }
        if (view == null) {
            return;
        }
        this.surface.bg = view.getBackground();
        this.setRoundRect(view);
        if (view instanceof TextView) {
            this.surface.textColor = ((TextView)view).getCurrentTextColor();
        }
        if (view instanceof ImageView) {
            this.surface.image = ((ImageView)view).getDrawable();
        }
        this.effects.clear();
        if (this.surface.defSelector) {
            this.effects.add(new SelectorEffect());
        } else if (this.surface.pressedBg != null || this.surface.pressedTextColor != 0 || this.surface.pressedImage != null) {
            this.effects.add(new SelectorEffect());
        } else {
            this.effects.add(new AlphaEffect());
        }
    }

    private void setRoundRect(View view) {
        if (!this.surface.isRequestRoundRect()) {
            return;
        }
        if (this.surface.bg != null && this.surface.bg instanceof ColorDrawable) {
            int bgColor = ((ColorDrawable)this.surface.bg).getColor();
            this.surface.bg = this.createRoundRectDrawable(bgColor, this.surface.strokeWidth, this.surface.strokeColor);
            if (!this.surface.defSelector) {
                if (Build.VERSION.SDK_INT >= 16) {
                    view.setBackground(this.surface.bg);
                } else {
                    view.setBackgroundDrawable(this.surface.bg);
                }
            }
        }
        if (this.surface.pressedBg != null && this.surface.pressedBg instanceof ColorDrawable) {
            this.surface.pressedBg = this.createRoundRectDrawable(((ColorDrawable)this.surface.pressedBg).getColor(), this.surface.strokeWidth, this.surface.pressedStrokeColor);
        }
    }

    private Drawable createRoundRectDrawable(int bgcolor, int strokeWidth, int strokeColor) {
        float[] outerR = new float[]{this.surface.topLeftRadius, this.surface.topLeftRadius, this.surface.topRightRadius, this.surface.topRightRadius, this.surface.bottomRightRadius, this.surface.bottomRightRadius, this.surface.bottomLeftRadius, this.surface.bottomLeftRadius};
        if (this.surface.roundRadius > 0) {
            outerR = new float[]{this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius};
        }
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(bgcolor);
        gradientDrawable.setCornerRadii(outerR);
        if (strokeWidth > 0 && strokeColor != 0) {
            gradientDrawable.setStroke(strokeWidth, strokeColor);
        }
        return gradientDrawable;
    }

    public ViewSurface getSurface() {
        return this.surface;
    }

    public List<Effect> getEffects() {
        return this.effects;
    }

    public void setEffect(Effect ... effects) {
        if (effects.length > 0) {
            this.effects.clear();
            this.effects.addAll(Arrays.asList(effects));
        }
    }

    public void dispatchSetPressed(View view, boolean pressed) {
        if (view instanceof ViewGroup) {
            int childCount = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View childView = ((ViewGroup)view).getChildAt(i);
                for (Effect effect : this.effects) {
                    if (effect == null) continue;
                    effect.onStatePressed(childView, this.surface, pressed);
                }
            }
        } else {
            for (Effect effect : this.effects) {
                if (effect == null) continue;
                effect.onStatePressed(view, this.surface, pressed);
            }
        }
    }

    public void onFocusChanged(View view, boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        this.dispatchSetPressed(view, gainFocus);
    }
}

