/*
 * Decompiled with CFR 0.152.
 */
package cn.ymex.effect.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import cn.ymex.clickeffect.R;
import cn.ymex.effect.AlphaEffect;
import cn.ymex.effect.Effect;
import cn.ymex.effect.SelectorEffect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EffectViewContainer
extends FrameLayout {
    private List<Effect> effects;
    private ViewSurface surface;

    public EffectViewContainer(Context context) {
        this(context, null);
    }

    public EffectViewContainer(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EffectViewContainer(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public EffectViewContainer(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.setClickable(true);
        this.effects = new ArrayList<Effect>();
        this.surface = new ViewSurface();
        this.dealAttrs(context, attrs);
    }

    private void dealAttrs(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ClickEffect);
        this.surface.defSelector = typedArray.getBoolean(R.styleable.ClickEffect_effect_xml_selector, false);
        this.surface.roundRadius = typedArray.getDimensionPixelSize(R.styleable.ClickEffect_effect_round_radius, 0);
        this.surface.topLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ClickEffect_effect_top_left_radius, 0);
        this.surface.topRightRadius = typedArray.getDimensionPixelSize(R.styleable.ClickEffect_effect_top_right_radius, 0);
        this.surface.bottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ClickEffect_effect_bottom_left_radius, 0);
        this.surface.bottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.ClickEffect_effect_bottom_right_radius, 0);
        this.surface.pressedBg = typedArray.getDrawable(R.styleable.ClickEffect_effect_pressed_background);
        this.surface.pressedTextColor = typedArray.getColor(R.styleable.ClickEffect_effect_pressed_text_color, 0);
        this.surface.strokeColor = typedArray.getColor(R.styleable.ClickEffect_effect_stroke_color, 0);
        this.surface.pressedStrokeColor = typedArray.getColor(R.styleable.ClickEffect_effect_pressed_stroke_color, 0);
        this.surface.strokeWidth = typedArray.getDimensionPixelSize(R.styleable.ClickEffect_effect_stroke_width, 0);
        if (this.surface.strokeWidth > 0 && this.surface.strokeColor != 0) {
            this.surface.pressedStrokeColor = this.surface.pressedStrokeColor != 0 ? this.surface.pressedStrokeColor : this.surface.strokeColor;
        }
        typedArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int childCount = this.getChildCount();
        if (childCount > 1) {
            throw new RuntimeException("just allow single view!");
        }
        View view = this.getChildAt(0);
        this.surface.bg = view.getBackground();
        this.setRoundRect();
        if (view instanceof TextView) {
            this.surface.textColor = ((TextView)view).getCurrentTextColor();
        }
        this.effects.clear();
        if (this.surface.defSelector) {
            this.effects.add(new SelectorEffect());
        } else if (this.surface.pressedBg != null || this.surface.pressedTextColor != 0) {
            this.effects.add(new SelectorEffect());
        } else {
            this.effects.add(new AlphaEffect());
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    private void setRoundRect() {
        if (!this.surface.isRequestRoundRect()) {
            return;
        }
        if (this.surface.bg != null && this.surface.bg instanceof ColorDrawable) {
            View view = this.getChildAt(0);
            int bgColor = ((ColorDrawable)this.surface.bg).getColor();
            this.surface.bg = this.createRoundRectDrawable(bgColor, this.surface.strokeWidth, this.surface.strokeColor);
            if (!this.surface.defSelector) {
                if (Build.VERSION.SDK_INT >= 16) {
                    view.setBackground(this.surface.bg);
                } else {
                    view.setBackgroundDrawable(this.surface.bg);
                }
            }
        }
        if (this.surface.pressedBg != null && this.surface.pressedBg instanceof ColorDrawable) {
            this.surface.pressedBg = this.createRoundRectDrawable(((ColorDrawable)this.surface.pressedBg).getColor(), this.surface.strokeWidth, this.surface.pressedStrokeColor);
        }
    }

    private Drawable createRoundRectDrawable(int bgcolor, int strokeWidth, int strokeColor) {
        float[] outerR = new float[]{this.surface.topLeftRadius, this.surface.topLeftRadius, this.surface.topRightRadius, this.surface.topRightRadius, this.surface.bottomRightRadius, this.surface.bottomRightRadius, this.surface.bottomLeftRadius, this.surface.bottomLeftRadius};
        if (this.surface.roundRadius > 0) {
            outerR = new float[]{this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius, this.surface.roundRadius};
        }
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(bgcolor);
        gradientDrawable.setCornerRadii(outerR);
        if (strokeWidth > 0 && strokeColor != 0) {
            gradientDrawable.setStroke(strokeWidth, strokeColor);
        }
        return gradientDrawable;
    }

    protected void dispatchSetPressed(boolean pressed) {
        super.dispatchSetPressed(pressed);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            for (Effect effect : this.effects) {
                if (effect == null) continue;
                effect.onStatePressed(childView, this.surface, pressed);
            }
        }
    }

    public void setEffect(Effect ... effects) {
        if (effects.length > 0) {
            this.effects.clear();
            this.effects.addAll(Arrays.asList(effects));
        }
    }

    public static class ViewSurface {
        public boolean defSelector;
        public Drawable bg;
        public int textColor;
        public Drawable pressedBg;
        public int pressedTextColor;
        public int strokeWidth;
        public int strokeColor;
        public int pressedStrokeColor;
        public int roundRadius;
        public int topLeftRadius;
        public int topRightRadius;
        public int bottomLeftRadius;
        public int bottomRightRadius;

        public boolean isRequestRoundRect() {
            return this.roundRadius > 0 || this.topRightRadius > 0 || this.topLeftRadius > 0 || this.bottomLeftRadius > 0 || this.bottomRightRadius > 0;
        }
    }
}

