/*
 * Decompiled with CFR 0.152.
 */
package cn.xm.weidongjian.progressbuttonlib;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Animatable;
import android.util.AttributeSet;
import android.widget.Button;
import cn.xm.weidongjian.progressbuttonlib.ProgressDrawable;

public class ProgressButton
extends Button
implements Animatable {
    private ProgressDrawable drawable;
    private onAnimFinish listener;

    public ProgressButton(Context context) {
        super(context);
        this.init();
    }

    public ProgressButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ProgressButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public ProgressButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.drawable = new ProgressDrawable(this.getTextSize(), this);
        this.drawable.setColorDefault(this.getCurrentTextColor());
        this.drawable.setAnimatable(this);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
    }

    public void startRotate() {
        this.setCompoundDrawablesWithIntrinsicBounds(this.drawable, null, null, null);
        this.setCompoundDrawablePadding(15);
        this.drawable.startRotate();
    }

    public void animFinish() {
        this.drawable.animFinish();
    }

    public void animError() {
        this.drawable.animError();
    }

    public void removeDrawable() {
        this.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.drawable.stopRotate();
    }

    public void start() {
        this.startRotate();
    }

    public void stop() {
        if (this.listener != null) {
            this.listener.onFinish();
        }
    }

    public void setOnAnimFinishListener(onAnimFinish listener) {
        this.listener = listener;
    }

    public boolean isRunning() {
        return false;
    }

    public static interface onAnimFinish {
        public void onFinish();
    }
}

