/*
 * Decompiled with CFR 0.152.
 */
package cn.wenet.networkcomponent.rxjava;

import android.accounts.NetworkErrorException;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class NetRetryWhen
implements Function<Observable<Throwable>, ObservableSource<?>> {
    private int mRetryCount;
    private int mRetryCurrent = 0;
    private long mRetryWhenTime;

    public NetRetryWhen(int mRetryCount, long mRetryWhenTime) {
        this.mRetryCount = mRetryCount;
        this.mRetryWhenTime = mRetryWhenTime;
    }

    public ObservableSource<?> apply(Observable<Throwable> throwableObservable) throws Exception {
        return throwableObservable.flatMap(new Function<Throwable, ObservableSource<?>>(){

            public ObservableSource<?> apply(@NonNull Throwable throwable) throws Exception {
                boolean isConnectionError;
                boolean isRun;
                boolean bl = isRun = NetRetryWhen.this.mRetryCurrent < NetRetryWhen.this.mRetryCount;
                if (!isRun) {
                    return Observable.error((Throwable)throwable);
                }
                boolean isNetError = throwable instanceof NetworkErrorException || throwable instanceof SocketTimeoutException;
                boolean bl2 = isConnectionError = throwable instanceof ConnectException || throwable instanceof TimeoutException;
                if (isNetError || isConnectionError) {
                    NetRetryWhen.this.mRetryCurrent++;
                    return Observable.timer((long)NetRetryWhen.this.mRetryWhenTime, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }
}

