/*
 * Decompiled with CFR 0.152.
 */
package cn.wenet.networkcomponent.request;

import cn.wenet.networkcomponent.base.NetBaseObserver;
import cn.wenet.networkcomponent.base.NetLifecycleControl;
import cn.wenet.networkcomponent.control.Control;
import cn.wenet.networkcomponent.request.WeNetworkCallBack;
import io.reactivex.Observable;
import java.util.Map;

public class NetRequest {
    private Control netControl;
    private NetLifecycleControl mDestroyDisposable;
    private Observable mObservable;

    public NetRequest(Control netControl, NetLifecycleControl mDestroyDisposable) {
        this.netControl = netControl;
        this.mDestroyDisposable = mDestroyDisposable;
        netControl.clearParams();
    }

    public NetRequest addParams(String key, String value) {
        this.netControl.getParams().put(key, value);
        return this;
    }

    public NetRequest addParams(Map params) {
        this.netControl.getParams().putAll(params);
        return this;
    }

    public Observable getObservable() {
        return this.mObservable;
    }

    public <T> NetRequest apiMethod(Observable<T> observable) {
        this.mObservable = observable;
        return this;
    }

    public <T> void execute(WeNetworkCallBack<T> callback) {
        if (null == this.mObservable) {
            return;
        }
        this.baseExecute(callback, this.mObservable);
    }

    private void baseExecute(WeNetworkCallBack callback, Observable observable) {
        NetBaseObserver baseObserver = this.netControl.getBaseObserve(callback, this.mDestroyDisposable);
        this.subscribe(observable, baseObserver);
    }

    private void subscribe(Observable observable, NetBaseObserver callback) {
        this.netControl.subscribe(observable, callback);
    }
}

