/*
 * Decompiled with CFR 0.152.
 */
package cn.wenet.networkcomponent.okhttp.intercepter;

import android.text.TextUtils;
import cn.wenet.networkcomponent.control.Control;
import cn.wenet.networkcomponent.debug.WeDebug;
import cn.wenet.networkcomponent.okhttp.intercepter.BaseInterceptor;
import cn.wenet.networkcomponent.urlparse.WeUrlParse;
import java.io.IOException;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class BaseUrlInterceptor
extends BaseInterceptor
implements Interceptor {
    private WeUrlParse urlParse = new WeUrlParse();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Headers headers = request.headers();
        String header = headers.get("baseUrl-Header");
        WeDebug.e("Header  is  " + header);
        if (!TextUtils.isEmpty((CharSequence)header) && !":BaseUrl".equals(header)) {
            WeDebug.e("\u68c0\u6d4b\u5230\u65b0\u7684BaseUrl\u3002\u3002\u3002\u3002");
            Map<String, HttpUrl> baseUrls = Control.getInstance().getBaseUrls();
            HttpUrl httpUrl = baseUrls.get(header);
            if (null != httpUrl) {
                HttpUrl newHttpUrl = this.urlParse.parseUrl(httpUrl, request.url());
                WeDebug.e("\u65b0\u7684Url\u662f\uff1a" + newHttpUrl);
                Request.Builder newBuilder = request.newBuilder();
                newBuilder.removeHeader("baseUrl-Header");
                Request newRequest = newBuilder.url(newHttpUrl).build();
                return chain.proceed(newRequest);
            }
        }
        return chain.proceed(request);
    }

    @Override
    public boolean isNetInterceptor() {
        return false;
    }
}

