/*
 * Decompiled with CFR 0.152.
 */
package cn.wenet.networkcomponent.control;

import android.content.Context;
import cn.wenet.networkcomponent.base.NetBaseObserver;
import cn.wenet.networkcomponent.base.NetLifecycleControl;
import cn.wenet.networkcomponent.debug.WeDebug;
import cn.wenet.networkcomponent.okhttp.NetOkHttp;
import cn.wenet.networkcomponent.okhttp.intercepter.NetInterceptorFactory;
import cn.wenet.networkcomponent.request.WeNetworkCallBack;
import cn.wenet.networkcomponent.retrofit.NetRetrofit;
import cn.wenet.networkcomponent.rxjava.NetRetryWhen;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import retrofit2.Retrofit;

public class BaseControl {
    private Context mContext;
    private NetBaseObserver mNetBaseObserver;
    private NetRetryWhen retryWhen;
    protected volatile boolean mHaveInit = false;
    protected NetOkHttp mNetOkHttp;
    protected NetRetrofit mNetRetrofit;
    protected Map<String, Object> mParams = new Hashtable<String, Object>();
    protected Map<String, Object> mBaseParams = new HashMap<String, Object>();
    protected Map<String, HttpUrl> mBaseUrls = new HashMap<String, HttpUrl>();

    protected Context getContext() {
        return this.mContext;
    }

    public Map<String, Object> getParams() {
        return this.mParams;
    }

    public Map<String, Object> clearParams() {
        this.mParams.clear();
        this.mParams.putAll(this.mBaseParams);
        return this.mParams;
    }

    protected void combination() {
        if (!this.mHaveInit) {
            throw new RuntimeException("\u521d\u59cb\u5316\u8fc7\u7a0b\u6709\u8bef!");
        }
        boolean haveChange = this.mNetOkHttp.isHaveChange();
        if (haveChange) {
            this.mNetRetrofit.transform(this.mNetOkHttp.getOkHttpClient());
        }
    }

    public void subscribe(Observable observable, NetBaseObserver callback) {
        this.checkNull("subscribe", "callback", callback);
        this.toSubscribe(observable, callback);
    }

    public NetBaseObserver getBaseObserve(WeNetworkCallBack netCallBack, NetLifecycleControl tag) {
        if (null == this.mNetBaseObserver) {
            this.mNetBaseObserver = new NetBaseObserver();
        }
        this.mNetBaseObserver.setNetCallBack(netCallBack);
        this.mNetBaseObserver.setTag(tag);
        return this.mNetBaseObserver;
    }

    protected <T> void toSubscribe(Observable<T> observable, NetBaseObserver<T> observer) {
        if (null == this.retryWhen) {
            this.retryWhen = new NetRetryWhen(3, 2000L);
        }
        observable.subscribeOn(Schedulers.io()).unsubscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).timeout(10L, TimeUnit.SECONDS).retryWhen((Function)this.retryWhen).subscribe(observer);
    }

    public <T> T getApiService(Class<T> clz) {
        Object apiService = null;
        Retrofit retrofit = this.mNetRetrofit.getRetrofit();
        if (retrofit != null) {
            apiService = retrofit.create(clz);
        }
        return (T)apiService;
    }

    public void init(Context context) {
        this.mContext = context;
        this.mNetOkHttp = NetOkHttp.getInstance();
        this.mNetRetrofit = NetRetrofit.getInstance();
        this.mNetOkHttp.addBaseInterceptor(NetInterceptorFactory.logInterceptor());
        this.mNetOkHttp.addBaseInterceptor(NetInterceptorFactory.baseUrlInterceptor());
        this.mNetOkHttp.addBaseInterceptor(NetInterceptorFactory.baseParamsIntercepter());
        this.mHaveInit = true;
    }

    protected void transformationUrl(String flag, String url) {
        String[] split = flag.split(":");
        if (split.length <= 0) {
            throw new IllegalArgumentException("Please check that your parameters are correct !");
        }
        String base = ":BaseUrl".replace(":", "").trim();
        if (base.equals(split[1])) {
            this.mNetRetrofit.setBaseUrl(url);
            this.combination();
        }
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        this.mBaseUrls.put(split[1], httpUrl);
    }

    protected void checkNull(String method, String filename, Object ... o) {
        for (int i = 0; i < o.length; ++i) {
            if (null != o[i]) continue;
            throw new NullPointerException(WeDebug.getNullPointerErrorInfo(method, filename));
        }
    }
}

