/*
 * Decompiled with CFR 0.152.
 */
package cn.kerison.kit.log.impl;

import android.util.Log;
import cn.kerison.kit.log.ILogPrinter;

public class KLogPrinter
implements ILogPrinter {
    private static final int CHUNK_SIZE = 2048;
    private static final int STACK_OFFSET = 6;
    private static final String LR = System.getProperty("line.separator");
    private static final char TOP_LEFT_BAR = '\u2554';
    private static final char BOTTOM_LEFT_BAR = '\u255a';
    private static final char MIDDLE_LEFT_BAR = '\u2551';
    private static final String DOUBLE_DIVIDER = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String TOP_BORDER = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String MIDDLE_BORDER = String.valueOf('\u2551');
    private String mTag = "LogKit\u261e";
    private boolean isShowThread = true;
    private boolean isShowPackage = true;
    private int mStackCount = 2;

    @Override
    public ILogPrinter setTag(String tag) {
        this.mTag = tag;
        return this;
    }

    @Override
    public ILogPrinter setMethodCount(int count) {
        this.mStackCount = count;
        return this;
    }

    @Override
    public ILogPrinter hideExtraInfo() {
        this.mStackCount = 0;
        this.isShowPackage = false;
        this.isShowThread = false;
        return this;
    }

    @Override
    public void v(String msg) {
        this.log(2, msg);
    }

    @Override
    public void d(String msg) {
        this.log(3, msg);
    }

    @Override
    public void i(String msg) {
        this.log(4, msg);
    }

    @Override
    public void w(String msg) {
        this.log(5, msg);
    }

    @Override
    public void e(String msg) {
        this.log(6, msg);
    }

    @Override
    public void wtf(String msg) {
        this.log(7, msg);
    }

    @Override
    public void text(String msg) {
        this.log(4, msg);
    }

    private synchronized void log(int level, String msg) {
        this.showTopBar(level);
        if (this.isShowThread) {
            this.showTheadInfo(level);
        }
        if (this.mStackCount > 0) {
            this.showStackTrace(level);
        }
        this.showContent(level, msg);
        this.showBottomBar(level);
    }

    private void showTopBar(int level) {
        KLogPrinter.print(level, this.mTag, TOP_BORDER);
    }

    private void showBottomBar(int level) {
        KLogPrinter.print(level, this.mTag, BOTTOM_BORDER);
    }

    private void showTheadInfo(int level) {
        KLogPrinter.print(level, this.mTag, String.format("%sThread:%s[%s]", Character.valueOf('\u2551'), Thread.currentThread().getName(), Thread.currentThread().getId()));
    }

    private void showDivider(int level) {
        KLogPrinter.print(level, this.mTag, MIDDLE_BORDER);
    }

    private void showStackTrace(int level) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int count = trace.length - 6;
        if (count > this.mStackCount) {
            count = this.mStackCount;
        }
        for (int i = count; i > 0; --i) {
            StackTraceElement element = trace[6 + i - 1];
            StringBuilder builder = new StringBuilder();
            builder.append('\u2551').append(this.isShowPackage ? element.getClassName() : this.getSimpleClassName(element.getClassName())).append(".").append(element.getMethodName()).append(" ").append("(").append(element.getFileName()).append(":").append(element.getLineNumber()).append(")");
            KLogPrinter.print(level, this.mTag, builder.toString());
        }
        if (count > 0) {
            this.showDivider(level);
        }
    }

    private String getSimpleClassName(String name) {
        if (name != null) {
            int lastIndex = name.lastIndexOf(".");
            if (lastIndex == -1) {
                return null;
            }
            return name.substring(lastIndex + 1);
        }
        return null;
    }

    private void showContent(int level, String msg) {
        byte[] bytes = msg.getBytes();
        int length = bytes.length;
        for (int i = 0; i < length; i += 2048) {
            int count = Math.min(length - i, 2048);
            this.formatContent(level, this.mTag, new String(bytes, i, count));
        }
    }

    private void formatContent(int level, String tag, String content) {
        String[] lines;
        for (String line : lines = content.split(LR)) {
            KLogPrinter.print(level, tag, '\u2551' + line);
        }
    }

    private static void print(int level, String tag, String msg) {
        Log.println((int)level, (String)tag, (String)msg);
    }

    public static class LogLevel {
        public static final int VERBOSE = 2;
        public static final int DEBUG = 3;
        public static final int INFO = 4;
        public static final int WARN = 5;
        public static final int ERROR = 6;
        public static final int ASSERT = 7;
    }
}

