/*
 * Decompiled with CFR 0.152.
 */
package cn.kerison.kit.log;

import android.util.Log;
import cn.kerison.kit.log.ILogPrinter;
import cn.kerison.kit.log.impl.KLogPrinter;
import cn.kerison.kit.log.impl.NoLogPrinter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogKit {
    private static final int TEXT_INDENT = 4;
    private static ILogPrinter mPrinter = new KLogPrinter();

    private LogKit() {
    }

    public static void disable() {
        mPrinter = new NoLogPrinter();
    }

    public static ILogPrinter config() {
        return mPrinter;
    }

    public static ILogPrinter setPrinter(ILogPrinter printer) {
        mPrinter = printer;
        return mPrinter;
    }

    public static void v(String content) {
        mPrinter.v(content);
    }

    public static void v(String format, Object ... args) {
        mPrinter.v(String.format(format, args));
    }

    public static void v(Throwable tr) {
        mPrinter.v(Log.getStackTraceString((Throwable)tr));
    }

    public static void d(String content) {
        mPrinter.d(content);
    }

    public static void d(String format, Object ... args) {
        mPrinter.d(String.format(format, args));
    }

    public static void d(Throwable tr) {
        mPrinter.d(Log.getStackTraceString((Throwable)tr));
    }

    public static void i(String content) {
        mPrinter.i(content);
    }

    public static void i(String format, Object ... args) {
        mPrinter.i(String.format(format, args));
    }

    public static void i(Throwable tr) {
        mPrinter.i(Log.getStackTraceString((Throwable)tr));
    }

    public static void w(String content) {
        mPrinter.w(content);
    }

    public static void w(String format, Object ... args) {
        mPrinter.w(String.format(format, args));
    }

    public static void w(Throwable tr) {
        mPrinter.w(Log.getStackTraceString((Throwable)tr));
    }

    public static void e(String content) {
        mPrinter.e(content);
    }

    public static void e(String format, Object ... args) {
        mPrinter.e(String.format(format, args));
    }

    public static void e(Throwable tr) {
        mPrinter.e(Log.getStackTraceString((Throwable)tr));
    }

    public static void wtf(String content) {
        mPrinter.wtf(content);
    }

    public static void wtf(String format, Object ... args) {
        mPrinter.wtf(String.format(format, args));
    }

    public static void wtf(Throwable tr) {
        mPrinter.wtf(Log.getStackTraceString((Throwable)tr));
    }

    public static void json(JSONObject jsonObject) {
        if (jsonObject == null) {
            mPrinter.e("Log json data is null");
            return;
        }
        try {
            mPrinter.text(jsonObject.toString(4));
        }
        catch (JSONException e) {
            e.printStackTrace();
            mPrinter.e("Log json error :\n" + e.getMessage());
        }
    }

    public static void json(JSONArray jsonArray) {
        if (jsonArray == null) {
            mPrinter.e("Log json data is null");
            return;
        }
        try {
            mPrinter.text(jsonArray.toString(4));
        }
        catch (JSONException e) {
            mPrinter.e("Log json error :\n" + e.getMessage());
        }
    }

    public static void json(String jsonText) {
        if (LogKit.isTextEmpty(jsonText)) {
            mPrinter.e("Log json data is empty!");
            return;
        }
        jsonText = jsonText.trim();
        try {
            if (jsonText.startsWith("{")) {
                mPrinter.text(new JSONObject(jsonText).toString(4));
            } else if (jsonText.startsWith("[")) {
                mPrinter.text(new JSONArray(jsonText).toString(4));
            } else {
                mPrinter.text("Log json data is " + jsonText);
            }
        }
        catch (JSONException e) {
            mPrinter.e("Log.json error :\n" + e.getMessage());
        }
    }

    public static void xml(String xml) {
        if (LogKit.isTextEmpty(xml)) {
            mPrinter.e("Log xml data is empty!");
            return;
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(4));
            transformer.transform(xmlInput, xmlOutput);
            mPrinter.text(xmlOutput.getWriter().toString());
        }
        catch (TransformerException e) {
            mPrinter.e("Log xml error :\n" + e.getMessage());
        }
    }

    private static boolean isTextEmpty(String text) {
        return text == null || "".equals(text.trim()) || "null".equals(text.trim());
    }
}

