/*
 * Decompiled with CFR 0.152.
 */
package cn.kerison.kit.log;

import android.util.Log;
import cn.kerison.kit.log.LogConfig;

public class LogPrinter {
    private static final int CHUNK_SIZE = 4000;
    private static final String TEXT_OFFSET = "    ";
    private static final int STACK_OFFSET = 6;
    private static final String LR = System.getProperty("line.separator");
    private static final char TOP_LEFT_BAR = '\u2554';
    private static final char BOTTOM_LEFT_BAR = '\u255a';
    private static final char MIDDLE_LEFT_BAR = '\u2551';
    private static final String DOUBLE_DIVIDER = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String SINGLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String TOP_BORDER = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String MIDDLE_BORDER = "\u2551\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private String mTag;
    private int mLevel;
    private int mTextLevel;
    private boolean isShowThread;
    private boolean isShowPackage;
    private int mStackCount;

    public void updateConfig(LogConfig config) {
        this.mTag = config.getTag();
        this.mLevel = config.getLevel();
        this.mTextLevel = config.getTextLevel();
        this.isShowThread = config.isShowThread();
        this.isShowPackage = config.isShowPackage();
        this.mStackCount = config.getStackCount();
    }

    public void v(String msg) {
        if (this.mLevel <= 2) {
            this.log(2, msg);
        }
    }

    public void d(String msg) {
        if (this.mLevel <= 3) {
            this.log(3, msg);
        }
    }

    public void i(String msg) {
        if (this.mLevel <= 4) {
            this.log(4, msg);
        }
    }

    public void w(String msg) {
        if (this.mLevel <= 5) {
            this.log(5, msg);
        }
    }

    public void e(String msg) {
        if (this.mLevel <= 6) {
            this.log(6, msg);
        }
    }

    public void wtf(String msg) {
        if (this.mLevel <= 7) {
            this.log(7, msg);
        }
    }

    public void text(String msg) {
        if (this.mLevel <= this.mTextLevel) {
            this.log(this.mTextLevel, msg);
        }
    }

    private synchronized void log(int level, String msg) {
        this.showTopBar(level);
        if (this.isShowThread) {
            this.showTheadInfo(level);
            this.showDivider(level);
        }
        if (this.mStackCount > 0) {
            this.showStackTrace(level);
        }
        this.showContent(level, msg);
        this.showBottomBar(level);
    }

    private void showTopBar(int level) {
        LogPrinter.print(level, this.mTag, TOP_BORDER);
    }

    private void showBottomBar(int level) {
        LogPrinter.print(level, this.mTag, BOTTOM_BORDER);
    }

    private void showTheadInfo(int level) {
        LogPrinter.print(level, this.mTag, String.format("%sThread:%s[%s]", Character.valueOf('\u2551'), Thread.currentThread().getName(), Thread.currentThread().getId()));
    }

    private void showDivider(int level) {
        LogPrinter.print(level, this.mTag, MIDDLE_BORDER);
    }

    private void showStackTrace(int level) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int count = trace.length - 6;
        if (count > this.mStackCount) {
            count = this.mStackCount;
        }
        for (int i = count; i > 0; --i) {
            int numOffset = count - i;
            StackTraceElement element = trace[6 + i - 1];
            StringBuilder builder = new StringBuilder();
            builder.append('\u2551');
            while (numOffset-- > 0) {
                builder.append(TEXT_OFFSET);
            }
            builder.append(this.isShowPackage ? element.getClassName() : this.getSimpleClassName(element.getClassName())).append(".").append(element.getMethodName()).append(" ").append(" (").append(element.getFileName()).append(":").append(element.getLineNumber()).append(")");
            LogPrinter.print(level, this.mTag, builder.toString());
        }
        if (count > 0) {
            this.showDivider(level);
        }
    }

    private String getSimpleClassName(String name) {
        if (name != null) {
            int lastIndex = name.lastIndexOf(".");
            if (lastIndex == -1) {
                return null;
            }
            return name.substring(lastIndex + 1);
        }
        return null;
    }

    private void showContent(int level, String msg) {
        byte[] bytes = msg.getBytes();
        int length = bytes.length;
        for (int i = 0; i < length; i += 4000) {
            int count = Math.min(length - i, 4000);
            this.formatContent(level, this.mTag, new String(bytes, i, count));
        }
    }

    private void formatContent(int level, String tag, String content) {
        String[] lines;
        for (String line : lines = content.split(LR)) {
            LogPrinter.print(level, tag, '\u2551' + line);
        }
    }

    private static void print(int level, String tag, String msg) {
        Log.println((int)level, (String)tag, (String)msg);
    }
}

