/*
 * Decompiled with CFR 0.152.
 */
package cn.kerison.kit.log;

import android.text.TextUtils;
import android.util.Log;
import java.util.Locale;

public class LogKit {
    public static final int LOG_VERBOSE = 2;
    public static final int LOG_DEBUG = 3;
    public static final int LOG_INFO = 4;
    public static final int LOG_WARN = 5;
    public static final int LOG_ERROR = 6;
    public static final int LOG_ASSERT = 7;
    public static final int NO_LOG = Integer.MAX_VALUE;
    private static int DEFAULT_LEVEL = 2;
    private static String DEFAULT_TAG = null;

    private LogKit() {
    }

    public static void setLevel(int level) {
        DEFAULT_LEVEL = level;
    }

    public static void setTag(String defaultTag) {
        DEFAULT_TAG = defaultTag;
    }

    public static void v(String content) {
        if (DEFAULT_LEVEL <= 2) {
            LogKit.LogPrint(2, LogKit.obtainTag(), content);
        }
    }

    public static void v(String format, Object ... args) {
        if (DEFAULT_LEVEL <= 2) {
            LogKit.LogPrint(2, LogKit.obtainTag(), String.format(format, args));
        }
    }

    public static void v(String content, Throwable tr) {
        if (DEFAULT_LEVEL <= 2) {
            LogKit.LogPrint(3, LogKit.obtainTag(), content, tr);
        }
    }

    public static void d(String content) {
        if (DEFAULT_LEVEL <= 3) {
            LogKit.LogPrint(3, LogKit.obtainTag(), content);
        }
    }

    public static void d(String format, Object ... args) {
        if (DEFAULT_LEVEL <= 3) {
            LogKit.LogPrint(3, LogKit.obtainTag(), String.format(format, args));
        }
    }

    public static void d(String content, Throwable tr) {
        if (DEFAULT_LEVEL <= 3) {
            LogKit.LogPrint(3, LogKit.obtainTag(), content, tr);
        }
    }

    public static void i(String content) {
        if (DEFAULT_LEVEL <= 4) {
            LogKit.LogPrint(4, LogKit.obtainTag(), content);
        }
    }

    public static void i(String format, Object ... args) {
        if (DEFAULT_LEVEL <= 4) {
            LogKit.LogPrint(4, LogKit.obtainTag(), String.format(format, args));
        }
    }

    public static void i(String content, Throwable tr) {
        if (DEFAULT_LEVEL <= 4) {
            LogKit.LogPrint(4, LogKit.obtainTag(), content, tr);
        }
    }

    public static void w(String content) {
        if (DEFAULT_LEVEL <= 5) {
            LogKit.LogPrint(5, LogKit.obtainTag(), content);
        }
    }

    public static void w(String format, Object ... args) {
        if (DEFAULT_LEVEL <= 5) {
            LogKit.LogPrint(5, LogKit.obtainTag(), String.format(format, args));
        }
    }

    public static void w(String content, Throwable tr) {
        if (DEFAULT_LEVEL <= 5) {
            LogKit.LogPrint(5, LogKit.obtainTag(), content, tr);
        }
    }

    public static void e(String content) {
        if (DEFAULT_LEVEL <= 6) {
            LogKit.LogPrint(6, LogKit.obtainTag(), content);
        }
    }

    public static void e(String format, Object ... args) {
        if (DEFAULT_LEVEL <= 6) {
            LogKit.LogPrint(6, LogKit.obtainTag(), String.format(format, args));
        }
    }

    public static void e(String content, Throwable tr) {
        if (DEFAULT_LEVEL <= 6) {
            LogKit.LogPrint(6, LogKit.obtainTag(), content, tr);
        }
    }

    public static void wft(String content) {
        if (DEFAULT_LEVEL <= 7) {
            LogKit.LogPrint(7, LogKit.obtainTag(), content);
        }
    }

    public static void wft(String format, Object ... args) {
        if (DEFAULT_LEVEL <= 7) {
            LogKit.LogPrint(7, LogKit.obtainTag(), String.format(format, args));
        }
    }

    public static void wft(String content, Throwable tr) {
        if (DEFAULT_LEVEL <= 7) {
            LogKit.LogPrint(7, LogKit.obtainTag(), content, tr);
        }
    }

    private static String obtainTag() {
        if (!TextUtils.isEmpty((CharSequence)DEFAULT_TAG)) {
            return DEFAULT_TAG;
        }
        StackTraceElement caller = Thread.currentThread().getStackTrace()[4];
        String callerClazzName = caller.getClassName();
        callerClazzName = callerClazzName.substring(callerClazzName.lastIndexOf(".") + 1);
        return String.format(Locale.ENGLISH, "%s.%s(L:%d)", callerClazzName, caller.getMethodName(), caller.getLineNumber());
    }

    private static void LogPrint(int logLevel, String tag, String msg) {
        Log.println((int)logLevel, (String)tag, (String)msg);
    }

    private static void LogPrint(int logLevel, String tag, String msg, Throwable tr) {
        Log.println((int)logLevel, (String)tag, (String)(msg + Log.getStackTraceString((Throwable)tr)));
    }
}

