/*
 * Decompiled with CFR 0.152.
 */
package cn.kerison.kit.event.core;

import android.os.Looper;
import cn.kerison.kit.event.annotation.Event;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EventHandler {
    private final Object target;
    private final Method method;
    private Event.Type type;

    public EventHandler(Object target, Method method) {
        this(target, method, Event.Type.MAIN);
    }

    public EventHandler(Object target, Method method, Event.Type type) {
        if (target == null) {
            throw new IllegalArgumentException("EventMap's target can not be null !");
        }
        if (method == null) {
            throw new IllegalArgumentException("EventMap's method can not be null !");
        }
        this.type = type;
        this.target = target;
        this.method = method;
        this.method.setAccessible(true);
    }

    public void handleEvent(Object event) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        if (this.type == Event.Type.MAIN && Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("EventKit accessed from non-main thread " + Looper.myLooper());
        }
        this.method.invoke(this.target, event);
    }

    public String toString() {
        return String.format("%s.%s-%s", this.target.getClass().getName(), this.method.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventHandler other = (EventHandler)obj;
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }
}

