/*
 * Decompiled with CFR 0.152.
 */
package cn.kerison.kit.event;

import android.util.Log;
import cn.kerison.kit.event.core.EventFinder;
import cn.kerison.kit.event.core.EventHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class EventKit {
    public static final String TAG = EventKit.class.getSimpleName();
    private final ConcurrentMap<Class<?>, Set<EventHandler>> mEventMap = new ConcurrentHashMap();
    private final ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>> mEventDispatchQueue = new ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>>(){

        @Override
        protected ConcurrentLinkedQueue<EventWithHandler> initialValue() {
            return new ConcurrentLinkedQueue<EventWithHandler>();
        }
    };
    private final ThreadLocal<Boolean> isDispatching = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final ConcurrentMap<Class<?>, Set<Class<?>>> mEventHierarchyCache = new ConcurrentHashMap();
    private EventFinder finder;
    private boolean isSupportEventHierarchy = false;
    private static EventKit mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventKit get() {
        if (mInstance != null) return mInstance;
        Class<EventKit> clazz = EventKit.class;
        synchronized (EventKit.class) {
            if (mInstance != null) return mInstance;
            mInstance = new EventKit(EventFinder.TYPE_ANNOTATION);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private EventKit(EventFinder finder) {
        this.finder = finder;
    }

    public void register(Object target) {
        if (target == null) {
            throw new NullPointerException("Object to register must not be null.");
        }
        Log.i((String)TAG, (String)("register for" + target.getClass().getName()));
        Map<Class<?>, Set<EventHandler>> targetEventHandlers = this.finder.findAllEventHandlers(target);
        for (Class<?> type : targetEventHandlers.keySet()) {
            Set<EventHandler> eventHandlers;
            CopyOnWriteArraySet<EventHandler> typeHandlers;
            CopyOnWriteArraySet<EventHandler> allEventHandlers = (CopyOnWriteArraySet<EventHandler>)this.mEventMap.get(type);
            if (allEventHandlers == null && (allEventHandlers = (Set)this.mEventMap.putIfAbsent(type, typeHandlers = new CopyOnWriteArraySet<EventHandler>())) == null) {
                allEventHandlers = typeHandlers;
            }
            if (allEventHandlers.addAll(eventHandlers = targetEventHandlers.get(type))) continue;
            Log.e((String)TAG, (String)"Object already registered.");
        }
    }

    public void unregister(Object target) {
        if (target == null) {
            throw new NullPointerException("Object to unregister must not be null.");
        }
        Log.i((String)TAG, (String)("unregister for" + target.getClass().getName()));
        Map<Class<?>, Set<EventHandler>> targetEventHandlers = this.finder.findAllEventHandlers(target);
        for (Map.Entry<Class<?>, Set<EventHandler>> entry : targetEventHandlers.entrySet()) {
            Set allEventHandlers = (Set)this.mEventMap.get(entry.getKey());
            Collection currentEventhandlers = entry.getValue();
            if (allEventHandlers == null || !allEventHandlers.containsAll(currentEventhandlers)) {
                Log.i((String)TAG, (String)("Missing event handler for an event method. Is " + target.getClass() + " registered ?"));
                continue;
            }
            if (allEventHandlers.removeAll(currentEventhandlers)) continue;
            Log.e((String)TAG, (String)"Object already unregistered.");
        }
    }

    public void enableSupportEventHierarchy() {
        this.isSupportEventHierarchy = true;
    }

    public void post(Object event) {
        if (event == null) {
            throw new NullPointerException("Event to post must not be null.");
        }
        Log.i((String)TAG, (String)("ready post event " + event.getClass().getName()));
        if (this.isSupportEventHierarchy) {
            Set<Class<?>> dispatchTypes = this.getEventHierarchy(event.getClass());
            for (Class<?> eventType : dispatchTypes) {
                Set eventHandlers = (Set)this.mEventMap.get(eventType);
                if (eventHandlers == null || eventHandlers.isEmpty()) continue;
                for (EventHandler handler : eventHandlers) {
                    this.enqueueEvent(event, handler);
                }
            }
        } else {
            Set eventHandlers = (Set)this.mEventMap.get(event.getClass());
            if (eventHandlers != null && !eventHandlers.isEmpty()) {
                for (EventHandler handler : eventHandlers) {
                    this.enqueueEvent(event, handler);
                }
            }
        }
        this.dispatchQueuedEvents();
    }

    protected void enqueueEvent(Object event, EventHandler handler) {
        this.mEventDispatchQueue.get().offer(new EventWithHandler(event, handler));
    }

    protected void dispatchQueuedEvents() {
        if (this.isDispatching.get().booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        try {
            EventWithHandler eventWithHandler;
            while ((eventWithHandler = this.mEventDispatchQueue.get().poll()) != null) {
                Log.i((String)TAG, (String)("posting event " + eventWithHandler.event));
                this.dispatch(eventWithHandler.event, eventWithHandler.handler);
            }
        }
        finally {
            this.isDispatching.set(false);
        }
    }

    protected void dispatch(Object event, EventHandler handler) {
        try {
            handler.handleEvent(event);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not dispatch event: " + event.getClass() + " to handler " + handler, ex);
        }
    }

    private Set<Class<?>> getEventHierarchy(Class<?> clazz) {
        Set<Class<?>> classesCreation;
        Set<Class<?>> classes = (Set<Class<?>>)this.mEventHierarchyCache.get(clazz);
        if (classes == null && (classes = this.mEventHierarchyCache.putIfAbsent(clazz, classesCreation = this.getClassesFor(clazz))) == null) {
            classes = classesCreation;
        }
        return classes;
    }

    private Set<Class<?>> getClassesFor(Class<?> clazz) {
        LinkedList parents = new LinkedList();
        HashSet classes = new HashSet();
        parents.add(clazz);
        while (!parents.isEmpty()) {
            Class tempClazz = (Class)parents.remove(0);
            classes.add(tempClazz);
            Class parent = tempClazz.getSuperclass();
            if (parent == null) continue;
            parents.add(parent);
        }
        return classes;
    }

    static class EventWithHandler {
        final Object event;
        final EventHandler handler;

        public EventWithHandler(Object event, EventHandler handler) {
            this.event = event;
            this.handler = handler;
        }
    }
}

