/*
 * Decompiled with CFR 0.152.
 */
package cn.kejin.android.views;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import cn.kejin.android.views.XImageView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class BitmapManager {
    public static final String TAG = "BitmapManager";
    private static final Paint mPaint = new Paint();
    private Handler mMainHandler = new Handler();
    private Handler mLoadingHandler = null;
    private HandlerThread mLoadingThread = null;
    private static final String THREAD_NAME = "SuperImageLoad";
    private BitmapRegionDecoder mDecoder = null;
    private Bitmap mSrcBitmap = null;
    private File mCacheFile = null;
    private Bitmap.Config mBitmapConfig = Bitmap.Config.RGB_565;
    private int mSampleSize = 0;
    private int mThumbSampleSize = 0;
    private Rect mImageRect = new Rect();
    private Rect mViewRect = new Rect();
    private Rect mViewBitmapRect = new Rect();
    private RectF mShowBitmapRect = new RectF();
    private Rect mThumbShowBitmapRect = new Rect();
    private BitmapGrid mBitmapGrid = new BitmapGrid();
    private ValueAnimator mValueAnimator = null;
    public static final float MAX_SCALE_FACTOR = 4.0f;
    private float mMaxScaleValue = 4.0f;
    private float mMinScaleValue = 1.0f;
    private final Object mBitmapLock = new Object();
    private IManagerCallback mManagerCallback = null;
    private View mImageView = null;
    private boolean mIsSettingImage = true;
    private boolean mInitFitView = false;
    public static final int NONE = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    private float mLastAnimatedValue = 1.0f;

    public void setInitFitView(boolean init) {
        this.mInitFitView = init;
    }

    public BitmapManager(final View view, final Bitmap bitmap, final boolean cache, final @NonNull IManagerCallback callback) {
        view.post(new Runnable(){

            @Override
            public void run() {
                BitmapManager.this.initialize(view, callback);
                BitmapManager.this.setSrcBitmap(bitmap, cache);
            }
        });
    }

    public BitmapManager(final View view, final InputStream is, final Bitmap.Config config, final @NonNull IManagerCallback callback) {
        view.post(new Runnable(){

            @Override
            public void run() {
                BitmapManager.this.initialize(view, callback);
                BitmapManager.this.setBitmapDecoder(is, config);
            }
        });
    }

    private void initialize(View view, @NonNull IManagerCallback callback) {
        this.mImageView = view;
        this.mManagerCallback = callback;
        this.onSetImageStart();
        this.mCacheFile = new File(view.getContext().getCacheDir(), UUID.randomUUID().toString());
        this.mCacheFile.deleteOnExit();
        this.mLoadingThread = new HandlerThread(THREAD_NAME + this.hashCode());
        this.mLoadingThread.start();
        this.mLoadingHandler = new Handler(this.mLoadingThread.getLooper());
    }

    public void onDestroy() {
        this.mLoadingThread.quit();
        this.mCacheFile.delete();
        this.recycleAll();
        this.postInvalidate();
    }

    public void postInvalidate() {
        this.mImageView.postInvalidate();
    }

    private void onSetImageStart() {
        this.mIsSettingImage = true;
        this.mManagerCallback.onSetImageStart();
    }

    private void startInitImageThumb() {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                BitmapManager.this.updateViewRect(BitmapManager.this.mImageView.getWidth(), BitmapManager.this.mImageView.getHeight());
            }
        });
    }

    private synchronized void onSetImageFinished(final boolean success) {
        final Rect image = new Rect();
        if (success) {
            this.mIsSettingImage = false;
            image.set(this.mImageRect);
            if (this.mInitFitView && this.mViewRect.contains(this.mImageRect)) {
                this.scaleToMinFitView(this.mViewRect.centerX(), this.mViewRect.centerY(), false, 0L);
            }
        }
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                BitmapManager.this.mManagerCallback.onSetImageFinished(BitmapManager.this, success, image);
            }
        });
        this.postInvalidate();
    }

    private void setSrcBitmap(final Bitmap bitmap, boolean cache) {
        if (bitmap == null) {
            this.onSetImageFinished(true);
            return;
        }
        if (cache) {
            this.mLoadingHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOutputStream fos = new FileOutputStream(BitmapManager.this.mCacheFile);
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
                        fos.flush();
                        fos.close();
                        FileInputStream fis = new FileInputStream(BitmapManager.this.mCacheFile);
                        BitmapManager.this.setBitmapDecoder(fis, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        BitmapManager.this.onSetImageFinished(false);
                    }
                }
            });
        } else {
            this.mSrcBitmap = bitmap;
            this.mImageRect.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
            this.updateViewRect(this.mImageView.getWidth(), this.mImageView.getHeight());
        }
    }

    private void setBitmapDecoder(final InputStream is, Bitmap.Config config) {
        if (is == null) {
            this.onSetImageFinished(true);
            return;
        }
        this.mBitmapConfig = config == null ? Bitmap.Config.RGB_565 : config;
        this.mLoadingHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    BitmapManager.this.mDecoder = BitmapRegionDecoder.newInstance((InputStream)is, (boolean)false);
                    BitmapManager.this.mImageRect.set(0, 0, BitmapManager.this.mDecoder.getWidth(), BitmapManager.this.mDecoder.getHeight());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    BitmapManager.this.mDecoder = null;
                }
                if (BitmapManager.this.mDecoder != null) {
                    BitmapManager.this.startInitImageThumb();
                } else {
                    BitmapManager.this.onSetImageFinished(false);
                }
            }
        });
    }

    private void updateViewRect(int vw, int vh) {
        int ih;
        int iw = this.mImageRect.width();
        if (vw * vh * iw * (ih = this.mImageRect.height()) == 0) {
            this.onSetImageFinished(false);
            return;
        }
        this.mMaxScaleValue = Math.max(4.0f, this.getMaxFitViewValue());
        this.mMinScaleValue = Math.min(1.0f, this.getMinFitViewValue());
        this.mViewRect.set(0, 0, vw, vh);
        int width = (int)((float)iw * 1.0f / (float)ih * (float)vh);
        float ratio = width > vw ? (float)iw * 1.0f / (float)vw : (float)ih * 1.0f / (float)vh;
        ratio = ratio < 1.0f ? 1.0f : ratio;
        this.mShowBitmapRect.set(0.0f, 0.0f, (float)((int)((float)iw / ratio)), (float)((int)((float)ih / ratio)));
        this.mShowBitmapRect.round(this.mThumbShowBitmapRect);
        int left = (int)((this.mShowBitmapRect.width() - (float)this.mViewRect.width()) / 2.0f);
        int right = left + this.mViewRect.width();
        int top = (int)((this.mShowBitmapRect.height() - (float)this.mViewRect.height()) / 2.0f);
        int bottom = top + this.mViewRect.height();
        this.mViewBitmapRect.set(left, top, right, bottom);
        this.mThumbSampleSize = this.mSampleSize = this.getCurSampleSize();
        this.mBitmapGrid.initializeBitmapGrid();
    }

    public Rect getImageRect() {
        return this.mImageRect;
    }

    public Rect getShowImageRect() {
        return new Rect(0, 0, (int)this.mShowBitmapRect.width(), (int)this.mShowBitmapRect.height());
    }

    public int offsetShowBitmap(int dx, int dy) {
        if (this.checkImageNotAvailable()) {
            return 0;
        }
        Rect oRect = new Rect();
        this.toViewCoordinate(this.mShowBitmapRect).round(oRect);
        int rx = dx;
        int ry = dy;
        if (oRect.left >= 0 && oRect.right <= this.mViewRect.right) {
            rx = Integer.MAX_VALUE;
        }
        if (oRect.top >= 0 && oRect.bottom <= this.mViewRect.bottom) {
            ry = Integer.MAX_VALUE;
        }
        if (rx != Integer.MAX_VALUE) {
            if (oRect.left + dx > 0) {
                rx = -oRect.left;
            }
            if (oRect.right + dx < this.mViewRect.right) {
                rx = this.mViewRect.right - oRect.right;
            }
            if (oRect.left + dx > 0 && oRect.right + dx < this.mViewRect.right) {
                rx = this.mViewRect.centerX() - oRect.centerX();
            }
        }
        if (ry != Integer.MAX_VALUE) {
            if (oRect.top + dy > 0) {
                ry = -oRect.top;
            }
            if (oRect.bottom + dy < this.mViewRect.bottom) {
                ry = this.mViewRect.bottom - oRect.bottom;
            }
            if (oRect.top + dy > 0 && oRect.bottom + dy < this.mViewRect.bottom) {
                ry = this.mViewRect.centerY() - oRect.centerY();
            }
        }
        this.mViewBitmapRect.offset(-(rx == Integer.MAX_VALUE ? 0 : rx), -(ry == Integer.MAX_VALUE ? 0 : ry));
        this.postInvalidate();
        Rect detectRect = new Rect(this.mViewBitmapRect);
        int result = 0;
        if (detectRect.left <= 0) {
            result |= 1;
        }
        if (detectRect.right >= (int)this.mShowBitmapRect.right) {
            result |= 2;
        }
        if (detectRect.top <= 0) {
            result |= 4;
        }
        if (detectRect.bottom >= (int)this.mShowBitmapRect.bottom) {
            result |= 8;
        }
        return result;
    }

    public void scaleShowBitmap(float cx, float cy, float sc) {
        float bottom;
        float right;
        float top;
        float left;
        RectF nRect;
        if (this.checkImageNotAvailable()) {
            return;
        }
        RectF viewRect = new RectF(this.mViewRect);
        RectF oRect = this.toViewCoordinate(this.mShowBitmapRect);
        if (oRect.left > 0.0f && oRect.right < (float)this.mViewRect.right) {
            cx = viewRect.centerX();
        }
        if (oRect.top > 0.0f && oRect.bottom < (float)this.mViewRect.bottom) {
            cy = viewRect.centerY();
        }
        if ((nRect = new RectF(left = cx - Math.abs(cx - oRect.left) * sc, top = cy - Math.abs(cy - oRect.top) * sc, right = left + oRect.width() * sc, bottom = top + oRect.height() * sc)).width() < (float)this.mThumbShowBitmapRect.width() || nRect.height() < (float)this.mThumbShowBitmapRect.height()) {
            this.resetShowBitmapRect();
            return;
        }
        float scaleValue = nRect.width() / (float)this.mImageRect.width();
        if (scaleValue > this.mMaxScaleValue || scaleValue < this.mMinScaleValue) {
            return;
        }
        this.updateViewBitmapRect(nRect);
        float nx = 0.0f;
        float ny = 0.0f;
        RectF aRect = this.toViewCoordinate(this.mShowBitmapRect);
        if (aRect.width() < viewRect.width()) {
            nx = viewRect.centerX() - aRect.centerX();
        } else if (aRect.left > 0.0f) {
            nx = -aRect.left;
        } else if (aRect.right < viewRect.width()) {
            nx = viewRect.width() - aRect.right;
        }
        if (aRect.height() < viewRect.height()) {
            ny = viewRect.centerY() - aRect.centerY();
        } else if (aRect.top > 0.0f) {
            ny = -aRect.top;
        } else if (aRect.bottom < viewRect.height()) {
            ny = viewRect.height() - aRect.bottom;
        }
        aRect.offset(nx, ny);
        this.updateViewBitmapRect(aRect);
        this.postInvalidate();
    }

    public void scaleFromCenterTo(float dest, boolean smooth, long smoothTime) {
        this.scaleTo(this.mViewRect.centerX(), this.mViewRect.centerY(), dest, smooth, smoothTime);
    }

    public void scaleToMaxFitView(int cx, int cy, boolean smooth, long smoothTime) {
        this.scaleTo(cx, cy, this.getMaxFitViewScaleFactor(), smooth, smoothTime);
    }

    public void scaleToMinFitView(int cx, int cy, boolean smooth, long smoothTime) {
        this.scaleTo(cx, cy, this.getMinFitViewScaleFactor(), smooth, smoothTime);
    }

    private float getMaxFitViewScaleFactor() {
        float ws = this.mShowBitmapRect.width() == 0.0f ? 0.0f : (float)this.mViewRect.width() * 1.0f / this.mShowBitmapRect.width();
        float hs = this.mShowBitmapRect.height() == 0.0f ? 0.0f : (float)this.mViewRect.height() * 1.0f / this.mShowBitmapRect.height();
        return Math.max(ws, hs);
    }

    private float getMinFitViewScaleFactor() {
        float ws = this.mShowBitmapRect.width() == 0.0f ? 0.0f : (float)this.mViewRect.width() * 1.0f / this.mShowBitmapRect.width();
        float hs = this.mShowBitmapRect.height() == 0.0f ? 0.0f : (float)this.mViewRect.height() * 1.0f / this.mShowBitmapRect.height();
        return Math.min(ws, hs);
    }

    public float getCurScaleFactor() {
        if (this.checkImageNotAvailable()) {
            return 0.0f;
        }
        return this.mShowBitmapRect.height() * 1.0f / (float)this.mImageRect.height();
    }

    public void scaleToFitView(XImageView.TYPE_FIT type, int cx, int cy, boolean smooth, long smoothTime) {
        float destScale;
        if (this.mValueAnimator != null && this.mValueAnimator.isRunning()) {
            return;
        }
        if (this.checkImageNotAvailable() && this.isRectValid(this.mShowBitmapRect)) {
            return;
        }
        if (type == null) {
            type = XImageView.TYPE_FIT.FIT_VIEW;
        }
        float sw = this.mShowBitmapRect.width();
        float sh = this.mShowBitmapRect.height();
        int tw = this.mThumbShowBitmapRect.width();
        int th = this.mThumbShowBitmapRect.height();
        float maxFitScale = this.getMaxFitViewScaleFactor();
        float minFitScale = this.getMinFitViewScaleFactor();
        if (type == XImageView.TYPE_FIT.FIT_VIEW) {
            destScale = sw < (float)this.mViewRect.width() + 5.0f && sh < (float)this.mViewRect.height() + 5.0f ? maxFitScale : minFitScale;
        } else if (Math.abs(sw - (float)tw) < 5.0f && Math.abs(sh - (float)th) < 5.0f) {
            destScale = maxFitScale;
        } else {
            float ws = (float)this.mImageRect.width() * 1.0f / this.mShowBitmapRect.width();
            float hs = (float)this.mImageRect.height() * 1.0f / this.mShowBitmapRect.height();
            destScale = Math.min(minFitScale, Math.min(ws, hs));
        }
        this.scaleTo(cx, cy, destScale, smooth, smoothTime);
    }

    public void scaleTo(final int cx, final int cy, float dest, boolean smooth, long smoothTime) {
        if (this.checkImageNotAvailable()) {
            return;
        }
        if (this.mValueAnimator != null && this.mValueAnimator.isRunning()) {
            this.mValueAnimator.end();
            this.mValueAnimator.cancel();
        }
        if (smooth) {
            this.mLastAnimatedValue = 1.0f;
            ObjectAnimator.ofFloat((float[])new float[]{1.0f, dest});
            this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, dest});
            this.mValueAnimator.setDuration(smoothTime);
            this.mValueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    BitmapManager.this.scaleShowBitmap(cx, cy, value / BitmapManager.this.mLastAnimatedValue);
                    BitmapManager.this.mLastAnimatedValue = value;
                }
            });
            this.mValueAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    BitmapManager.this.updateSampleSize();
                }

                public void onAnimationCancel(Animator animation) {
                    BitmapManager.this.updateSampleSize();
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mValueAnimator.start();
        } else {
            this.scaleShowBitmap(cx, cy, dest);
            this.updateSampleSize();
        }
    }

    private float getMinFitViewValue() {
        if (this.checkImageNotAvailable()) {
            return 0.0f;
        }
        float iw = this.mImageRect.width();
        float ih = this.mImageRect.height();
        float vw = this.mViewRect.width();
        float vh = this.mViewRect.height();
        return Math.min(vw / iw, vh / ih);
    }

    private float getMaxFitViewValue() {
        if (this.checkImageNotAvailable()) {
            return 0.0f;
        }
        float iw = this.mImageRect.width();
        float ih = this.mImageRect.height();
        float vw = this.mViewRect.width();
        float vh = this.mViewRect.height();
        return Math.max(vw / iw, vh / ih);
    }

    private void resetShowBitmapRect() {
        this.mShowBitmapRect.set(this.mThumbShowBitmapRect);
        int left = (int)((this.mShowBitmapRect.width() - (float)this.mViewRect.width()) / 2.0f);
        int right = left + this.mViewRect.width();
        int top = (int)((this.mShowBitmapRect.height() - (float)this.mViewRect.height()) / 2.0f);
        int bottom = top + this.mViewRect.height();
        this.mViewBitmapRect.set(left, top, right, bottom);
    }

    private void updateViewBitmapRect(RectF rect) {
        Rect vRect = new Rect(0, 0, this.mViewRect.width(), this.mViewRect.height());
        vRect.left = (int)(-rect.left);
        vRect.right = vRect.left + this.mViewRect.width();
        vRect.top = (int)(-rect.top);
        vRect.bottom = vRect.top + this.mViewRect.height();
        this.mViewBitmapRect.set(vRect);
        this.mShowBitmapRect.set(0.0f, 0.0f, rect.width(), rect.height());
    }

    private boolean checkOrUpdateViewRect(int width, int height) {
        if (this.mViewRect.width() != width || this.mViewRect.height() != height) {
            this.onSetImageStart();
            this.updateViewRect(width, height);
            return true;
        }
        return false;
    }

    public boolean checkImageNotAvailable() {
        return this.mIsSettingImage || this.mSrcBitmap == null && this.mDecoder == null || this.mImageRect.width() <= 0 || this.mImageRect.height() <= 0;
    }

    public boolean drawVisibleBitmap(@NonNull Canvas canvas, int width, int height) {
        if (this.checkImageNotAvailable()) {
            return false;
        }
        if (this.mSrcBitmap != null && Build.VERSION.SDK_INT >= 14) {
            int mw = canvas.getMaximumBitmapWidth();
            int mh = canvas.getMaximumBitmapHeight();
            if (this.mSrcBitmap.getHeight() > mh || this.mSrcBitmap.getWidth() > mw) {
                Log.e((String)TAG, (String)"Bitmap is too large > canvas MaximumBitmapSize, You should cache it!");
            }
        }
        return !this.checkOrUpdateViewRect(width, height) && this.mBitmapGrid.drawVisibleGrid(canvas);
    }

    private float getShowImageRatio() {
        return this.mShowBitmapRect.height() * 1.0f / (float)this.mImageRect.height();
    }

    private float getRealImageRatio() {
        return 1.0f / (float)this.mSampleSize;
    }

    private float getRealShowRatio() {
        return (float)this.mImageRect.height() * 1.0f / ((float)this.mSampleSize * this.mShowBitmapRect.height());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleAll() {
        this.mBitmapGrid.recycleAllGrids();
        Object object = this.mBitmapLock;
        synchronized (object) {
            if (this.mDecoder != null) {
                this.mDecoder.recycle();
                this.mDecoder = null;
            }
            this.mSrcBitmap = null;
        }
    }

    private int getCurSampleSize() {
        int sampleSize;
        int iw = this.mImageRect.width();
        int ih = this.mImageRect.height();
        int bw = (int)this.mShowBitmapRect.width();
        int bh = (int)this.mShowBitmapRect.height();
        int width = (int)((float)iw * 1.0f / (float)ih * (float)bh);
        int n = sampleSize = width > bw ? this.computeSampleSize(iw / bw) : this.computeSampleSize(ih / bh);
        if (sampleSize < 1) {
            sampleSize = 1;
        }
        return sampleSize;
    }

    public void updateSampleSize() {
        if (this.checkImageNotAvailable()) {
            return;
        }
        int sampleSize = this.getCurSampleSize();
        if (sampleSize == this.mSampleSize) {
            return;
        }
        this.mSampleSize = sampleSize;
        this.postInvalidate();
    }

    public boolean isTapOnImage(int x, int y) {
        return !this.checkImageNotAvailable() && this.toViewCoordinate(this.mShowBitmapRect).contains((float)x, (float)y);
    }

    public boolean isSettingImage() {
        return this.mIsSettingImage;
    }

    private Rect toViewCoordinate(Rect rect) {
        if (rect == null) {
            return new Rect();
        }
        int left = rect.left - this.mViewBitmapRect.left;
        int right = left + rect.width();
        int top = rect.top - this.mViewBitmapRect.top;
        int bottom = top + rect.height();
        return new Rect(left, top, right, bottom);
    }

    private RectF toViewCoordinate(RectF rect) {
        if (rect == null) {
            return new RectF();
        }
        float left = rect.left - (float)this.mViewBitmapRect.left;
        float right = left + rect.width();
        float top = rect.top - (float)this.mViewBitmapRect.top;
        float bottom = top + rect.height();
        return new RectF(left, top, right, bottom);
    }

    private Rect toBitmapCoordinate(Rect rect) {
        if (rect == null) {
            return new Rect();
        }
        int left = rect.left + this.mViewBitmapRect.left;
        int right = left + rect.width();
        int top = rect.top + this.mViewBitmapRect.top;
        int bottom = top + rect.height();
        return new Rect(left, top, right, bottom);
    }

    private Rect getVisibleShowBitmapRect() {
        int left = (int)Math.max(this.mShowBitmapRect.left, (float)this.mViewBitmapRect.left);
        int right = (int)Math.min(this.mShowBitmapRect.right, (float)this.mViewBitmapRect.right);
        int top = (int)Math.max(this.mShowBitmapRect.top, (float)this.mViewBitmapRect.top);
        int bottom = (int)Math.min(this.mShowBitmapRect.bottom, (float)this.mViewBitmapRect.bottom);
        return new Rect(left, top, right, bottom);
    }

    private float getImageRatio() {
        return (float)this.mImageRect.height() * 1.0f / (float)this.mImageRect.width();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap decodeRectBitmap(Rect rect, int sampleSize) {
        if (rect == null || !this.mImageRect.contains(rect)) {
            return null;
        }
        Object object = this.mBitmapLock;
        synchronized (object) {
            if (this.mSrcBitmap != null) {
                return Bitmap.createBitmap((Bitmap)this.mSrcBitmap, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height());
            }
            if (this.mDecoder != null) {
                BitmapFactory.Options tmpOptions = new BitmapFactory.Options();
                tmpOptions.inPreferredConfig = this.mBitmapConfig;
                tmpOptions.inSampleSize = sampleSize;
                tmpOptions.inJustDecodeBounds = false;
                return this.mDecoder.decodeRegion(rect, tmpOptions);
            }
        }
        return null;
    }

    private RectF rectMulti(Rect r, float ratio) {
        return this.rectMulti(new RectF(r), ratio);
    }

    private RectF rectMulti(RectF r, float ratio) {
        float left = r.left * ratio;
        float top = r.top * ratio;
        float right = left + r.width() * ratio;
        float bottom = top + r.height() * ratio;
        return new RectF(left, top, right, bottom);
    }

    private int computeSampleSize(int size) {
        int sample = 1;
        while (size / 2 != 0) {
            size /= 2;
            sample *= 2;
        }
        return sample;
    }

    private boolean isRectValid(RectF rect) {
        return rect.width() > 0.0f && rect.height() > 0.0f;
    }

    private RectF scaleRect(RectF rect, float scale) {
        float cx = rect.centerX();
        float cy = rect.centerY();
        float left = (rect.left - cx) * scale + cx;
        float top = (rect.top - cy) * scale + cy;
        float right = (rect.right - cx) * scale + cx;
        float bottom = (right - left) * (rect.height() / rect.width()) + top;
        return new RectF(left, top, right, bottom);
    }

    private RectF getIntersectedRect(RectF rect1, RectF rect2) {
        if (!rect1.intersect(rect2)) {
            return new RectF();
        }
        float left = Math.max(rect2.left, rect1.left);
        float right = Math.min(rect2.right, rect1.right);
        float top = Math.max(rect2.top, rect1.top);
        float bottom = Math.min(rect2.bottom, rect1.bottom);
        return new RectF(left, top, right, bottom);
    }

    static {
        mPaint.setAntiAlias(true);
        mPaint.setColor(-1);
        mPaint.setStyle(Paint.Style.STROKE);
        mPaint.setStrokeWidth(2.0f);
    }

    public static interface IManagerCallback {
        public void onSetImageStart();

        public void onSetImageFinished(BitmapManager var1, boolean var2, Rect var3);
    }

    private class BitmapGrid {
        private int mN = 0;
        private int mM = 0;
        private BitmapUnit[][] mGrids = null;

        private BitmapGrid() {
        }

        private void initializeBitmapGrid() {
            if (this.mGrids != null) {
                this.recycleAllGrids();
            }
            int vw = BitmapManager.this.mViewRect.width();
            int vh = BitmapManager.this.mViewRect.height();
            int iw = BitmapManager.this.mImageRect.width();
            int ih = BitmapManager.this.mImageRect.height();
            this.mN = ih / vh + (ih % vh == 0 ? 0 : 1);
            this.mM = iw / vw + (iw % vw == 0 ? 0 : 1);
            this.mGrids = new BitmapUnit[this.mN][this.mM];
            for (int i = 0; i < this.mN; ++i) {
                for (int j = 0; j < this.mM; ++j) {
                    this.mGrids[i][j] = new BitmapUnit();
                    this.mGrids[i][j].mCurSampleSize = BitmapManager.this.mSampleSize;
                }
            }
            if (BitmapManager.this.mLoadingThread.isAlive()) {
                BitmapManager.this.mLoadingHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BitmapGrid.this.decodeThumbUnitBitmap();
                        BitmapManager.this.onSetImageFinished(true);
                    }
                });
            }
        }

        private Bitmap getGridBitmap(int n, int m) {
            if (this.isValidGrid(n, m)) {
                BitmapUnit unit = this.mGrids[n][m];
                if (BitmapManager.this.mSrcBitmap != null) {
                    return unit.mThumbBitmap;
                }
                if (BitmapManager.this.mSampleSize == BitmapManager.this.mThumbSampleSize) {
                    return unit.mThumbBitmap;
                }
                if (unit.mCurSampleSize != BitmapManager.this.mSampleSize) {
                    this.loadUnitBitmap(n, m);
                }
                return unit.mBitmap != null && !unit.mBitmap.isRecycled() ? unit.mBitmap : unit.mThumbBitmap;
            }
            return null;
        }

        private void loadUnitBitmap(final int n, final int m) {
            if (BitmapManager.this.mSampleSize != BitmapManager.this.mThumbSampleSize && this.isValidGrid(n, m)) {
                BitmapUnit unit = this.mGrids[n][m];
                if (unit.mIsLoading) {
                    return;
                }
                unit.mIsLoading = true;
                BitmapManager.this.mLoadingHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BitmapGrid.this.isValidGrid(n, m)) {
                            BitmapGrid.this.decodeVisibleUnitBitmap(n, m);
                            BitmapGrid.this.mGrids[n][m].mIsLoading = false;
                            if (((BitmapGrid)BitmapGrid.this).mGrids[n][m].mCurSampleSize != BitmapManager.this.mSampleSize) {
                                return;
                            }
                            BitmapManager.this.postInvalidate();
                        }
                    }
                });
            }
        }

        private void recycleAllGrids() {
            for (int i = 0; i < this.mN; ++i) {
                for (int j = 0; j < this.mM; ++j) {
                    this.mGrids[i][j].recycleAll();
                }
            }
        }

        private boolean isValidGrid(int n, int m) {
            return n >= 0 && n < this.mN && m >= 0 && m < this.mM;
        }

        private Rect getUnitRect(int n, int m) {
            if (n < 0 || n >= this.mN || m < 0 || m >= this.mM) {
                return null;
            }
            int vw = BitmapManager.this.mViewRect.width();
            int vh = BitmapManager.this.mViewRect.height();
            int iw = BitmapManager.this.mImageRect.width();
            int ih = BitmapManager.this.mImageRect.height();
            int left = Math.min(iw, m * vw);
            int right = Math.min(iw, left + vw);
            int top = Math.min(ih, n * vh);
            int bottom = Math.min(ih, top + vh);
            if (left == right || top == bottom) {
                return null;
            }
            return new Rect(left, top, right, bottom);
        }

        private Rect getShowBitmapUnit(int n, int m) {
            RectF vRect = BitmapManager.this.rectMulti(BitmapManager.this.mViewRect, BitmapManager.this.getShowImageRatio());
            float vw = vRect.width();
            float vh = vRect.height();
            float sWidth = BitmapManager.this.mShowBitmapRect.width();
            float sHeight = BitmapManager.this.mShowBitmapRect.height();
            float left = Math.min((float)m * vw, sWidth);
            float right = Math.min(left + vw, sWidth);
            float top = Math.min((float)n * vh, sHeight);
            float bottom = Math.min(top + vh, sHeight);
            return new Rect((int)left, (int)top, (int)right, (int)bottom);
        }

        private boolean isVisibleUnit(int n, int m) {
            Rect v = this.getVisibleGrid();
            return n >= v.top && n <= v.bottom && m >= v.left && m <= v.right;
        }

        private void recycleInvisibleGrids(Rect visible) {
            if (this.mGrids == null) {
                return;
            }
            int sn = visible.top;
            int sm = visible.left;
            int en = visible.bottom;
            int em = visible.right;
            int mn = 1;
            for (int i = 0; i < this.mN; ++i) {
                for (int j = 0; j < this.mM; ++j) {
                    if (sn - i < mn && i - en < mn && sm - j < mn && j - em < mn) continue;
                    this.mGrids[i][j].recycle();
                }
            }
        }

        private boolean drawVisibleGrid(Canvas canvas) {
            if (BitmapManager.this.mSrcBitmap == null && BitmapManager.this.mDecoder == null || this.mGrids == null || BitmapManager.this.mImageRect.width() <= 0 || BitmapManager.this.mImageRect.height() <= 0) {
                return false;
            }
            Rect visible = this.getVisibleGrid();
            this.recycleInvisibleGrids(visible);
            int sn = visible.top;
            int sm = visible.left;
            int en = visible.bottom;
            int em = visible.right;
            for (int n = sn; n <= en; ++n) {
                for (int m = sm; m <= em; ++m) {
                    Rect rect = this.getShowBitmapUnit(n, m);
                    Bitmap bitmap = this.getGridBitmap(n, m);
                    if (bitmap == null) continue;
                    Rect vRect = BitmapManager.this.toViewCoordinate(rect);
                    canvas.drawBitmap(bitmap, null, vRect, null);
                }
            }
            return true;
        }

        private synchronized void decodeVisibleUnitBitmap(int n, int m) {
            if (this.isValidGrid(n, m) && this.isVisibleUnit(n, m)) {
                BitmapUnit unit = this.mGrids[n][m];
                if (unit.mCurSampleSize == BitmapManager.this.mSampleSize) {
                    return;
                }
                unit.recycle();
                Rect rect = this.getUnitRect(n, m);
                unit.mCurSampleSize = BitmapManager.this.mSampleSize;
                unit.mBitmap = BitmapManager.this.decodeRectBitmap(rect, unit.mCurSampleSize);
            }
        }

        private void decodeThumbUnitBitmap() {
            for (int n = 0; n < this.mN; ++n) {
                for (int m = 0; m < this.mM; ++m) {
                    Rect rect = this.getUnitRect(n, m);
                    if (rect == null) continue;
                    this.mGrids[n][m].mCurSampleSize = BitmapManager.this.mSampleSize;
                    this.mGrids[n][m].mThumbBitmap = BitmapManager.this.decodeRectBitmap(rect, this.mGrids[n][m].mCurSampleSize);
                }
            }
        }

        private Rect getVisibleGrid() {
            float vw = (float)BitmapManager.this.mViewRect.width() * 1.0f / (float)BitmapManager.this.mSampleSize;
            float vh = (float)BitmapManager.this.mViewRect.height() * 1.0f / (float)BitmapManager.this.mSampleSize;
            RectF vBRect = BitmapManager.this.rectMulti(BitmapManager.this.getVisibleShowBitmapRect(), BitmapManager.this.getRealShowRatio());
            int sm = (int)(vBRect.left / vw);
            int sn = (int)(vBRect.top / vh);
            int em = (int)((double)sm + Math.ceil(vBRect.width() / vw));
            int en = (int)((double)sn + Math.ceil(vBRect.height() / vh));
            em = em > this.mM ? this.mM : em;
            en = en > this.mN ? this.mN : en;
            return new Rect(sm, sn, em, en);
        }
    }

    private class BitmapUnit {
        private boolean mIsLoading = false;
        public int mCurSampleSize = 0;
        public Bitmap mBitmap = null;
        public Bitmap mThumbBitmap = null;

        private BitmapUnit() {
        }

        private void recycleAll() {
            this.mBitmap = null;
            this.mThumbBitmap = null;
            this.mCurSampleSize = 0;
        }

        private void recycle() {
            this.mBitmap = null;
            this.mCurSampleSize = BitmapManager.this.mThumbSampleSize;
        }
    }
}

