/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import cn.jingzhuan.lib.chart.AxisAutoValues;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Axis;
import cn.jingzhuan.lib.chart.component.AxisX;
import cn.jingzhuan.lib.chart.component.AxisY;
import cn.jingzhuan.lib.chart.data.LabelColorSetter;
import cn.jingzhuan.lib.chart.data.LabelValueFormatter;
import cn.jingzhuan.lib.chart.renderer.Renderer;
import cn.jingzhuan.lib.chart.utils.FloatUtils;
import java.lang.ref.WeakReference;

public class AxisRenderer
implements Renderer {
    private Viewport mCurrentViewport;
    private Rect mContentRect;
    private Axis mAxis;
    private final char[] mLabelBuffer = new char[100];
    private Paint mGridPaint;
    private Paint mLabelTextPaint;
    private Paint mAxisPaint;
    private Paint mRenderPaint;
    private static final int[] POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000};
    private WeakReference<Bitmap> mDrawBitmap;
    private Canvas mBitmapCanvas;
    private Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;

    public AxisRenderer(Chart chart, Axis axis) {
        this.mCurrentViewport = chart.getCurrentViewport();
        this.mContentRect = chart.getContentRect();
        this.mAxis = axis;
        this.initPaints();
    }

    protected void initPaints() {
        this.mGridPaint = new Paint();
        this.mGridPaint.setStrokeWidth(this.mAxis.getGridThickness());
        this.mGridPaint.setColor(this.mAxis.getGridColor());
        this.mGridPaint.setStyle(Paint.Style.STROKE);
        this.mLabelTextPaint = new Paint();
        this.mLabelTextPaint.setAntiAlias(true);
        this.mLabelTextPaint.setTextSize(this.mAxis.getLabelTextSize());
        this.mLabelTextPaint.setColor(this.mAxis.getLabelTextColor());
        this.mAxis.setLabelWidth((int)this.mLabelTextPaint.measureText("0000"));
        this.mAxis.setLabelHeight((int)Math.abs(this.mLabelTextPaint.getFontMetrics().top));
        this.mAxisPaint = new Paint();
        this.mAxisPaint.setStrokeWidth(this.mAxis.getAxisThickness());
        this.mAxisPaint.setColor(this.mAxis.getAxisColor());
        this.mAxisPaint.setStyle(Paint.Style.STROKE);
        this.mRenderPaint = new Paint(1);
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public void renderer(Canvas canvas) {
        int width = this.mContentRect.width() + this.mContentRect.left;
        int height = this.mContentRect.height();
        if (this.mDrawBitmap == null || ((Bitmap)this.mDrawBitmap.get()).getWidth() != width || ((Bitmap)this.mDrawBitmap.get()).getHeight() != height) {
            if (width > 0 && height > 0) {
                this.mDrawBitmap = new WeakReference<Bitmap>(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.mBitmapConfig));
                this.mBitmapCanvas = new Canvas((Bitmap)this.mDrawBitmap.get());
            } else {
                return;
            }
        }
        ((Bitmap)this.mDrawBitmap.get()).eraseColor(0);
        if (this.mAxis instanceof AxisX) {
            AxisRenderer.computeAxisStopsX(this.mCurrentViewport.left, this.mCurrentViewport.right, (AxisX)this.mAxis, null);
        } else if (this.mAxis instanceof AxisY) {
            AxisRenderer.computeAxisStopsY((AxisY)this.mAxis);
        }
        this.drawAxisLine(this.mBitmapCanvas);
        if (this.mAxis.isGridLineEnable()) {
            this.drawGridLines(this.mBitmapCanvas);
        }
        canvas.drawBitmap((Bitmap)this.mDrawBitmap.get(), 0.0f, 0.0f, this.mRenderPaint);
    }

    private static void computeAxisStopsY(AxisY axis) {
        double min = axis.getYMin();
        double max = axis.getYMax();
        int count = axis.getGridCount() - 1;
        double interval = (max - min) / (double)count;
        axis.mLabelEntries = new float[axis.getGridCount()];
        double f = min;
        for (int j = 0; j < axis.getGridCount(); ++j) {
            axis.mLabelEntries[j] = (float)f;
            f += interval;
        }
    }

    private void drawAxisLine(Canvas canvas) {
        float startX = 0.0f;
        float startY = 0.0f;
        float stopX = 0.0f;
        float stopY = 0.0f;
        switch (this.mAxis.getAxisPosition()) {
            case 101: 
            case 103: {
                startX = this.mContentRect.left;
                startY = this.mContentRect.top;
                stopX = this.mContentRect.right;
                stopY = startY;
                break;
            }
            case 102: 
            case 104: {
                startX = this.mContentRect.left;
                startY = this.mContentRect.bottom;
                stopX = this.mContentRect.right;
                stopY = startY;
                break;
            }
            case 111: 
            case 112: {
                startX = this.mContentRect.left;
                startY = this.mContentRect.top;
                stopX = startX;
                stopY = this.mContentRect.bottom;
                break;
            }
            case 113: 
            case 114: {
                startX = this.mContentRect.right;
                startY = this.mContentRect.top;
                stopX = startX;
                stopY = this.mContentRect.bottom;
            }
        }
        if (this.mAxis.isEnable()) {
            canvas.drawLine(startX, startY, stopX, stopY, this.mAxisPaint);
        }
    }

    private static void computeAxisStopsX(float start, float stop, AxisX axis, AxisAutoValues autoValues) {
        double range = stop - start;
        if (axis.getGridCount() == 0 || range <= 0.0) {
            return;
        }
        int count = axis.getGridCount();
        double rawInterval = range / (double)count;
        double interval = AxisRenderer.roundToOneSignificantFigure(rawInterval);
        double first = Math.ceil((double)start / interval) * interval;
        axis.mLabelEntries = new float[count + 1];
        double f = first;
        for (int i = 0; i < count + 1; ++i) {
            axis.mLabelEntries[i] = (float)f;
            f += interval;
        }
    }

    private static float roundToOneSignificantFigure(double num) {
        float d = (float)Math.ceil((float)Math.log10(num < 0.0 ? -num : num));
        int power = 1 - (int)d;
        float magnitude = (float)Math.pow(10.0, power);
        long shifted = Math.round(num * (double)magnitude);
        return (float)shifted / magnitude;
    }

    private float getDrawX(float x) {
        return (float)this.mContentRect.left + (float)this.mContentRect.width() * (x - this.mCurrentViewport.left) / this.mCurrentViewport.width();
    }

    private float getDrawY(float y) {
        return (float)this.mContentRect.bottom - (float)this.mContentRect.height() * (y - this.mCurrentViewport.top) / this.mCurrentViewport.height();
    }

    private static int formatFloat(char[] out, float val, int digits) {
        boolean negative = false;
        if (val == 0.0f) {
            out[out.length - 1] = 48;
            return 1;
        }
        if (val < 0.0f) {
            negative = true;
            val = -val;
        }
        if (digits > POW10.length) {
            digits = POW10.length - 1;
        }
        long lval = Math.round(val *= (float)POW10[digits]);
        int index = out.length - 1;
        int charCount = 0;
        while (lval != 0L || charCount < digits + 1) {
            int digit = (int)(lval % 10L);
            lval /= 10L;
            out[index--] = (char)(digit + 48);
            if (++charCount != digits) continue;
            out[index--] = 46;
            ++charCount;
        }
        if (negative) {
            out[index--] = 45;
            ++charCount;
        }
        return charCount;
    }

    private void drawGridLines(Canvas canvas) {
        if (this.mAxis.isEnable()) {
            int i;
            int count = this.mAxis.getGridCount();
            if (this.mAxis.getDashedGridIntervals() != null && this.mAxis.getDashedGridPhase() > 0.0f) {
                this.mGridPaint.setPathEffect((PathEffect)new DashPathEffect(this.mAxis.getDashedGridIntervals(), this.mAxis.getDashedGridPhase()));
            }
            if (this.mAxis instanceof AxisX) {
                float width = this.mContentRect.width() / count;
                for (i = 1; i < count; ++i) {
                    canvas.drawLine((float)this.mContentRect.left + (float)i * width, (float)this.mContentRect.top, (float)this.mContentRect.left + (float)i * width, (float)this.mContentRect.bottom, this.mGridPaint);
                }
            }
            if (this.mAxis instanceof AxisY) {
                float height = this.mContentRect.height() / (count - 1);
                for (i = 1; i < count; ++i) {
                    canvas.drawLine((float)this.mContentRect.left, (float)this.mContentRect.top + (float)i * height, (float)this.mContentRect.right, (float)this.mContentRect.top + (float)i * height, this.mGridPaint);
                }
            }
        }
    }

    public void drawLabels(Canvas canvas) {
        if (!this.mAxis.isLabelEnable()) {
            return;
        }
        float[] labels = this.mAxis.mLabelEntries;
        if (labels == null || labels.length < 1) {
            return;
        }
        this.mLabelTextPaint.setColor(this.mAxis.getLabelTextColor());
        this.mLabelTextPaint.setTextSize(this.mAxis.getLabelTextSize());
        float x = 0.0f;
        float y = 0.0f;
        switch (this.mAxis.getAxisPosition()) {
            case 101: 
            case 103: {
                x = this.mContentRect.left;
                y = this.mContentRect.top;
                break;
            }
            case 102: 
            case 104: {
                x = this.mContentRect.left;
                y = this.mContentRect.top + this.mContentRect.height();
                break;
            }
            case 111: 
            case 112: {
                x = this.mContentRect.left;
                y = this.mContentRect.bottom;
                break;
            }
            case 113: 
            case 114: {
                x = this.mContentRect.right;
                y = this.mContentRect.bottom;
            }
        }
        if (this.mAxis instanceof AxisX) {
            float width = this.mContentRect.width() / (labels.length - 1);
            for (int i = 0; i < labels.length; ++i) {
                int labelLength;
                LabelValueFormatter labelValueFormatter = this.mAxis.getLabelValueFormatter();
                if (labelValueFormatter == null) {
                    labelLength = FloatUtils.formatFloatValue(this.mLabelBuffer, labels[i], 2);
                } else {
                    char[] labelCharArray = labelValueFormatter.format(labels[i], i).toCharArray();
                    labelLength = labelCharArray.length;
                    System.arraycopy(labelCharArray, 0, this.mLabelBuffer, this.mLabelBuffer.length - labelLength, labelLength);
                }
                int labelOffset = this.mLabelBuffer.length - labelLength;
                if (i == 0) {
                    this.mLabelTextPaint.setTextAlign(Paint.Align.LEFT);
                } else if (i == labels.length - 1) {
                    this.mLabelTextPaint.setTextAlign(Paint.Align.RIGHT);
                } else {
                    this.mLabelTextPaint.setTextAlign(Paint.Align.CENTER);
                }
                canvas.drawText(this.mLabelBuffer, labelOffset, labelLength, x + (float)i * width, y + this.mLabelTextPaint.getTextSize(), this.mLabelTextPaint);
            }
        } else {
            float height = this.mContentRect.height() / (labels.length - 1);
            float separation = 0.0f;
            for (int i = 0; i < labels.length; ++i) {
                int labelLength;
                LabelValueFormatter labelValueFormatter = this.mAxis.getLabelValueFormatter();
                if (labelValueFormatter == null) {
                    labelLength = FloatUtils.formatFloatValue(this.mLabelBuffer, labels[i], 2);
                } else {
                    char[] labelCharArray = labelValueFormatter.format(labels[i], i).toCharArray();
                    labelLength = labelCharArray.length;
                    System.arraycopy(labelCharArray, 0, this.mLabelBuffer, this.mLabelBuffer.length - labelLength, labelLength);
                }
                int labelOffset = this.mLabelBuffer.length - labelLength;
                switch (this.mAxis.getAxisPosition()) {
                    case 111: 
                    case 114: {
                        this.mLabelTextPaint.setTextAlign(Paint.Align.RIGHT);
                        separation = -this.mAxis.getLabelSeparation();
                        break;
                    }
                    case 112: 
                    case 113: {
                        this.mLabelTextPaint.setTextAlign(Paint.Align.LEFT);
                        separation = this.mAxis.getLabelSeparation();
                    }
                }
                float textHeightOffset = (this.mLabelTextPaint.descent() + this.mLabelTextPaint.ascent()) / 2.0f;
                if (i == 0) {
                    textHeightOffset = this.mAxis.getLabelSeparation();
                } else if (i == labels.length - 1) {
                    textHeightOffset += textHeightOffset - (float)this.mAxis.getLabelSeparation();
                }
                LabelColorSetter colorSetter = ((AxisY)this.mAxis).getLabelColorSetter();
                if (colorSetter != null) {
                    this.mLabelTextPaint.setColor(colorSetter.getColorByIndex(i));
                }
                canvas.drawText(this.mLabelBuffer, labelOffset, labelLength, x + separation, y - (float)i * height - textHeightOffset, this.mLabelTextPaint);
            }
        }
    }
}

