/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.CandlestickData;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import java.util.List;

public class CandlestickChartRenderer
extends AbstractDataRenderer<CandlestickDataSet> {
    private float[] mUpperShadowBuffers = new float[4];
    private float[] mLowerShadowBuffers = new float[4];
    private float[] mBodyBuffers = new float[4];
    private CandlestickData chartData;

    public CandlestickChartRenderer(final Chart chart) {
        super(chart);
        chart.setInternalViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                CandlestickChartRenderer.this.mViewport = viewport;
                CandlestickChartRenderer.this.calcDataSetMinMax();
            }
        });
        chart.addOnTouchPointChangeListener(new Chart.OnTouchPointChangeListener(){

            @Override
            public void touch(float x, float y) {
                for (CandlestickDataSet dataSet : CandlestickChartRenderer.this.getDataSet()) {
                    if (!dataSet.isHighlightedVerticalEnable()) continue;
                    float valueCount = dataSet.getEntryCount();
                    int index = 0;
                    float xPosition = x;
                    float yPosition = -1.0f;
                    if (x > (float)CandlestickChartRenderer.this.mContentRect.left) {
                        index = (int)(((x - (float)CandlestickChartRenderer.this.mContentRect.left) * CandlestickChartRenderer.this.mViewport.width() / (float)CandlestickChartRenderer.this.mContentRect.width() + CandlestickChartRenderer.this.mViewport.left) * valueCount);
                        if (index >= dataSet.getValues().size()) {
                            index = dataSet.getValues().size() - 1;
                        }
                        CandlestickValue candlestickValue = dataSet.getEntryForIndex(index);
                        xPosition = candlestickValue.getX();
                        yPosition = candlestickValue.getY();
                    }
                    chart.highlightValue(new Highlight(xPosition, yPosition, index));
                }
            }
        });
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<CandlestickDataSet> chartData) {
        for (CandlestickDataSet dataSet : chartData.getDataSets()) {
            if (!dataSet.isVisible()) continue;
            this.drawDataSet(canvas, dataSet, chartData.getLeftMax(), chartData.getLeftMin(), chartData.getRightMax(), chartData.getRightMin());
        }
    }

    private void drawDataSet(Canvas canvas, CandlestickDataSet candlestickDataSet, float lMax, float lMin, float rMax, float rMin) {
        float max;
        float min;
        switch (candlestickDataSet.getAxisDependency()) {
            case 24: {
                min = rMin;
                max = rMax;
                break;
            }
            default: {
                min = lMin;
                max = lMax;
            }
        }
        this.mRenderPaint.setStrokeWidth(candlestickDataSet.getStrokeThickness());
        this.mRenderPaint.setColor(candlestickDataSet.getColor());
        int valueCount = candlestickDataSet.getEntryCount();
        Path path = new Path();
        path.reset();
        for (int i = 0; i < valueCount; ++i) {
            float candlestickCenterX;
            CandlestickValue candlestick = candlestickDataSet.getEntryForIndex(i);
            float candleWidth = candlestickDataSet.getCandleWidth();
            if (candlestickDataSet.isAutoWidth()) {
                candleWidth = this.mContentRect.width() / candlestickDataSet.getVisibleValueCount(this.mViewport);
            }
            float xPosition = this.getDrawX((float)i / ((float)valueCount + 0.0f));
            float highY = (max - candlestick.getHigh()) / (max - min) * (float)this.mContentRect.height();
            float lowY = (max - candlestick.getLow()) / (max - min) * (float)this.mContentRect.height();
            float openY = (max - candlestick.getOpen()) / (max - min) * (float)this.mContentRect.height();
            float closeY = (max - candlestick.getClose()) / (max - min) * (float)this.mContentRect.height();
            float widthPercent = 0.8f;
            this.mBodyBuffers[0] = xPosition + (1.0f - widthPercent) * 0.5f * candleWidth;
            this.mBodyBuffers[1] = closeY;
            this.mBodyBuffers[2] = this.mBodyBuffers[0] + candleWidth * widthPercent;
            this.mBodyBuffers[3] = openY;
            this.mUpperShadowBuffers[0] = candlestickCenterX = xPosition + candleWidth * 0.5f;
            this.mUpperShadowBuffers[2] = candlestickCenterX;
            this.mLowerShadowBuffers[0] = candlestickCenterX;
            this.mLowerShadowBuffers[2] = candlestickCenterX;
            candlestick.setX(candlestickCenterX);
            candlestick.setY(closeY);
            if (Float.compare(candlestick.getOpen(), candlestick.getClose()) > 0) {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = openY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = closeY;
                if (candlestick.getColor() == 0) {
                    this.mRenderPaint.setColor(candlestickDataSet.getDecreasingColor());
                } else {
                    this.mRenderPaint.setColor(candlestick.getColor());
                }
                if (candlestick.getPaintStyle() != null) {
                    this.mRenderPaint.setStyle(candlestick.getPaintStyle());
                } else {
                    this.mRenderPaint.setStyle(candlestickDataSet.getDecreasingPaintStyle());
                }
            } else if (Float.compare(candlestick.getOpen(), candlestick.getClose()) < 0) {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = closeY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = openY;
                if (candlestick.getColor() == 0) {
                    this.mRenderPaint.setColor(candlestickDataSet.getIncreasingColor());
                } else {
                    this.mRenderPaint.setColor(candlestick.getColor());
                }
                if (candlestick.getPaintStyle() != null) {
                    this.mRenderPaint.setStyle(candlestick.getPaintStyle());
                } else {
                    this.mRenderPaint.setStyle(candlestickDataSet.getIncreasingPaintStyle());
                }
            } else {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = openY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = this.mUpperShadowBuffers[3];
                if (candlestick.getColor() == 0) {
                    this.mRenderPaint.setColor(candlestickDataSet.getNeutralColor());
                } else {
                    this.mRenderPaint.setColor(candlestick.getColor());
                }
            }
            if (candlestickDataSet.getLimitUpColor() != 0 && i > 0) {
                boolean isLimitUp;
                CandlestickValue previousValue = candlestickDataSet.getEntryForIndex(i - 1);
                boolean bl = isLimitUp = Float.compare((candlestick.getClose() - previousValue.getClose()) / previousValue.getClose(), 0.095f) > 0;
                if (isLimitUp) {
                    this.mRenderPaint.setColor(candlestickDataSet.getLimitUpColor());
                }
            }
            canvas.drawRect(this.mBodyBuffers[0], this.mBodyBuffers[1], this.mBodyBuffers[2], this.mBodyBuffers[3], this.mRenderPaint);
            canvas.drawLines(this.mUpperShadowBuffers, this.mRenderPaint);
            canvas.drawLines(this.mLowerShadowBuffers, this.mRenderPaint);
        }
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        this.mRenderPaint.setColor(this.getHighlightColor());
        this.mRenderPaint.setStrokeWidth(2.0f);
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        if (this.mDashedHighlightPhase > 0.0f) {
            this.mRenderPaint.setPathEffect((PathEffect)new DashPathEffect(this.mDashedHighlightIntervals, this.mDashedHighlightPhase));
        }
        for (Highlight highlight : highlights) {
            for (CandlestickDataSet dataSet : this.getDataSet()) {
                if (dataSet.isHighlightedVerticalEnable()) {
                    canvas.drawLine(highlight.getX(), (float)this.mContentRect.top, highlight.getX(), (float)this.mContentRect.bottom, this.mRenderPaint);
                }
                if (!dataSet.isHighlightedHorizontalEnable()) continue;
                canvas.drawLine((float)this.mContentRect.left, highlight.getY(), (float)this.mContentRect.right, highlight.getY(), this.mRenderPaint);
            }
        }
        this.mRenderPaint.setPathEffect(null);
    }

    @Override
    public void addDataSet(CandlestickDataSet dataSet) {
        this.getChartData().add(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void removeDataSet(CandlestickDataSet dataSet) {
        this.getChartData().remove(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void clearDataSet() {
        this.getChartData().clear();
        this.getChartData().calcMaxMin(this.mViewport, this.mContentRect);
    }

    @Override
    public List<CandlestickDataSet> getDataSet() {
        return this.chartData.getDataSets();
    }

    @Override
    public ChartData<CandlestickDataSet> getChartData() {
        if (this.chartData == null) {
            this.chartData = new CandlestickData();
        }
        return this.chartData;
    }
}

