/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.BarData;
import cn.jingzhuan.lib.chart.data.BarDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickData;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.LineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.data.ScatterData;
import cn.jingzhuan.lib.chart.data.ScatterDataSet;
import java.util.List;

public class CombineData
extends ChartData<AbstractDataSet> {
    private BarData barData = new BarData();
    private LineData lineData = new LineData();
    private CandlestickData candlestickData = new CandlestickData();
    private ScatterData scatterData = new ScatterData();

    public List<BarDataSet> getBarData() {
        return this.barData.getDataSets();
    }

    public List<LineDataSet> getLineData() {
        return this.lineData.getDataSets();
    }

    public List<CandlestickDataSet> getCandlestickData() {
        return this.candlestickData.getDataSets();
    }

    public List<ScatterDataSet> getScatterData() {
        return this.scatterData.getDataSets();
    }

    public BarData getBarChartData() {
        return this.barData;
    }

    public LineData getLineChartData() {
        return this.lineData;
    }

    public CandlestickData getCandlestickChartData() {
        return this.candlestickData;
    }

    public ScatterData getScatterChartData() {
        return this.scatterData;
    }

    public boolean addDataSet(BarDataSet dataSet) {
        return this.barData.add(dataSet);
    }

    public boolean addDataSet(LineDataSet dataSet) {
        return this.lineData.add(dataSet);
    }

    public boolean addDataSet(CandlestickDataSet dataSet) {
        return this.candlestickData.add(dataSet);
    }

    public boolean addDataSet(ScatterDataSet dataSet) {
        return this.scatterData.add(dataSet);
    }

    @Override
    public void calcMaxMin(Viewport viewport, Rect content) {
        this.leftMin = Float.MAX_VALUE;
        this.leftMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
        if (!this.candlestickData.getDataSets().isEmpty()) {
            this.candlestickData.calcMaxMin(viewport, content);
            this.leftMin = Math.min(this.candlestickData.leftMin, this.leftMin);
            this.leftMax = Math.max(this.candlestickData.leftMax, this.leftMax);
            this.rightMin = Math.min(this.candlestickData.rightMin, this.rightMin);
            this.rightMax = Math.max(this.candlestickData.rightMax, this.rightMax);
        }
        if (!this.lineData.getDataSets().isEmpty()) {
            this.lineData.calcMaxMin(viewport, content);
            this.leftMin = Math.min(this.lineData.leftMin, this.leftMin);
            this.leftMax = Math.max(this.lineData.leftMax, this.leftMax);
            this.rightMin = Math.min(this.lineData.rightMin, this.rightMin);
            this.rightMax = Math.max(this.lineData.rightMax, this.rightMax);
        }
        if (!this.barData.getDataSets().isEmpty()) {
            this.barData.calcMaxMin(viewport, content);
            this.leftMin = Math.min(this.barData.leftMin, this.leftMin);
            this.leftMax = Math.max(this.barData.leftMax, this.leftMax);
            this.rightMin = Math.min(this.barData.rightMin, this.rightMin);
            this.rightMax = Math.max(this.barData.rightMax, this.rightMax);
        }
        if (!this.scatterData.getDataSets().isEmpty()) {
            this.scatterData.calcMaxMin(viewport, content);
            this.leftMin = Math.min(this.scatterData.leftMin, this.leftMin);
            this.leftMax = Math.max(this.scatterData.leftMax, this.leftMax);
            this.rightMin = Math.min(this.scatterData.rightMin, this.rightMin);
            this.rightMax = Math.max(this.scatterData.rightMax, this.rightMax);
        }
        this.barData.setLeftMax(this.leftMax);
        this.lineData.setLeftMax(this.leftMax);
        this.candlestickData.setLeftMax(this.leftMax);
        this.scatterData.setLeftMax(this.leftMax);
        this.barData.setLeftMin(this.leftMin);
        this.lineData.setLeftMin(this.leftMin);
        this.candlestickData.setLeftMin(this.leftMin);
        this.scatterData.setLeftMin(this.leftMin);
        this.barData.setRightMax(this.rightMax);
        this.lineData.setRightMax(this.rightMax);
        this.candlestickData.setRightMax(this.rightMax);
        this.scatterData.setRightMax(this.rightMax);
        this.barData.setRightMin(this.rightMin);
        this.lineData.setRightMin(this.rightMin);
        this.candlestickData.setRightMin(this.rightMin);
        this.scatterData.setRightMin(this.rightMin);
        this.setMinMax();
    }

    @Override
    public boolean add(AbstractDataSet e) {
        if (e instanceof CandlestickDataSet) {
            return this.addDataSet((CandlestickDataSet)e);
        }
        if (e instanceof LineDataSet) {
            return this.addDataSet((LineDataSet)e);
        }
        if (e instanceof BarDataSet) {
            return this.addDataSet((BarDataSet)e);
        }
        if (e instanceof ScatterDataSet) {
            return this.addDataSet((ScatterDataSet)e);
        }
        return super.add(e);
    }

    @Override
    public void setMinMax() {
        if (this.leftAxis != null) {
            this.leftAxis.setYMin(this.leftMin);
            this.leftAxis.setYMax(this.leftMax);
        }
        if (this.rightAxis != null) {
            this.rightAxis.setYMin(this.rightMin);
            this.rightAxis.setYMax(this.rightMax);
        }
    }
}

