/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.ChartData;

public class CandlestickData
extends ChartData<CandlestickDataSet> {
    private float mViewportWidth = -1.0f;

    @Override
    public void calcMaxMin(Viewport viewport, Rect content) {
        if (this.getDataSets().isEmpty()) {
            return;
        }
        this.leftMax = -3.4028235E38f;
        this.leftMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        for (CandlestickDataSet candlestickDataSet : this.getDataSets()) {
            boolean needCalcCandleWidth = Float.compare(viewport.width(), this.mViewportWidth) != 0;
            candlestickDataSet.calcMinMax(viewport);
            if (needCalcCandleWidth) {
                candlestickDataSet.setCandleWidth(content.width() / (candlestickDataSet.getVisibleCount(viewport) + 1));
            }
            this.mViewportWidth = viewport.width();
            if (candlestickDataSet.getAxisDependency() == 25 || candlestickDataSet.getAxisDependency() == 23) {
                this.leftMin = Math.min(this.leftMin, candlestickDataSet.getViewportYMin());
                this.leftMax = Math.max(this.leftMax, candlestickDataSet.getViewportYMax());
            }
            if (candlestickDataSet.getAxisDependency() != 25 && candlestickDataSet.getAxisDependency() != 24) continue;
            this.rightMin = Math.min(this.rightMin, candlestickDataSet.getViewportYMin());
            this.rightMax = Math.max(this.rightMax, candlestickDataSet.getViewportYMax());
        }
        this.setMinMax();
    }
}

