/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.CandlestickData;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import java.util.List;

public class CandlestickChartRenderer
extends AbstractDataRenderer<CandlestickDataSet> {
    private float[] mUpperShadowBuffers = new float[4];
    private float[] mLowerShadowBuffers = new float[4];
    private float[] mBodyBuffers = new float[4];
    private CandlestickData chartData;

    public CandlestickChartRenderer(final Chart chart) {
        super(chart);
        chart.setInternalViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                CandlestickChartRenderer.this.mViewport = viewport;
                CandlestickChartRenderer.this.calcDataSetMinMax();
            }
        });
        chart.addOnTouchPointChangeListener(new Chart.OnTouchPointChangeListener(){

            @Override
            public void touch(float x, float y) {
                for (CandlestickDataSet dataSet : CandlestickChartRenderer.this.getDataSet()) {
                    if (!dataSet.isHighlightedEnable()) continue;
                    float candleWidth = dataSet.getCandleWidth();
                    float valueCount = dataSet.getEntryCount();
                    int index = 0;
                    float xPosition = x;
                    float yPosition = -1.0f;
                    if (x > (float)CandlestickChartRenderer.this.mContentRect.left) {
                        index = (int)(((x - (float)CandlestickChartRenderer.this.mContentRect.left + candleWidth * 0.5f) * CandlestickChartRenderer.this.mViewport.width() / ((float)CandlestickChartRenderer.this.mContentRect.width() - candleWidth) + CandlestickChartRenderer.this.mViewport.left) * (valueCount - 1.0f));
                        if (index >= dataSet.getValues().size()) {
                            index = dataSet.getValues().size() - 1;
                        }
                        CandlestickValue candlestickValue = dataSet.getEntryForIndex(index);
                        xPosition = candlestickValue.getX();
                        yPosition = candlestickValue.getY();
                    }
                    chart.highlightValue(new Highlight(xPosition, yPosition, index));
                }
            }
        });
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<CandlestickDataSet> chartData) {
        for (CandlestickDataSet dataSet : chartData.getDataSets()) {
            if (!dataSet.isVisible()) continue;
            this.drawDataSet(canvas, dataSet, chartData.getLeftMax(), chartData.getLeftMin(), chartData.getRightMax(), chartData.getRightMin());
        }
    }

    @Override
    protected void renderDataSet(Canvas canvas) {
        this.renderDataSet(canvas, this.getChartData());
    }

    private void drawDataSet(Canvas canvas, CandlestickDataSet candlestickDataSet, float lMax, float lMin, float rMax, float rMin) {
        float max;
        float min;
        switch (candlestickDataSet.getAxisDependency()) {
            case 24: {
                min = rMin;
                max = rMax;
                break;
            }
            default: {
                min = lMin;
                max = lMax;
            }
        }
        this.mRenderPaint.setStrokeWidth(5.0f);
        this.mRenderPaint.setColor(candlestickDataSet.getColor());
        int valueCount = candlestickDataSet.getEntryCount();
        Path path = new Path();
        path.reset();
        for (int i = 0; i < valueCount; ++i) {
            CandlestickValue candlestick = candlestickDataSet.getEntryForIndex(i);
            this.mRenderPaint.setStyle(candlestick.getPaintStyle());
            float candleWidth = candlestickDataSet.getCandleWidth();
            if (candleWidth <= 0.0f) {
                candleWidth = this.mContentRect.width() / valueCount;
            }
            float xPosition = (float)this.mContentRect.left + candleWidth * 0.5f + ((float)this.mContentRect.width() - candleWidth) * ((float)i / ((float)valueCount - 1.0f) - this.mViewport.left) / this.mViewport.width();
            float highY = (max - candlestick.getHigh()) / (max - min) * (float)this.mContentRect.height();
            float lowY = (max - candlestick.getLow()) / (max - min) * (float)this.mContentRect.height();
            float openY = (max - candlestick.getOpen()) / (max - min) * (float)this.mContentRect.height();
            float closeY = (max - candlestick.getClose()) / (max - min) * (float)this.mContentRect.height();
            this.mBodyBuffers[0] = xPosition - candleWidth * 0.4f;
            this.mBodyBuffers[1] = closeY;
            this.mBodyBuffers[2] = xPosition + candleWidth * 0.4f;
            this.mBodyBuffers[3] = openY;
            this.mUpperShadowBuffers[0] = xPosition;
            this.mUpperShadowBuffers[2] = xPosition;
            this.mLowerShadowBuffers[0] = xPosition;
            this.mLowerShadowBuffers[2] = xPosition;
            candlestick.setX(xPosition);
            candlestick.setY(closeY);
            if (Float.compare(candlestick.getOpen(), candlestick.getClose()) > 0) {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = openY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = closeY;
                if (candlestick.getColor() == 0) {
                    this.mRenderPaint.setColor(candlestickDataSet.getDecreasingColor());
                } else {
                    this.mRenderPaint.setColor(candlestick.getColor());
                }
            } else if (Float.compare(candlestick.getOpen(), candlestick.getClose()) < 0) {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = closeY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = openY;
                if (candlestick.getColor() == 0) {
                    this.mRenderPaint.setColor(candlestickDataSet.getIncreasingColor());
                } else {
                    this.mRenderPaint.setColor(candlestick.getColor());
                }
            } else {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = openY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = this.mUpperShadowBuffers[3];
                if (candlestick.getColor() == 0) {
                    this.mRenderPaint.setColor(candlestickDataSet.getNeutralColor());
                } else {
                    this.mRenderPaint.setColor(candlestick.getColor());
                }
            }
            if (candlestickDataSet.getLimitUpColor() != 0 && i > 0) {
                boolean isLimitUp;
                CandlestickValue previousValue = candlestickDataSet.getEntryForIndex(i - 1);
                boolean bl = isLimitUp = Float.compare((candlestick.getClose() - previousValue.getClose()) / previousValue.getClose(), 0.095f) > 0;
                if (isLimitUp) {
                    this.mRenderPaint.setColor(candlestickDataSet.getLimitUpColor());
                }
            }
            canvas.drawRect(this.mBodyBuffers[0], this.mBodyBuffers[1], this.mBodyBuffers[2], this.mBodyBuffers[3], this.mRenderPaint);
            canvas.drawLines(this.mUpperShadowBuffers, this.mRenderPaint);
            canvas.drawLines(this.mLowerShadowBuffers, this.mRenderPaint);
        }
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        this.mRenderPaint.setColor(this.getHighlightColor());
        this.mRenderPaint.setStrokeWidth(2.0f);
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        if (this.mDashedHighlightPhase > 0.0f) {
            this.mRenderPaint.setPathEffect((PathEffect)new DashPathEffect(this.mDashedHighlightIntervals, this.mDashedHighlightPhase));
        }
        for (Highlight highlight : highlights) {
            canvas.drawLine(highlight.getX(), (float)this.mContentRect.top, highlight.getX(), (float)this.mContentRect.bottom, this.mRenderPaint);
            canvas.drawLine((float)this.mContentRect.left, highlight.getY(), (float)this.mContentRect.right, highlight.getY(), this.mRenderPaint);
        }
        this.mRenderPaint.setPathEffect(null);
    }

    @Override
    public void addDataSet(CandlestickDataSet dataSet) {
        this.chartData.add(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void removeDataSet(CandlestickDataSet dataSet) {
        this.chartData.remove(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void clearDataSet() {
        this.chartData.clear();
        this.chartData.calcMaxMin(this.mViewport, this.mContentRect);
    }

    @Override
    public List<CandlestickDataSet> getDataSet() {
        return this.chartData.getDataSets();
    }

    @Override
    public ChartData<CandlestickDataSet> getChartData() {
        if (this.chartData == null) {
            this.chartData = new CandlestickData();
        }
        return this.chartData;
    }

    @Override
    public void calcDataSetMinMax() {
        this.chartData.calcMaxMin(this.mViewport, this.mContentRect);
    }
}

