/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.AxisY;
import cn.jingzhuan.lib.chart.data.IDataSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChartData<T extends IDataSet> {
    private List<T> chartData;
    protected float leftMin = Float.MAX_VALUE;
    protected float leftMax = -3.4028235E38f;
    protected float rightMin = Float.MAX_VALUE;
    protected float rightMax = -3.4028235E38f;
    private int entryCount = 0;
    protected AxisY leftAxis;
    protected AxisY rightAxis;

    public ChartData() {
        this.chartData = new CopyOnWriteArrayList<T>();
    }

    public List<T> getDataSets() {
        if (this.chartData == null) {
            this.chartData = new CopyOnWriteArrayList<T>();
        }
        return this.chartData;
    }

    public boolean add(T e) {
        if (e == null) {
            return false;
        }
        return this.getDataSets().add(e);
    }

    public boolean remove(T e) {
        return e != null && this.getDataSets().remove(e);
    }

    public void clear() {
        this.getDataSets().clear();
    }

    public void setMinMax() {
        this.leftMin = Float.MAX_VALUE;
        this.leftMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
        for (IDataSet t : this.getDataSets()) {
            if (t.getAxisDependency() == 25 || t.getAxisDependency() == 23) {
                if (t.getViewportYMax() > this.leftMax) {
                    this.leftMax = t.getViewportYMax();
                }
                if (t.getViewportYMin() < this.leftMin) {
                    this.leftMin = t.getViewportYMin();
                }
            }
            if (t.getAxisDependency() == 25 || t.getAxisDependency() == 24) {
                if (t.getViewportYMax() > this.rightMax) {
                    this.rightMax = t.getViewportYMax();
                }
                if (t.getViewportYMin() < this.rightMin) {
                    this.rightMin = t.getViewportYMin();
                }
            }
            if (t.getEntryCount() <= this.entryCount) continue;
            this.entryCount = t.getEntryCount();
        }
        if (this.leftAxis != null && this.leftMin != Float.MAX_VALUE) {
            this.leftAxis.setYMin(this.leftMin);
            this.leftAxis.setYMax(this.leftMax);
        }
        if (this.rightAxis != null && this.rightMin != Float.MAX_VALUE) {
            this.rightAxis.setYMin(this.rightMin);
            this.rightAxis.setYMax(this.rightMax);
        }
    }

    public void calcMaxMin(Viewport viewport, Rect content) {
        for (IDataSet t : this.chartData) {
            t.calcMinMax(viewport);
            if (t.getAxisDependency() == 25 || t.getAxisDependency() == 23) {
                this.leftMax = Math.max(this.leftMax, t.getViewportYMax());
                this.leftMin = Math.min(this.leftMin, t.getViewportYMin());
            }
            if (t.getAxisDependency() == 25 || t.getAxisDependency() == 24) {
                this.rightMax = Math.max(this.rightMax, t.getViewportYMax());
                this.rightMin = Math.min(this.rightMin, t.getViewportYMin());
            }
            if (t.getEntryCount() <= this.entryCount) continue;
            this.entryCount = t.getEntryCount();
        }
        if (this.leftAxis != null && this.leftMin != Float.MAX_VALUE) {
            this.leftAxis.setYMin(this.leftMin);
            this.leftAxis.setYMax(this.leftMax);
        }
        if (this.rightAxis != null && this.rightMin != Float.MAX_VALUE) {
            this.rightAxis.setYMin(this.rightMin);
            this.rightAxis.setYMax(this.rightMax);
        }
    }

    public float getLeftMin() {
        return this.leftMin;
    }

    public float getRightMax() {
        return this.rightMax;
    }

    public float getRightMin() {
        return this.rightMin;
    }

    public float getLeftMax() {
        return this.leftMax;
    }

    public void setLeftMin(float leftMin) {
        this.leftMin = leftMin;
    }

    public void setLeftMax(float leftMax) {
        this.leftMax = leftMax;
    }

    public void setRightMin(float rightMin) {
        this.rightMin = rightMin;
    }

    public void setRightMax(float rightMax) {
        this.rightMax = rightMax;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void setChart(Chart chart) {
        this.leftAxis = chart.getAxisLeft();
        this.rightAxis = chart.getAxisRight();
    }
}

