/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.util.Log;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.BarDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CombineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import cn.jingzhuan.lib.chart.renderer.BarChartRenderer;
import cn.jingzhuan.lib.chart.renderer.CandlestickChartRenderer;
import cn.jingzhuan.lib.chart.renderer.LineRenderer;
import java.util.List;

public class CombineChartRenderer
extends AbstractDataRenderer {
    private BarChartRenderer barChartRenderer;
    private LineRenderer lineRenderer;
    private CandlestickChartRenderer candlestickChartRenderer;
    private CombineData combineData = new CombineData();

    public CombineChartRenderer(Chart chart) {
        super(chart);
        this.lineRenderer = new LineRenderer(chart);
        this.barChartRenderer = new BarChartRenderer(chart);
        this.candlestickChartRenderer = new CandlestickChartRenderer(chart);
        chart.setOnViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                CombineChartRenderer.this.combineData.calcDataSetMinMax(viewport, CombineChartRenderer.this.mContentRect);
                CombineChartRenderer.this.combineData.calcMinMax();
                Log.d((String)"ChartRenderer", (String)("calcMinMax, " + CombineChartRenderer.this.combineData.getLeftMin() + ", " + CombineChartRenderer.this.combineData.getLeftMax()));
                Log.d((String)"ChartRenderer", (String)("viewport = " + (Object)((Object)viewport)));
            }
        });
    }

    @Override
    protected void renderDataSet(Canvas canvas) {
        this.barChartRenderer.renderDataSet(canvas);
        this.lineRenderer.renderDataSet(canvas);
        this.candlestickChartRenderer.renderDataSet(canvas);
    }

    @Override
    public void setHighlightColor(int highlightColor) {
        super.setHighlightColor(highlightColor);
        this.lineRenderer.setHighlightColor(highlightColor);
        this.barChartRenderer.setHighlightColor(highlightColor);
        this.candlestickChartRenderer.setHighlightColor(highlightColor);
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        if (this.lineRenderer.getDataSet() != null && !this.lineRenderer.getDataSet().isEmpty()) {
            this.lineRenderer.renderHighlighted(canvas, highlights);
        }
        if (this.barChartRenderer.getDataSet() != null && !this.barChartRenderer.getDataSet().isEmpty()) {
            this.barChartRenderer.renderHighlighted(canvas, highlights);
        }
        if (this.candlestickChartRenderer.getDataSet() != null && !this.candlestickChartRenderer.getDataSet().isEmpty()) {
            this.candlestickChartRenderer.renderHighlighted(canvas, highlights);
        }
    }

    public void addDataSet(AbstractDataSet dataSet) {
        this.combineData.add(dataSet);
        this.combineData.calcDataSetMinMax(this.mContentRect);
        if (dataSet instanceof LineDataSet) {
            this.lineRenderer.addDataSet((LineDataSet)dataSet);
        } else if (dataSet instanceof BarDataSet) {
            this.barChartRenderer.addDataSet((BarDataSet)dataSet);
        } else if (dataSet instanceof CandlestickDataSet) {
            this.candlestickChartRenderer.addDataSet((CandlestickDataSet)dataSet);
        }
    }

    public void removeDataSet(AbstractDataSet dataSet) {
        this.combineData.remove(dataSet);
        this.combineData.calcDataSetMinMax(this.mContentRect);
        if (dataSet instanceof LineDataSet) {
            this.lineRenderer.removeDataSet((LineDataSet)dataSet);
        } else if (dataSet instanceof BarDataSet) {
            this.barChartRenderer.removeDataSet((BarDataSet)dataSet);
        } else if (dataSet instanceof CandlestickDataSet) {
            this.candlestickChartRenderer.removeDataSet((CandlestickDataSet)dataSet);
        }
    }

    @Override
    public void clearDataSet() {
        this.combineData.clear();
        this.combineData.calcDataSetMinMax(this.mContentRect);
        this.lineRenderer.clearDataSet();
        this.barChartRenderer.clearDataSet();
        this.candlestickChartRenderer.clearDataSet();
    }

    protected List<AbstractDataSet> getDataSet() {
        return this.combineData.getDataSets();
    }

    public CombineData getChartData() {
        return this.combineData;
    }
}

