package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import android.util.Log;

import cn.jingzhuan.lib.chart.component.AxisY;
import java.util.ArrayList;
import java.util.List;

import cn.jingzhuan.lib.chart.Viewport;

/**
 * Created by Donglua on 17/8/2.
 */
public class CombineData extends ChartData<AbstractDataSet> {

    private BarData barData;
    private LineData lineData;
    private CandlestickData candlestickData;

    public CombineData() {
        barData = new BarData();
        lineData = new LineData();
        candlestickData = new CandlestickData();
    }

    public List<BarDataSet> getBarData() {
        return barData.getDataSets();
    }

    public List<LineDataSet> getLineData() {
        return lineData.getDataSets();
    }

    public List<CandlestickDataSet> getCandlestickData() {
        return candlestickData.getDataSets();
    }

    public void addDataSet(BarDataSet dataSet) {
        barData.add(dataSet);
//        barData.calcMinMax();
    }

    public void addDataSet(LineDataSet dataSet) {
        lineData.add(dataSet);
//        lineData.calcMinMax();
    }

    public void addDataSet(CandlestickDataSet dataSet) {
        candlestickData.add(dataSet);
//        candlestickData.calcMinMax();
    }

    public void calcDataSetMinMax(Viewport viewport, Rect content) {
        leftMin = Float.MAX_VALUE;
        leftMax = -Float.MAX_VALUE;
        candlestickData.calcCandlestickDataSetMinMax(viewport, content);
        leftMin = candlestickData.leftMin;
        leftMax = candlestickData.leftMax;
        rightMin = candlestickData.rightMin;
        rightMax = candlestickData.rightMax;
        calcLineDataSetMinMax(viewport, content);
        leftMin = Math.min(lineData.leftMin, candlestickData.leftMin);
        leftMax = Math.max(lineData.leftMax, candlestickData.leftMax);
        rightMin = Math.min(lineData.rightMin, candlestickData.rightMin);
        rightMax = Math.max(lineData.rightMax, candlestickData.rightMax);
    }

    public void calcDataSetMinMax(Rect content) {
        calcDataSetMinMax(new Viewport(), content);
        calcMinMax();
    }

    @Override
    public boolean add(AbstractDataSet e) {
        if (e instanceof CandlestickDataSet) {
            return getCandlestickData().add((CandlestickDataSet) e);
        }
        return super.add(e);
    }


    public void calcLineDataSetMinMax(Viewport viewport, Rect content) {
        lineData.leftMax = -Float.MAX_VALUE;
        lineData.leftMin = Float.MAX_VALUE;
        for (LineDataSet lineDataSet : getLineData()) {
            lineDataSet.onViewportChange(viewport);
            if (lineDataSet.getAxisDependency() == AxisY.DEPENDENCY_BOTH || lineDataSet.getAxisDependency() == AxisY.DEPENDENCY_LEFT) {
                lineData.leftMax = Math.max(lineData.leftMax, lineDataSet.getViewportYMax());
                lineData.leftMin = Math.min(lineData.leftMin, lineDataSet.getViewportYMin());
            }
            if (lineDataSet.getAxisDependency() == AxisY.DEPENDENCY_BOTH || lineDataSet.getAxisDependency() == AxisY.DEPENDENCY_RIGHT) {
                lineData.rightMax = Math.max(lineData.rightMax, lineDataSet.getViewportYMax());
                lineData.rightMin = Math.min(lineData.rightMin, lineDataSet.getViewportYMin());
            }
        }
    }

    public void calcBarDataSetMinMax(Viewport viewport, Rect content) {
        for (BarDataSet candlestickDataSet : getBarData()) {
//            candlestickDataSet.o;
        }
    }

    @Override
    public void calcMinMax() {
        if (leftAxis != null) {
            leftAxis.setYMin(leftMin);
            leftAxis.setYMax(leftMax);
        }
        if (rightAxis != null) {
            rightAxis.setYMin(rightMin);
            rightAxis.setYMax(rightMax);
        }
    }


}
