package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import android.util.Log;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.AxisY;
import java.util.List;

/**
 * Created by donglua on 8/29/17.
 */

public class CandlestickData extends ChartData<CandlestickDataSet> {

  public void calcCandlestickDataSetMinMax(Viewport viewport, Rect content) {

    leftMax = -Float.MAX_VALUE;
    leftMin = Float.MAX_VALUE;
    rightMax = -Float.MAX_VALUE;
    rightMin = Float.MAX_VALUE;

    if (getDataSets().isEmpty()) return;

    for (CandlestickDataSet candlestickDataSet : getDataSets()) {
      for (CandlestickValue e : getVisiblePoints(candlestickDataSet, viewport)) {
        if (candlestickDataSet.getAxisDependency() == AxisY.DEPENDENCY_BOTH
            || candlestickDataSet.getAxisDependency() == AxisY.DEPENDENCY_LEFT) {
          if (e.getLow() < leftMin) leftMin = e.getLow();
          if (e.getHigh() > leftMax) leftMax = e.getHigh();
        }
        if (candlestickDataSet.getAxisDependency() == AxisY.DEPENDENCY_BOTH
            || candlestickDataSet.getAxisDependency() == AxisY.DEPENDENCY_RIGHT) {
          if (e.getLow() < rightMin) rightMin = e.getLow();
          if (e.getHigh() > rightMax) rightMax = e.getHigh();
        }
      }
    }
  }



  protected List<CandlestickValue> getVisiblePoints(CandlestickDataSet candlestickDataSet, Viewport viewport) {
    int from = (int) (viewport.left * candlestickDataSet.getValues().size());
    int to   = (int) (viewport.right * candlestickDataSet.getValues().size());

    return candlestickDataSet.getValues().subList(from, to);
  }


}
