/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.component.AxisY;
import cn.jingzhuan.lib.chart.data.IDataSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChartData<T extends IDataSet> {
    private List<T> chartData;
    private float leftMin = Float.MAX_VALUE;
    private float leftMax = -3.4028235E38f;
    private float rightMin = Float.MAX_VALUE;
    private float rightMax = -3.4028235E38f;
    private int entryCount = 0;
    private AxisY leftAxis;
    private AxisY rightAxis;

    public ChartData(Chart chart) {
        this.chartData = new CopyOnWriteArrayList<T>();
        this.leftAxis = chart.getAxisLeft();
        this.rightAxis = chart.getAxisRight();
    }

    public List<T> getDataSets() {
        if (this.chartData == null) {
            this.chartData = new CopyOnWriteArrayList<T>();
        }
        return this.chartData;
    }

    public boolean add(T e) {
        if (e == null) {
            return false;
        }
        return this.getDataSets().add(e);
    }

    public boolean remove(T e) {
        return e != null && this.getDataSets().remove(e);
    }

    public void clear() {
        this.getDataSets().clear();
    }

    public void calcMinMax() {
        this.leftMin = Float.MAX_VALUE;
        this.leftMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
        for (IDataSet t : this.getDataSets()) {
            if (t.getAxisDependency() == 25 || t.getAxisDependency() == 23) {
                if (t.getViewportYMax() > this.leftMax) {
                    this.leftMax = t.getViewportYMax();
                }
                if (t.getViewportYMin() < this.leftMin) {
                    this.leftMin = t.getViewportYMin();
                }
            }
            if (t.getAxisDependency() == 25 || t.getAxisDependency() == 24) {
                if (t.getViewportYMax() > this.rightMax) {
                    this.rightMax = t.getViewportYMax();
                }
                if (t.getViewportYMin() < this.rightMin) {
                    this.rightMin = t.getViewportYMin();
                }
            }
            if (t.getEntryCount() <= this.entryCount) continue;
            this.entryCount = t.getEntryCount();
        }
        this.leftAxis.setYMin(this.leftMin);
        this.leftAxis.setYMax(this.leftMax);
        this.rightAxis.setYMin(this.rightMin);
        this.rightAxis.setYMax(this.rightMax);
    }

    public float getLeftMin() {
        return this.leftMin;
    }

    public float getLeftMax() {
        return this.leftMax;
    }

    public int getEntryCount() {
        return this.entryCount;
    }
}

