/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.OverScroller;
import cn.jingzhuan.lib.chart.OverScrollerCompat;
import cn.jingzhuan.lib.chart.R;
import cn.jingzhuan.lib.chart.ScaleGestureDetectorCompat;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.Zoomer;
import cn.jingzhuan.lib.chart.component.Axis;
import cn.jingzhuan.lib.chart.component.AxisX;
import cn.jingzhuan.lib.chart.component.AxisY;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.utils.ForceAlign;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Chart
extends View {
    protected AxisY mAxisLeft = new AxisY(112);
    protected AxisY mAxisRight = new AxisY(114);
    protected AxisX mAxisTop = new AxisX(101);
    protected AxisX mAxisBottom = new AxisX(102);
    private ScaleGestureDetector mScaleGestureDetector;
    private GestureDetectorCompat mGestureDetector;
    private OverScroller mScroller;
    private Zoomer mZoomer;
    private PointF mZoomFocalPoint = new PointF();
    private RectF mScrollerStartViewport = new RectF();
    private OnViewportChangeListener mOnViewportChangeListener;
    private boolean mScaleXEnable = true;
    private boolean mDraggingToMoveEnable = true;
    private boolean mDoubleTapToZoom = false;
    protected List<OnTouchPointChangeListener> mTouchPointChangeListeners;
    private Viewport mCurrentViewport = new Viewport();
    private Rect mContentRect = new Rect();
    private static final float ZOOM_AMOUNT = 0.25f;
    private Point mSurfaceSizeBuffer = new Point();
    private EdgeEffectCompat mEdgeEffectTop;
    private EdgeEffectCompat mEdgeEffectBottom;
    private EdgeEffectCompat mEdgeEffectLeft;
    private EdgeEffectCompat mEdgeEffectRight;
    private boolean mEdgeEffectTopActive;
    private boolean mEdgeEffectBottomActive;
    private boolean mEdgeEffectLeftActive;
    private boolean mEdgeEffectRightActive;
    private final ScaleGestureDetector.OnScaleGestureListener mScaleGestureListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){
        private PointF viewportFocus = new PointF();
        private float lastSpanX;

        public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
            this.lastSpanX = ScaleGestureDetectorCompat.getCurrentSpanX(scaleGestureDetector);
            return true;
        }

        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            if (!Chart.this.mScaleXEnable) {
                return false;
            }
            float spanX = ScaleGestureDetectorCompat.getCurrentSpanX(scaleGestureDetector);
            float spanY = ScaleGestureDetectorCompat.getCurrentSpanY(scaleGestureDetector);
            float newWidth = this.lastSpanX / spanX * Chart.this.mCurrentViewport.width();
            if (newWidth < Chart.this.mCurrentViewport.width() && (double)Chart.this.mCurrentViewport.width() < 0.1) {
                return true;
            }
            float focusX = scaleGestureDetector.getFocusX();
            float focusY = scaleGestureDetector.getFocusY();
            Chart.this.hitTest(focusX, focusY, this.viewportFocus);
            ((Chart)Chart.this).mCurrentViewport.left = this.viewportFocus.x - newWidth * (focusX - (float)((Chart)Chart.this).mContentRect.left) / (float)Chart.this.mContentRect.width();
            ((Chart)Chart.this).mCurrentViewport.right = ((Chart)Chart.this).mCurrentViewport.left + newWidth;
            Chart.this.mCurrentViewport.constrainViewport();
            if (Chart.this.mScaleXEnable) {
                Chart.this.notifyViewportChange();
            }
            this.lastSpanX = spanX;
            return true;
        }
    };
    private final GestureDetector.SimpleOnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            Chart.this.releaseEdgeEffects();
            Chart.this.mScrollerStartViewport.set((RectF)Chart.this.mCurrentViewport);
            Chart.this.mScroller.forceFinished(true);
            ViewCompat.postInvalidateOnAnimation((View)Chart.this);
            return true;
        }

        public void onShowPress(MotionEvent e) {
            super.onShowPress(e);
            Chart.this.onTouchPoint(e.getX(), e.getY());
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            Chart.this.cleanHighlight();
            return super.onSingleTapConfirmed(e);
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (Chart.this.mDoubleTapToZoom) {
                Chart.this.mZoomer.forceFinished(true);
                if (Chart.this.hitTest(e.getX(), e.getY(), Chart.this.mZoomFocalPoint)) {
                    Chart.this.mZoomer.startZoom(0.25f);
                }
                ViewCompat.postInvalidateOnAnimation((View)Chart.this);
            }
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!Chart.this.isDraggingToMoveEnable()) {
                Chart.this.onTouchPoint(e2.getX(), e2.getY());
                return super.onScroll(e1, e2, distanceX, distanceY);
            }
            float viewportOffsetX = distanceX * Chart.this.mCurrentViewport.width() / (float)Chart.this.mContentRect.width();
            float viewportOffsetY = -distanceY * Chart.this.mCurrentViewport.height() / (float)Chart.this.mContentRect.height();
            Chart.this.computeScrollSurfaceSize(Chart.this.mSurfaceSizeBuffer);
            int scrolledX = (int)((float)((Chart)Chart.this).mSurfaceSizeBuffer.x * (((Chart)Chart.this).mCurrentViewport.left + viewportOffsetX - 0.0f) / 1.0f);
            int scrolledY = (int)((float)((Chart)Chart.this).mSurfaceSizeBuffer.y * (1.0f - ((Chart)Chart.this).mCurrentViewport.bottom - viewportOffsetY) / 2.0f);
            boolean canScrollX = ((Chart)Chart.this).mCurrentViewport.left > 0.0f || ((Chart)Chart.this).mCurrentViewport.right < 1.0f;
            boolean canScrollY = ((Chart)Chart.this).mCurrentViewport.top > -1.0f || ((Chart)Chart.this).mCurrentViewport.bottom < 1.0f;
            Chart.this.setViewportBottomLeft(((Chart)Chart.this).mCurrentViewport.left + viewportOffsetX, ((Chart)Chart.this).mCurrentViewport.bottom + viewportOffsetY);
            if (canScrollX && scrolledX < 0) {
                Chart.this.mEdgeEffectLeft.onPull((float)scrolledX / (float)Chart.this.mContentRect.width());
                Chart.this.mEdgeEffectLeftActive = true;
            }
            if (canScrollY && scrolledY < 0) {
                Chart.this.mEdgeEffectTop.onPull((float)scrolledY / (float)Chart.this.mContentRect.height());
                Chart.this.mEdgeEffectTopActive = true;
            }
            if (canScrollX && scrolledX > ((Chart)Chart.this).mSurfaceSizeBuffer.x - Chart.this.mContentRect.width()) {
                Chart.this.mEdgeEffectRight.onPull((float)(scrolledX - ((Chart)Chart.this).mSurfaceSizeBuffer.x + Chart.this.mContentRect.width()) / (float)Chart.this.mContentRect.width());
                Chart.this.mEdgeEffectRightActive = true;
            }
            if (canScrollY && scrolledY > ((Chart)Chart.this).mSurfaceSizeBuffer.y - Chart.this.mContentRect.height()) {
                Chart.this.mEdgeEffectBottom.onPull((float)(scrolledY - ((Chart)Chart.this).mSurfaceSizeBuffer.y + Chart.this.mContentRect.height()) / (float)Chart.this.mContentRect.height());
                Chart.this.mEdgeEffectBottomActive = true;
            }
            Chart.this.onTouchPoint(e2.getX(), e2.getY());
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!Chart.this.isDraggingToMoveEnable()) {
                return super.onFling(e1, e2, velocityX, velocityY);
            }
            Chart.this.fling((int)(-velocityX), (int)(-velocityY));
            Chart.this.onTouchPoint(e2.getX(), e2.getY());
            return true;
        }
    };

    public Chart(Context context) {
        this(context, null, 0);
    }

    public Chart(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Chart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public Chart(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Chart, defStyleAttr, defStyleAttr);
        this.mTouchPointChangeListeners = new CopyOnWriteArrayList<OnTouchPointChangeListener>();
        this.mAxisTop.setGridLineEnable(false);
        this.mAxisTop.setLabelEnable(false);
        try {
            ArrayList<Axis> axisList = new ArrayList<Axis>(4);
            axisList.add(this.mAxisLeft);
            axisList.add(this.mAxisRight);
            axisList.add(this.mAxisTop);
            axisList.add(this.mAxisBottom);
            float labelTextSize = a.getDimension(R.styleable.Chart_labelTextSize, 28.0f);
            float labelSeparation = a.getDimensionPixelSize(R.styleable.Chart_labelSeparation, 10);
            float gridThickness = a.getDimension(R.styleable.Chart_gridThickness, 2.0f);
            float axisThickness = a.getDimension(R.styleable.Chart_axisThickness, 2.0f);
            int gridColor = a.getColor(R.styleable.Chart_gridColor, -7829368);
            int axisColor = a.getColor(R.styleable.Chart_axisColor, -7829368);
            int labelTextColor = a.getColor(R.styleable.Chart_labelTextColor, -7829368);
            for (Axis axis : axisList) {
                axis.setLabelTextSize(labelTextSize);
                axis.setLabelTextColor(labelTextColor);
                axis.setLabelSeparation(labelSeparation);
                axis.setGridColor(gridColor);
                axis.setGridThickness(gridThickness);
                axis.setAxisColor(axisColor);
                axis.setAxisThickness(axisThickness);
            }
        }
        finally {
            a.recycle();
        }
        this.initChart();
        this.setupInteractions(context);
        this.setupEdgeEffect(context);
    }

    public abstract void initChart();

    public abstract void highlightValue(Highlight var1);

    public abstract void cleanHighlight();

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mContentRect.set(this.getPaddingLeft() + this.mAxisLeft.getMaxLabelWidth() + (this.mAxisLeft.isInside() ? 0 : this.mAxisLeft.getLabelSeparation()), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom() - this.mAxisBottom.getLabelHeight() - this.mAxisBottom.getLabelSeparation());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minChartSize = this.getResources().getDimensionPixelSize(R.dimen.jz_chart_min_size);
        this.setMeasuredDimension(Math.max(this.getSuggestedMinimumWidth(), Chart.resolveSize((int)(minChartSize + this.getPaddingLeft() + (this.mAxisLeft.isInside() ? 0 : this.mAxisLeft.getMaxLabelWidth()) + (this.mAxisLeft.isInside() ? 0 : this.mAxisLeft.getLabelSeparation()) + this.getPaddingRight()), (int)widthMeasureSpec)), Math.max(this.getSuggestedMinimumHeight(), Chart.resolveSize((int)(minChartSize + this.getPaddingTop() + (this.mAxisBottom.isInside() ? 0 : this.mAxisBottom.getLabelHeight()) + (this.mAxisBottom.isInside() ? 0 : this.mAxisBottom.getLabelSeparation()) + this.getPaddingBottom()), (int)heightMeasureSpec)));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawAxis(canvas);
        int clipRestoreCount = canvas.save();
        canvas.clipRect(this.mContentRect);
        this.render(canvas);
        this.drawEdgeEffectsUnclipped(canvas);
        canvas.restoreToCount(clipRestoreCount);
        this.drawLabels(canvas);
    }

    protected abstract void drawAxis(Canvas var1);

    protected abstract void drawLabels(Canvas var1);

    protected abstract void render(Canvas var1);

    public Viewport getCurrentViewport() {
        return this.mCurrentViewport;
    }

    public Rect getContentRect() {
        return this.mContentRect;
    }

    private void setupInteractions(Context context) {
        this.mScaleGestureDetector = new ScaleGestureDetector(context, this.mScaleGestureListener);
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this.mGestureListener);
        this.mScroller = new OverScroller(context);
        this.mZoomer = new Zoomer(context);
    }

    private boolean hitTest(float x, float y, PointF dest) {
        if (!this.mContentRect.contains((int)x, (int)y)) {
            return false;
        }
        dest.set(this.mCurrentViewport.left + this.mCurrentViewport.width() * (x - (float)this.mContentRect.left) / (float)this.mContentRect.width(), this.mCurrentViewport.top + this.mCurrentViewport.height() * (y - (float)this.mContentRect.bottom) / (float)(-this.mContentRect.height()));
        return true;
    }

    protected abstract void onTouchPoint(float var1, float var2);

    private void notifyViewportChange() {
        if (this.mOnViewportChangeListener != null) {
            this.mOnViewportChangeListener.onViewportChange(this.mCurrentViewport);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private void fling(int velocityX, int velocityY) {
        this.releaseEdgeEffects();
        this.computeScrollSurfaceSize(this.mSurfaceSizeBuffer);
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        int startX = (int)((float)this.mSurfaceSizeBuffer.x * (this.mScrollerStartViewport.left - 0.0f) / 1.0f);
        int startY = (int)((float)this.mSurfaceSizeBuffer.y * (1.0f - this.mScrollerStartViewport.bottom) / 2.0f);
        this.mScroller.forceFinished(true);
        this.mScroller.fling(startX, startY, velocityX, velocityY, 0, this.mSurfaceSizeBuffer.x - this.mContentRect.width(), 0, this.mSurfaceSizeBuffer.y - this.mContentRect.height(), this.mContentRect.width() / 2, this.mContentRect.height() / 2);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private void computeScrollSurfaceSize(Point out) {
        out.set((int)((float)this.mContentRect.width() * 1.0f / this.mCurrentViewport.width()), (int)((float)this.mContentRect.height() * 2.0f / this.mCurrentViewport.height()));
    }

    public void zoomIn() {
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        this.mZoomer.forceFinished(true);
        this.mZoomer.startZoom(0.25f);
        this.mZoomFocalPoint.set((this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f, (this.mCurrentViewport.bottom + this.mCurrentViewport.top) / 2.0f);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void zoomOut() {
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        this.mZoomer.forceFinished(true);
        this.mZoomer.startZoom(-0.25f);
        this.mZoomFocalPoint.set((this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f, (this.mCurrentViewport.bottom + this.mCurrentViewport.top) / 2.0f);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void zoomOut(@ForceAlign.XForce int forceAlignX) {
        float forceX;
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        this.mZoomer.forceFinished(true);
        this.mZoomer.startZoom(-0.25f);
        switch (forceAlignX) {
            case 21: {
                forceX = this.mCurrentViewport.left;
                break;
            }
            case 22: {
                forceX = this.mCurrentViewport.right;
                break;
            }
            case 23: {
                forceX = (this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f;
                break;
            }
            default: {
                forceX = (this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f;
            }
        }
        this.mZoomFocalPoint.set(forceX, (this.mCurrentViewport.bottom + this.mCurrentViewport.top) / 2.0f);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void zoomIn(@ForceAlign.XForce int forceAlignX) {
        float forceX;
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        this.mZoomer.forceFinished(true);
        this.mZoomer.startZoom(0.25f);
        switch (forceAlignX) {
            case 21: {
                forceX = this.mCurrentViewport.left;
                break;
            }
            case 22: {
                forceX = this.mCurrentViewport.right;
                break;
            }
            case 23: {
                forceX = (this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f;
                break;
            }
            default: {
                forceX = (this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f;
            }
        }
        this.mZoomFocalPoint.set(forceX, (this.mCurrentViewport.bottom + this.mCurrentViewport.top) / 2.0f);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void computeScroll() {
        super.computeScroll();
        boolean needsInvalidate = false;
        if (this.mScroller.computeScrollOffset()) {
            boolean canScrollY;
            this.computeScrollSurfaceSize(this.mSurfaceSizeBuffer);
            int currX = this.mScroller.getCurrX();
            int currY = this.mScroller.getCurrY();
            boolean canScrollX = this.mCurrentViewport.left > 0.0f || this.mCurrentViewport.right < 1.0f;
            boolean bl = canScrollY = this.mCurrentViewport.top > -1.0f || this.mCurrentViewport.bottom < 1.0f;
            if (canScrollX && currX < 0 && this.mEdgeEffectLeft.isFinished() && !this.mEdgeEffectLeftActive) {
                this.mEdgeEffectLeft.onAbsorb((int)OverScrollerCompat.getCurrVelocity(this.mScroller));
                this.mEdgeEffectLeftActive = true;
                needsInvalidate = true;
            } else if (canScrollX && currX > this.mSurfaceSizeBuffer.x - this.mContentRect.width() && this.mEdgeEffectRight.isFinished() && !this.mEdgeEffectRightActive) {
                this.mEdgeEffectRight.onAbsorb((int)OverScrollerCompat.getCurrVelocity(this.mScroller));
                this.mEdgeEffectRightActive = true;
                needsInvalidate = true;
            }
            if (canScrollY && currY < 0 && this.mEdgeEffectTop.isFinished() && !this.mEdgeEffectTopActive) {
                this.mEdgeEffectTop.onAbsorb((int)OverScrollerCompat.getCurrVelocity(this.mScroller));
                this.mEdgeEffectTopActive = true;
                needsInvalidate = true;
            } else if (canScrollY && currY > this.mSurfaceSizeBuffer.y - this.mContentRect.height() && this.mEdgeEffectBottom.isFinished() && !this.mEdgeEffectBottomActive) {
                this.mEdgeEffectBottom.onAbsorb((int)OverScrollerCompat.getCurrVelocity(this.mScroller));
                this.mEdgeEffectBottomActive = true;
                needsInvalidate = true;
            }
            float currXRange = 0.0f + 1.0f * (float)currX / (float)this.mSurfaceSizeBuffer.x;
            float currYRange = 1.0f - 2.0f * (float)currY / (float)this.mSurfaceSizeBuffer.y;
            this.setViewportBottomLeft(currXRange, currYRange);
        }
        if (this.mZoomer.computeZoom()) {
            float newWidth = (1.0f - this.mZoomer.getCurrZoom()) * this.mScrollerStartViewport.width();
            float newHeight = (1.0f - this.mZoomer.getCurrZoom()) * this.mScrollerStartViewport.height();
            float pointWithinViewportX = (this.mZoomFocalPoint.x - this.mScrollerStartViewport.left) / this.mScrollerStartViewport.width();
            float pointWithinViewportY = (this.mZoomFocalPoint.y - this.mScrollerStartViewport.top) / this.mScrollerStartViewport.height();
            this.mCurrentViewport.set(this.mZoomFocalPoint.x - newWidth * pointWithinViewportX, this.mZoomFocalPoint.y - newHeight * pointWithinViewportY, this.mZoomFocalPoint.x + newWidth * (1.0f - pointWithinViewportX), this.mZoomFocalPoint.y + newHeight * (1.0f - pointWithinViewportY));
            this.mCurrentViewport.constrainViewport();
            needsInvalidate = true;
        }
        if (needsInvalidate) {
            this.notifyViewportChange();
        }
    }

    private void setViewportBottomLeft(float x, float y) {
        float curWidth = this.mCurrentViewport.width();
        float curHeight = this.mCurrentViewport.height();
        x = Math.max(0.0f, Math.min(x, 1.0f - curWidth));
        y = Math.max(-1.0f + curHeight, Math.min(y, 1.0f));
        this.mCurrentViewport.set(x, y - curHeight, x + curWidth, y);
        this.notifyViewportChange();
    }

    public void setCurrentViewport(RectF viewport) {
        this.mCurrentViewport = new Viewport(viewport);
        this.mCurrentViewport.constrainViewport();
        this.notifyViewportChange();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean retVal = event.getPointerCount() > 1 && this.mScaleGestureDetector.onTouchEvent(event);
        retVal = this.mGestureDetector.onTouchEvent(event) || retVal;
        return retVal || super.onTouchEvent(event);
    }

    protected void setupEdgeEffect(Context context) {
        this.mEdgeEffectLeft = new EdgeEffectCompat(context);
        this.mEdgeEffectTop = new EdgeEffectCompat(context);
        this.mEdgeEffectRight = new EdgeEffectCompat(context);
        this.mEdgeEffectBottom = new EdgeEffectCompat(context);
    }

    private void drawEdgeEffectsUnclipped(Canvas canvas) {
        int restoreCount;
        boolean needsInvalidate = false;
        if (!this.mEdgeEffectTop.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate((float)this.mContentRect.left, (float)this.mContentRect.top);
            this.mEdgeEffectTop.setSize(this.mContentRect.width(), this.mContentRect.height());
            if (this.mEdgeEffectTop.draw(canvas)) {
                needsInvalidate = true;
            }
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeEffectBottom.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate((float)(2 * this.mContentRect.left - this.mContentRect.right), (float)this.mContentRect.bottom);
            canvas.rotate(180.0f, (float)this.mContentRect.width(), 0.0f);
            this.mEdgeEffectBottom.setSize(this.mContentRect.width(), this.mContentRect.height());
            if (this.mEdgeEffectBottom.draw(canvas)) {
                needsInvalidate = true;
            }
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeEffectLeft.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate((float)this.mContentRect.left, (float)this.mContentRect.bottom);
            canvas.rotate(-90.0f, 0.0f, 0.0f);
            this.mEdgeEffectLeft.setSize(this.mContentRect.height(), this.mContentRect.width());
            if (this.mEdgeEffectLeft.draw(canvas)) {
                needsInvalidate = true;
            }
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeEffectRight.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate((float)this.mContentRect.right, (float)this.mContentRect.top);
            canvas.rotate(90.0f, 0.0f, 0.0f);
            this.mEdgeEffectRight.setSize(this.mContentRect.height(), this.mContentRect.width());
            if (this.mEdgeEffectRight.draw(canvas)) {
                needsInvalidate = true;
            }
            canvas.restoreToCount(restoreCount);
        }
        if (needsInvalidate) {
            this.notifyViewportChange();
        }
    }

    private void releaseEdgeEffects() {
        this.mEdgeEffectBottomActive = false;
        this.mEdgeEffectRightActive = false;
        this.mEdgeEffectTopActive = false;
        this.mEdgeEffectLeftActive = false;
        this.mEdgeEffectLeft.onRelease();
        this.mEdgeEffectTop.onRelease();
        this.mEdgeEffectRight.onRelease();
        this.mEdgeEffectBottom.onRelease();
    }

    public AxisY getAxisLeft() {
        return this.mAxisLeft;
    }

    public AxisY getAxisRight() {
        return this.mAxisRight;
    }

    public AxisX getAxisTop() {
        return this.mAxisTop;
    }

    public AxisX getAxisBottom() {
        return this.mAxisBottom;
    }

    public void setOnViewportChangeListener(OnViewportChangeListener onViewportChangeListener) {
        this.mOnViewportChangeListener = onViewportChangeListener;
    }

    public boolean isScaleXEnable() {
        return this.mScaleXEnable;
    }

    public void setScaleXEnable(boolean scaleXEnable) {
        this.mScaleXEnable = scaleXEnable;
    }

    public void setDoubleTapToZoom(boolean doubleTapToZoom) {
        this.mDoubleTapToZoom = doubleTapToZoom;
    }

    public void addOnTouchPointChangeListener(OnTouchPointChangeListener touchPointChangeListener) {
        this.mTouchPointChangeListeners.add(touchPointChangeListener);
    }

    public void removeOnTouchPointChangeListener(OnTouchPointChangeListener touchPointChangeListener) {
        this.mTouchPointChangeListeners.remove(touchPointChangeListener);
    }

    public void setDraggingToMoveEnable(boolean draggingToMoveEnable) {
        this.mDraggingToMoveEnable = draggingToMoveEnable;
    }

    public boolean isDraggingToMoveEnable() {
        return this.mDraggingToMoveEnable;
    }

    public static interface OnTouchPointChangeListener {
        public void touch(float var1, float var2);
    }
}

