/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.widget.EdgeEffect;
import android.widget.OverScroller;
import cn.jingzhuan.lib.chart.R;
import cn.jingzhuan.lib.chart.Zoomer;
import cn.jingzhuan.lib.chart.base.BitmapCachedChart;
import cn.jingzhuan.lib.chart.component.Axis;
import cn.jingzhuan.lib.chart.component.AxisX;
import cn.jingzhuan.lib.chart.component.AxisY;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.event.OnEntryClickListener;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Chart
extends BitmapCachedChart {
    protected AxisY mAxisLeft = new AxisY(112);
    protected AxisY mAxisRight = new AxisY(114);
    protected AxisX mAxisTop = new AxisX(101);
    protected AxisX mAxisBottom = new AxisX(102);
    private ScaleGestureDetector mScaleGestureDetector;
    private GestureDetector mGestureDetector;
    private OverScroller mScroller;
    private Zoomer mZoomer;
    private PointF mZoomFocalPoint = new PointF();
    private RectF mScrollerStartViewport = new RectF();
    private boolean mScaleXEnable = true;
    private boolean mDraggingToMoveEnable = true;
    private boolean mDoubleTapToZoom = false;
    private boolean mScaleGestureEnable = true;
    private boolean mHighlightDisable = false;
    protected List<OnTouchPointChangeListener> mTouchPointChangeListeners;
    private List<OnViewportChangeListener> mOnViewportChangeListeners;
    protected OnViewportChangeListener mInternalViewportChangeListener;
    protected OnEntryClickListener onEntryClickListener;
    private static final float ZOOM_AMOUNT = 0.25f;
    private Point mSurfaceSizeBuffer = new Point();
    private EdgeEffect mEdgeEffectLeft;
    private EdgeEffect mEdgeEffectRight;
    private boolean mEdgeEffectLeftActive;
    private boolean mEdgeEffectRightActive;
    private final ScaleGestureDetector.OnScaleGestureListener mScaleGestureListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){
        private PointF viewportFocus = new PointF();
        private float lastSpanX;

        public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
            if (!Chart.this.mScaleGestureEnable) {
                return super.onScaleBegin(scaleGestureDetector);
            }
            this.lastSpanX = scaleGestureDetector.getCurrentSpanX();
            return true;
        }

        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            if (!Chart.this.mScaleXEnable) {
                return false;
            }
            if (!Chart.this.mScaleGestureEnable) {
                return super.onScale(scaleGestureDetector);
            }
            float spanX = scaleGestureDetector.getCurrentSpanX();
            float newWidth = this.lastSpanX / spanX * Chart.this.mCurrentViewport.width();
            if (newWidth < Chart.this.mCurrentViewport.width() && (double)Chart.this.mCurrentViewport.width() < 0.1) {
                return true;
            }
            float focusX = scaleGestureDetector.getFocusX();
            float focusY = scaleGestureDetector.getFocusY();
            Chart.this.hitTest(focusX, focusY, this.viewportFocus);
            Chart.this.mCurrentViewport.left = this.viewportFocus.x - newWidth * (focusX - (float)Chart.this.mContentRect.left) / (float)Chart.this.mContentRect.width();
            Chart.this.mCurrentViewport.right = Chart.this.mCurrentViewport.left + newWidth;
            Chart.this.mCurrentViewport.constrainViewport();
            Chart.this.triggerViewportChange();
            this.lastSpanX = spanX;
            return true;
        }
    };
    private final GestureDetector.SimpleOnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            Chart.this.releaseEdgeEffects();
            Chart.this.mScrollerStartViewport.set((RectF)Chart.this.mCurrentViewport);
            Chart.this.mScroller.forceFinished(true);
            Chart.this.postInvalidateOnAnimation();
            return true;
        }

        public void onLongPress(MotionEvent e) {
            Chart.this.mGestureDetector.onTouchEvent(e);
            Chart.this.mGestureDetector.setIsLongpressEnabled(false);
        }

        public void onShowPress(MotionEvent e) {
            super.onShowPress(e);
            Chart.this.onTouchPoint(e);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (Chart.this.onEntryClickListener != null) {
                int index = Chart.this.getEntryIndexByCoordinate(e.getX(), e.getY());
                if (index >= 0) {
                    Chart.this.onEntryClickListener.onEntryClick(Chart.this, index);
                    if (Chart.this.isHighlightDisable()) {
                        Chart.this.cleanHighlight();
                    } else {
                        Chart.this.highlightValue(new Highlight(e.getX(), e.getY(), index));
                    }
                } else {
                    Chart.this.cleanHighlight();
                    Chart.this.performClick();
                }
            } else {
                Chart.this.cleanHighlight();
                Chart.this.performClick();
            }
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (Chart.this.mDoubleTapToZoom) {
                Chart.this.mZoomer.forceFinished(true);
                if (Chart.this.hitTest(e.getX(), e.getY(), Chart.this.mZoomFocalPoint)) {
                    Chart.this.mZoomer.startZoom(0.25f);
                }
                Chart.this.postInvalidateOnAnimation();
            }
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!Chart.this.isDraggingToMoveEnable()) {
                Chart.this.onTouchPoint(e2);
                return super.onScroll(e1, e2, distanceX, distanceY);
            }
            float viewportOffsetX = distanceX * Chart.this.mCurrentViewport.width() / (float)Chart.this.mContentRect.width();
            Chart.this.computeScrollSurfaceSize(Chart.this.mSurfaceSizeBuffer);
            int scrolledX = (int)((float)((Chart)Chart.this).mSurfaceSizeBuffer.x * (Chart.this.mCurrentViewport.left + viewportOffsetX - 0.0f) / 1.0f);
            boolean canScrollX = Chart.this.mCurrentViewport.left > 0.0f || Chart.this.mCurrentViewport.right < 1.0f;
            Chart.this.setViewportBottomLeft(Chart.this.mCurrentViewport.left + viewportOffsetX);
            if (canScrollX && scrolledX < 0) {
                Chart.this.mEdgeEffectLeft.onPull((float)scrolledX / (float)Chart.this.mContentRect.width());
                Chart.this.mEdgeEffectLeftActive = true;
            }
            if (canScrollX && scrolledX > ((Chart)Chart.this).mSurfaceSizeBuffer.x - Chart.this.mContentRect.width()) {
                Chart.this.mEdgeEffectRight.onPull((float)(scrolledX - ((Chart)Chart.this).mSurfaceSizeBuffer.x + Chart.this.mContentRect.width()) / (float)Chart.this.mContentRect.width());
                Chart.this.mEdgeEffectRightActive = true;
            }
            Chart.this.onTouchPoint(e2);
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!Chart.this.isDraggingToMoveEnable()) {
                return super.onFling(e1, e2, velocityX, velocityY);
            }
            Chart.this.fling((int)(-velocityX));
            Chart.this.onTouchPoint(e2);
            return true;
        }
    };

    public Chart(Context context) {
        this(context, null, 0);
    }

    public Chart(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Chart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public Chart(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Chart, defStyleAttr, defStyleAttr);
        this.mTouchPointChangeListeners = Collections.synchronizedList(new ArrayList());
        this.mOnViewportChangeListeners = Collections.synchronizedList(new ArrayList());
        this.mAxisTop.setGridLineEnable(false);
        this.mAxisTop.setLabelEnable(false);
        try {
            ArrayList<Axis> axisList = new ArrayList<Axis>(4);
            axisList.add(this.mAxisLeft);
            axisList.add(this.mAxisRight);
            axisList.add(this.mAxisTop);
            axisList.add(this.mAxisBottom);
            float labelTextSize = a.getDimension(R.styleable.Chart_labelTextSize, 28.0f);
            float labelSeparation = a.getDimensionPixelSize(R.styleable.Chart_labelSeparation, 10);
            float gridThickness = a.getDimension(R.styleable.Chart_gridThickness, 2.0f);
            float axisThickness = a.getDimension(R.styleable.Chart_axisThickness, 2.0f);
            int gridColor = a.getColor(R.styleable.Chart_gridColor, -7829368);
            int axisColor = a.getColor(R.styleable.Chart_axisColor, -7829368);
            int labelTextColor = a.getColor(R.styleable.Chart_labelTextColor, -7829368);
            for (Axis axis : axisList) {
                axis.setLabelTextSize(labelTextSize);
                axis.setLabelTextColor(labelTextColor);
                axis.setLabelSeparation(labelSeparation);
                axis.setGridColor(gridColor);
                axis.setGridThickness(gridThickness);
                axis.setAxisColor(axisColor);
                axis.setAxisThickness(axisThickness);
            }
        }
        finally {
            a.recycle();
        }
        this.initChart();
        this.setupInteractions(context);
        this.setupEdgeEffect(context);
    }

    public abstract void initChart();

    public abstract void highlightValue(Highlight var1);

    public abstract void cleanHighlight();

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.getContentRect().set(this.getPaddingLeft() + (this.mAxisLeft.isInside() ? 0 : this.mAxisLeft.getLabelWidth()), this.getPaddingTop(), this.getWidth() - this.getPaddingRight() - (this.mAxisRight.isInside() ? 0 : this.mAxisRight.getLabelWidth()), this.getHeight() - this.getPaddingBottom() - this.mAxisBottom.getLabelHeight());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minChartSize = this.getResources().getDimensionPixelSize(R.dimen.jz_chart_min_size);
        this.setMeasuredDimension(Math.max(this.getSuggestedMinimumWidth(), Chart.resolveSize((int)(minChartSize + this.getPaddingLeft() + (this.mAxisLeft.isInside() ? 0 : this.mAxisLeft.getLabelWidth()) + this.getPaddingRight()), (int)widthMeasureSpec)), Math.max(this.getSuggestedMinimumHeight(), Chart.resolveSize((int)(minChartSize + this.getPaddingTop() + (this.mAxisBottom.isInside() ? 0 : this.mAxisBottom.getLabelHeight()) + this.getPaddingBottom()), (int)heightMeasureSpec)));
    }

    protected abstract int getEntryIndexByCoordinate(float var1, float var2);

    private void setupInteractions(Context context) {
        this.mScaleGestureDetector = new ScaleGestureDetector(context, this.mScaleGestureListener);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.mGestureListener);
        this.mScroller = new OverScroller(context);
        this.mZoomer = new Zoomer(context);
    }

    private boolean hitTest(float x, float y, PointF dest) {
        if (!this.mContentRect.contains((int)x, (int)y)) {
            return false;
        }
        dest.set(this.mCurrentViewport.left + this.mCurrentViewport.width() * (x - (float)this.mContentRect.left) / (float)this.mContentRect.width(), this.mCurrentViewport.top + this.mCurrentViewport.height() * (y - (float)this.mContentRect.bottom) / (float)(-this.mContentRect.height()));
        return true;
    }

    protected abstract void onTouchPoint(MotionEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerViewportChange() {
        if (this.mInternalViewportChangeListener != null) {
            this.mInternalViewportChangeListener.onViewportChange(this.mCurrentViewport);
        }
        if (this.mOnViewportChangeListeners != null && !this.mOnViewportChangeListeners.isEmpty()) {
            Chart chart = this;
            synchronized (chart) {
                for (OnViewportChangeListener mOnViewportChangeListener : this.mOnViewportChangeListeners) {
                    mOnViewportChangeListener.onViewportChange(this.mCurrentViewport);
                }
            }
        }
        this.postInvalidateOnAnimation();
    }

    private void fling(int velocityX) {
        this.releaseEdgeEffects();
        this.computeScrollSurfaceSize(this.mSurfaceSizeBuffer);
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        int startX = (int)((float)this.mSurfaceSizeBuffer.x * (this.mScrollerStartViewport.left - 0.0f) / 1.0f);
        this.mScroller.forceFinished(true);
        this.mScroller.fling(startX, 0, velocityX, 0, 0, this.mSurfaceSizeBuffer.x - this.mContentRect.width(), 0, this.mSurfaceSizeBuffer.y - this.mContentRect.height(), this.mContentRect.width() / 2, 0);
        this.postInvalidateOnAnimation();
    }

    private void computeScrollSurfaceSize(Point out) {
        out.set((int)((float)this.mContentRect.width() * 1.0f / this.mCurrentViewport.width()), (int)((float)this.mContentRect.height() * 2.0f / this.mCurrentViewport.height()));
    }

    public void zoomIn() {
        this.zoom(0.25f);
    }

    public void zoomOut() {
        this.zoom(-0.25f);
    }

    public void zoom(float scalingFactor) {
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        this.mZoomer.forceFinished(true);
        this.mZoomer.startZoom(scalingFactor);
        this.mZoomFocalPoint.set((this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f, (this.mCurrentViewport.bottom + this.mCurrentViewport.top) / 2.0f);
        this.triggerViewportChange();
    }

    public void zoomOut(int forceAlignX) {
        float forceX;
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        this.mZoomer.forceFinished(true);
        this.mZoomer.startZoom(-0.25f);
        switch (forceAlignX) {
            case 21: {
                forceX = this.mCurrentViewport.left;
                break;
            }
            case 22: {
                forceX = this.mCurrentViewport.right;
                break;
            }
            case 23: {
                forceX = (this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f;
                break;
            }
            default: {
                forceX = (this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f;
            }
        }
        this.mZoomFocalPoint.set(forceX, (this.mCurrentViewport.bottom + this.mCurrentViewport.top) / 2.0f);
        this.postInvalidateOnAnimation();
    }

    public void zoomIn(int forceAlignX) {
        float forceX;
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        this.mZoomer.forceFinished(true);
        this.mZoomer.startZoom(0.25f);
        switch (forceAlignX) {
            case 21: {
                forceX = this.mCurrentViewport.left;
                break;
            }
            case 22: {
                forceX = this.mCurrentViewport.right;
                break;
            }
            case 23: {
                forceX = (this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f;
                break;
            }
            default: {
                forceX = (this.mCurrentViewport.right + this.mCurrentViewport.left) / 2.0f;
            }
        }
        this.mZoomFocalPoint.set(forceX, (this.mCurrentViewport.bottom + this.mCurrentViewport.top) / 2.0f);
        this.triggerViewportChange();
    }

    public void computeScroll() {
        super.computeScroll();
        boolean needsInvalidate = false;
        if (this.mScroller.computeScrollOffset()) {
            boolean canScrollX;
            this.computeScrollSurfaceSize(this.mSurfaceSizeBuffer);
            int currX = this.mScroller.getCurrX();
            boolean bl = canScrollX = this.mCurrentViewport.left > 0.0f || this.mCurrentViewport.right < 1.0f;
            if (canScrollX && currX < 0 && this.mEdgeEffectLeft.isFinished() && !this.mEdgeEffectLeftActive) {
                this.mEdgeEffectLeft.onAbsorb((int)this.mScroller.getCurrVelocity());
                this.mEdgeEffectLeftActive = true;
                needsInvalidate = true;
            } else if (canScrollX && currX > this.mSurfaceSizeBuffer.x - this.mContentRect.width() && this.mEdgeEffectRight.isFinished() && !this.mEdgeEffectRightActive) {
                this.mEdgeEffectRight.onAbsorb((int)this.mScroller.getCurrVelocity());
                this.mEdgeEffectRightActive = true;
                needsInvalidate = true;
            }
            float currXRange = 0.0f + 1.0f * (float)currX / (float)this.mSurfaceSizeBuffer.x;
            this.setViewportBottomLeft(currXRange);
        }
        if (this.mZoomer.computeZoom()) {
            float newWidth = (1.0f - this.mZoomer.getCurrZoom()) * this.mScrollerStartViewport.width();
            float newHeight = (1.0f - this.mZoomer.getCurrZoom()) * this.mScrollerStartViewport.height();
            float pointWithinViewportX = (this.mZoomFocalPoint.x - this.mScrollerStartViewport.left) / this.mScrollerStartViewport.width();
            float pointWithinViewportY = (this.mZoomFocalPoint.y - this.mScrollerStartViewport.top) / this.mScrollerStartViewport.height();
            this.mCurrentViewport.set(this.mZoomFocalPoint.x - newWidth * pointWithinViewportX, this.mZoomFocalPoint.y - newHeight * pointWithinViewportY, this.mZoomFocalPoint.x + newWidth * (1.0f - pointWithinViewportX), this.mZoomFocalPoint.y + newHeight * (1.0f - pointWithinViewportY));
            this.mCurrentViewport.constrainViewport();
            needsInvalidate = true;
        }
        if (needsInvalidate) {
            this.triggerViewportChange();
        }
    }

    private void setViewportBottomLeft(float x) {
        float curWidth = this.mCurrentViewport.width();
        this.mCurrentViewport.left = x = Math.max(0.0f, Math.min(x, 1.0f - curWidth));
        this.mCurrentViewport.right = x + curWidth;
        this.mCurrentViewport.constrainViewport();
        this.triggerViewportChange();
    }

    public void setCurrentViewport(RectF viewport) {
        this.mCurrentViewport.set(viewport.left, viewport.top, viewport.right, viewport.bottom);
        this.mCurrentViewport.constrainViewport();
        this.triggerViewportChange();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean retVal = event.getPointerCount() > 1 && this.mScaleGestureDetector.onTouchEvent(event);
        retVal = this.mGestureDetector.onTouchEvent(event) || retVal;
        return retVal || super.onTouchEvent(event);
    }

    protected void setupEdgeEffect(Context context) {
        this.mEdgeEffectLeft = new EdgeEffect(context);
        this.mEdgeEffectRight = new EdgeEffect(context);
    }

    protected void drawEdgeEffectsUnclipped(Canvas canvas) {
        int restoreCount;
        boolean needsInvalidate = false;
        if (!this.mEdgeEffectLeft.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate((float)this.mContentRect.left, (float)this.mContentRect.bottom);
            canvas.rotate(-90.0f, 0.0f, 0.0f);
            this.mEdgeEffectLeft.setSize(this.mContentRect.height(), this.mContentRect.width());
            if (this.mEdgeEffectLeft.draw(canvas)) {
                needsInvalidate = true;
            }
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeEffectRight.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate((float)this.mContentRect.right, (float)this.mContentRect.top);
            canvas.rotate(90.0f, 0.0f, 0.0f);
            this.mEdgeEffectRight.setSize(this.mContentRect.height(), this.mContentRect.width());
            if (this.mEdgeEffectRight.draw(canvas)) {
                needsInvalidate = true;
            }
            canvas.restoreToCount(restoreCount);
        }
        if (needsInvalidate) {
            this.triggerViewportChange();
        }
    }

    private void releaseEdgeEffects() {
        this.mEdgeEffectRightActive = false;
        this.mEdgeEffectLeftActive = false;
        this.mEdgeEffectLeft.onRelease();
        this.mEdgeEffectRight.onRelease();
    }

    public AxisY getAxisLeft() {
        return this.mAxisLeft;
    }

    public AxisY getAxisRight() {
        return this.mAxisRight;
    }

    public AxisX getAxisTop() {
        return this.mAxisTop;
    }

    public AxisX getAxisBottom() {
        return this.mAxisBottom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnViewportChangeListener(OnViewportChangeListener onViewportChangeListener) {
        Chart chart = this;
        synchronized (chart) {
            this.mOnViewportChangeListeners.add(onViewportChangeListener);
        }
    }

    public boolean isScaleXEnable() {
        return this.mScaleXEnable;
    }

    public void setScaleXEnable(boolean scaleXEnable) {
        this.mScaleXEnable = scaleXEnable;
    }

    public void setDoubleTapToZoom(boolean doubleTapToZoom) {
        this.mDoubleTapToZoom = doubleTapToZoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnTouchPointChangeListener(OnTouchPointChangeListener touchPointChangeListener) {
        Chart chart = this;
        synchronized (chart) {
            this.mTouchPointChangeListeners.add(touchPointChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnTouchPointChangeListener(OnTouchPointChangeListener touchPointChangeListener) {
        Chart chart = this;
        synchronized (chart) {
            this.mTouchPointChangeListeners.remove(touchPointChangeListener);
        }
    }

    public void setDraggingToMoveEnable(boolean draggingToMoveEnable) {
        this.mDraggingToMoveEnable = draggingToMoveEnable;
    }

    public boolean isDraggingToMoveEnable() {
        return this.mDraggingToMoveEnable;
    }

    public void moveLeft() {
        this.moveLeft(0.2f);
    }

    public void moveRight() {
        this.moveRight(0.2f);
    }

    public void moveLeft(@FloatRange(from=0.0, to=1.0) float percent) {
        this.releaseEdgeEffects();
        this.computeScrollSurfaceSize(this.mSurfaceSizeBuffer);
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        float moveDistance = (float)this.mContentRect.width() * percent;
        int startX = (int)((float)this.mSurfaceSizeBuffer.x * (this.mScrollerStartViewport.left - 0.0f) / 1.0f);
        if (!this.mScroller.isFinished()) {
            this.mScroller.forceFinished(true);
        }
        this.mScroller.startScroll(startX, 0, (int)(-moveDistance), 0, 300);
        this.postInvalidateOnAnimation();
    }

    public void moveRight(@FloatRange(from=0.0, to=1.0) float percent) {
        this.computeScrollSurfaceSize(this.mSurfaceSizeBuffer);
        this.mScrollerStartViewport.set((RectF)this.mCurrentViewport);
        float moveDistance = (float)this.mContentRect.width() * percent;
        int startX = (int)((float)this.mSurfaceSizeBuffer.x * (this.mScrollerStartViewport.left - 0.0f) / 1.0f);
        if (!this.mScroller.isFinished()) {
            this.mScroller.forceFinished(true);
        }
        this.mScroller.startScroll(startX, 0, (int)moveDistance, 0, 300);
        this.postInvalidateOnAnimation();
    }

    public void setInternalViewportChangeListener(OnViewportChangeListener mInternalViewportChangeListener) {
        this.mInternalViewportChangeListener = mInternalViewportChangeListener;
    }

    public void setScaleGestureEnable(boolean mScaleGestureEnable) {
        this.mScaleGestureEnable = mScaleGestureEnable;
    }

    public boolean isScaleGestureEnable() {
        return this.mScaleGestureEnable;
    }

    public boolean isHighlightDisable() {
        return this.mHighlightDisable;
    }

    public void setHighlightDisable(boolean highlightDisable) {
        this.mHighlightDisable = highlightDisable;
    }

    public void setOnEntryClickListener(OnEntryClickListener onEntryClickListener) {
        this.onEntryClickListener = onEntryClickListener;
    }

    public OnEntryClickListener getOnEntryClickListener() {
        return this.onEntryClickListener;
    }

    public Zoomer getZoomer() {
        return this.mZoomer;
    }

    public static interface OnTouchPointChangeListener {
        public void touch(float var1, float var2);
    }
}

