/*
 * Decompiled with CFR 0.152.
 */
package com.jerechen.notchadapter.type;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.Log;
import com.jerechen.notchadapter.INotchScreen;
import com.jerechen.notchadapter.utils.ScreenUtil;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\u0003\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/jerechen/notchadapter/type/OppoNotchScreen;", "Lcom/jerechen/notchadapter/INotchScreen;", "()V", "getNotchInfo", "", "", "activity", "Landroid/app/Activity;", "notchInfoCallback", "Lcom/jerechen/notchadapter/INotchScreen$NotchInfoCallback;", "isContainNotch", "", "notchAdapter_release"})
public final class OppoNotchScreen
implements INotchScreen {
    @Override
    public boolean isContainNotch(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        try {
            return activity.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
        }
        catch (Exception e) {
            Log.e((String)"OppoNotchScreen", (String)("isContainNotch " + e.getMessage()));
            return false;
        }
    }

    @Override
    public void getNotchInfo(@NotNull Activity activity, @NotNull INotchScreen.NotchInfoCallback notchInfoCallback) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)notchInfoCallback, (String)"notchInfoCallback");
        try {
            String string;
            if (!this.isContainNotch(activity)) {
                return;
            }
            String notchInfo = this.getNotchInfo();
            if (TextUtils.isEmpty((CharSequence)notchInfo)) {
                return;
            }
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            Log.e((String)"jereTest", (String)("Oppo notchInfo = " + notchInfo));
            List notchSplit = StringsKt.split$default((CharSequence)notchInfo, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            String leftTopPoint = (String)notchSplit.get(0);
            String rightBottomPoint = (String)notchSplit.get(1);
            List leftAndTop = StringsKt.split$default((CharSequence)leftTopPoint, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            List rightAndBottom = StringsKt.split$default((CharSequence)rightBottomPoint, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            if (ScreenUtil.INSTANCE.isPortrait((Context)activity)) {
                string = (String)leftAndTop.get(0);
                boolean bl = false;
                left = Integer.parseInt(string);
                string = (String)leftAndTop.get(1);
                bl = false;
                top = Integer.parseInt(string);
                string = (String)rightAndBottom.get(0);
                bl = false;
                right = Integer.parseInt(string);
                string = (String)rightAndBottom.get(1);
                bl = false;
                bottom = Integer.parseInt(string);
            } else {
                string = (String)leftAndTop.get(1);
                boolean bl = false;
                left = Integer.parseInt(string);
                string = (String)leftAndTop.get(0);
                bl = false;
                top = Integer.parseInt(string);
                string = (String)rightAndBottom.get(1);
                bl = false;
                right = Integer.parseInt(string);
                string = (String)rightAndBottom.get(0);
                bl = false;
                bottom = Integer.parseInt(string);
            }
            Rect notchRect = new Rect(left, top, right, bottom);
            notchInfoCallback.getNotchRect(notchRect);
        }
        catch (Exception e) {
            Log.e((String)"OppoNotchScreen", (String)("getNotchInfo " + e.getMessage()));
        }
    }

    private final String getNotchInfo() {
        String notchInfo = null;
        Class<?> clazz = Class.forName("android.os.SystemProperties");
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.os.SystemProperties\")");
        Class<?> cls = clazz;
        Method method = cls.getMethod("get", String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"cls.getMethod(\"get\", String::class.java)");
        Method get = method;
        Object object = get.invoke(cls.newInstance(), "ro.oppo.screen.heteromorphism");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        notchInfo = (String)object;
        return notchInfo;
    }
}

