/*
 * Decompiled with CFR 0.152.
 */
package cn.hikyson.methodcanary.lib;

import android.app.Activity;
import android.app.Fragment;
import cn.hikyson.methodcanary.lib.MethodEvent;
import cn.hikyson.methodcanary.lib.ThreadInfo;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class Util {
    public static final Pattern PATTERN_THREAD = Pattern.compile("^\\[THREAD]id=(\\d*);name=(.*);priority=(\\d*)$");
    public static final Pattern PATTERN_METHOD_ENTER = Pattern.compile("^PUSH:et=(\\d*);cn=(.*);ma=(-?\\d*);mn=(.*);md=(.*)$");
    public static final Pattern PATTERN_METHOD_EXIT = Pattern.compile("^POP:et=(\\d*);cn=(.*);ma=(-?\\d*);mn=(.*);md=(.*)$");
    public static final String START_THREAD = "[THREAD]";
    public static final String START_METHOD_ENTER = "PUSH:";
    public static final String START_METHOD_EXIT = "POP:";

    static boolean mergeInToFile(File sourceFile, Map<ThreadInfo, List<MethodEvent>> old) {
        BufferedSink bufferedSink;
        BufferedSource bufferedSource;
        HashMap<ThreadInfo, List<MethodEvent>> methodEventMap = new HashMap<ThreadInfo, List<MethodEvent>>(old);
        if (!Util.createOrExistsFile(sourceFile)) {
            return false;
        }
        File tmp = new File(sourceFile.getParentFile(), sourceFile.getName() + "~");
        if (tmp.exists() && !tmp.delete()) {
            return false;
        }
        try {
            bufferedSource = Okio.buffer((Source)Okio.source((File)sourceFile));
            bufferedSink = Okio.buffer((Sink)Okio.sink((File)tmp));
            ThreadInfo currentThreadInfo = null;
            boolean shouldInsertToCurrentThread = false;
            while (true) {
                String line;
                if ((line = bufferedSource.readUtf8Line()) == null || line.startsWith(START_THREAD)) {
                    List currentMethodEvents;
                    if (shouldInsertToCurrentThread && (currentMethodEvents = (List)methodEventMap.remove(currentThreadInfo)) != null && !currentMethodEvents.isEmpty()) {
                        for (MethodEvent methodEvent : currentMethodEvents) {
                            bufferedSink.writeUtf8(methodEvent + "\n");
                        }
                    }
                    if (line == null) break;
                    bufferedSink.writeUtf8(line + "\n");
                    Matcher m = PATTERN_THREAD.matcher(line);
                    if (m.find()) {
                        long id = Long.parseLong(m.group(1));
                        String name = m.group(2);
                        int priority = Integer.parseInt(m.group(3));
                        currentThreadInfo = new ThreadInfo(id, name, priority);
                        shouldInsertToCurrentThread = methodEventMap.containsKey(currentThreadInfo);
                        continue;
                    }
                    throw new IllegalStateException("illegal format for [THREAD] line:" + line);
                }
                bufferedSink.writeUtf8(line + "\n");
            }
            bufferedSink.writeUtf8(Util.serializeMethodEvent(methodEventMap));
            bufferedSink.flush();
        }
        catch (Throwable e) {
            return false;
        }
        Util.closeSilently((Closeable)bufferedSource);
        Util.closeSilently((Closeable)bufferedSink);
        if (!sourceFile.delete()) {
            return false;
        }
        return tmp.renameTo(sourceFile);
    }

    private static String serializeMethodEvent(Map<ThreadInfo, List<MethodEvent>> methodEventMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ThreadInfo, List<MethodEvent>> entry : methodEventMap.entrySet()) {
            sb.append(entry.getKey()).append("\n");
            List<MethodEvent> mes = entry.getValue();
            for (MethodEvent methodEvent : mes) {
                sb.append(methodEvent).append("\n");
            }
        }
        return String.valueOf(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean writeFileFromBytesByChannel(File file, byte[] bytes, boolean append, boolean isForce) {
        if (bytes == null) {
            return false;
        }
        FileChannel fc = null;
        try {
            fc = new FileOutputStream(file, append).getChannel();
            fc.position(fc.size());
            fc.write(ByteBuffer.wrap(bytes));
            if (isForce) {
                fc.force(true);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!Util.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean writeFileFromBytesByStream(File file, byte[] bytes, boolean append) {
        if (bytes == null || !Util.createOrExistsFile(file)) {
            return false;
        }
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file, append));
            bos.write(bytes);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static boolean isPageType(Object o) {
        return o instanceof Activity || o instanceof android.support.v4.app.Fragment || o instanceof Fragment;
    }
}

