/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.toolsfinal;

import android.app.Activity;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import java.util.Iterator;
import java.util.Stack;

public class ActivityManager {
    private static Stack<Activity> activityStack;
    private static ActivityManager instance;

    private ActivityManager() {
    }

    public static ActivityManager getActivityManager() {
        if (instance == null) {
            instance = new ActivityManager();
        }
        return instance;
    }

    public void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack();
        }
        activityStack.add(activity);
    }

    public Activity currentActivity() {
        if (activityStack == null) {
            return null;
        }
        Activity activity = (Activity)activityStack.lastElement();
        return activity;
    }

    public void finishActivity() {
        if (activityStack == null) {
            return;
        }
        Activity activity = (Activity)activityStack.lastElement();
        this.finishActivity(activity);
    }

    public void finishActivity(Activity activity) {
        if (activityStack == null) {
            return;
        }
        if (activity != null) {
            activityStack.remove(activity);
            activity.finish();
            activity = null;
        }
    }

    public void finishActivity(Class<?> cls) {
        if (activityStack == null) {
            return;
        }
        Iterator iterator = activityStack.iterator();
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            if (activity == null || !activity.getClass().equals(cls)) continue;
            activity.finish();
            iterator.remove();
        }
    }

    public void finishAllActivity() {
        if (activityStack == null) {
            return;
        }
        for (Activity activity : activityStack) {
            if (activity == null || activity.isFinishing()) continue;
            activity.finish();
        }
        activityStack.clear();
    }

    public Activity getActivity(String activityName) {
        for (Activity activity : activityStack) {
            if (activity == null || !TextUtils.equals((CharSequence)activity.getClass().getName(), (CharSequence)activityName)) continue;
            return activity;
        }
        return null;
    }

    public void appExit(Context context) {
        try {
            this.finishAllActivity();
            Process.killProcess((int)Process.myPid());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

