/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.toolsfinal;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class JsonValidator {
    private CharacterIterator it;
    private char c;
    private int col;

    public boolean validate(String input) {
        input = input.trim();
        boolean ret = this.valid(input);
        return ret;
    }

    private boolean valid(String input) {
        if ("".equals(input)) {
            return true;
        }
        boolean ret = true;
        this.it = new StringCharacterIterator(input);
        this.c = this.it.first();
        this.col = 1;
        if (!this.value()) {
            ret = false;
        } else {
            this.skipWhiteSpace();
            if (this.c != '\uffff') {
                ret = false;
            }
        }
        return ret;
    }

    private boolean value() {
        return this.literal("true") || this.literal("false") || this.literal("null") || this.string() || this.number() || this.object() || this.array();
    }

    private boolean literal(String text) {
        StringCharacterIterator ci = new StringCharacterIterator(text);
        char t = ci.first();
        if (this.c != t) {
            return false;
        }
        int start = this.col;
        boolean ret = true;
        t = ci.next();
        while (t != '\uffff') {
            if (t != this.nextCharacter()) {
                ret = false;
                break;
            }
            t = ci.next();
        }
        this.nextCharacter();
        if (!ret) {
            // empty if block
        }
        return ret;
    }

    private boolean array() {
        return this.aggregate('[', ']', false);
    }

    private boolean object() {
        return this.aggregate('{', '}', true);
    }

    private boolean aggregate(char entryCharacter, char exitCharacter, boolean prefix) {
        if (this.c != entryCharacter) {
            return false;
        }
        this.nextCharacter();
        this.skipWhiteSpace();
        if (this.c == exitCharacter) {
            this.nextCharacter();
            return true;
        }
        while (true) {
            if (prefix) {
                int start = this.col;
                if (!this.string()) {
                    return false;
                }
                this.skipWhiteSpace();
                if (this.c != ':') {
                    return false;
                }
                this.nextCharacter();
                this.skipWhiteSpace();
            }
            if (this.value()) {
                this.skipWhiteSpace();
                if (this.c != ',') {
                    if (this.c == exitCharacter) break;
                    return false;
                }
            } else {
                return false;
            }
            this.nextCharacter();
            this.skipWhiteSpace();
        }
        this.nextCharacter();
        return true;
    }

    private boolean number() {
        if (!Character.isDigit(this.c) && this.c != '-') {
            return false;
        }
        int start = this.col;
        if (this.c == '-') {
            this.nextCharacter();
        }
        if (this.c == '0') {
            this.nextCharacter();
        } else if (Character.isDigit(this.c)) {
            while (Character.isDigit(this.c)) {
                this.nextCharacter();
            }
        } else {
            return false;
        }
        if (this.c == '.') {
            this.nextCharacter();
            if (Character.isDigit(this.c)) {
                while (Character.isDigit(this.c)) {
                    this.nextCharacter();
                }
            } else {
                return false;
            }
        }
        if (this.c == 'e' || this.c == 'E') {
            this.nextCharacter();
            if (this.c == '+' || this.c == '-') {
                this.nextCharacter();
            }
            if (Character.isDigit(this.c)) {
                while (Character.isDigit(this.c)) {
                    this.nextCharacter();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean string() {
        if (this.c != '\"') {
            return false;
        }
        boolean escaped = false;
        this.nextCharacter();
        while (this.c != '\uffff') {
            if (!escaped && this.c == '\\') {
                escaped = true;
            } else if (escaped) {
                if (!this.escape()) {
                    return false;
                }
                escaped = false;
            } else if (this.c == '\"') {
                this.nextCharacter();
                return true;
            }
            this.nextCharacter();
        }
        return false;
    }

    private boolean escape() {
        if (" \\\"/bfnrtu".indexOf(this.c) < 0) {
            return false;
        }
        return this.c != 'u' || this.ishex(this.nextCharacter()) && this.ishex(this.nextCharacter()) && this.ishex(this.nextCharacter()) && this.ishex(this.nextCharacter());
    }

    private boolean ishex(char d) {
        return "0123456789abcdefABCDEF".indexOf(this.c) >= 0;
    }

    private char nextCharacter() {
        this.c = this.it.next();
        ++this.col;
        return this.c;
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.c)) {
            this.nextCharacter();
        }
    }
}

