/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.toolsfinal;

import android.os.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class ExternalStorage {
    public static final String SD_CARD = "sdCard";
    public static final String EXTERNAL_SD_CARD = "externalSdCard";

    public static boolean isAvailable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state) || "mounted_ro".equals(state);
    }

    public static String getSdCardPath() {
        return Environment.getExternalStorageDirectory().getPath() + "/";
    }

    public static boolean isWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public static Map<String, File> getAllStorageLocations() {
        String[] lineElements;
        String element;
        String line;
        Scanner scanner;
        HashMap<String, File> map = new HashMap<String, File>(10);
        ArrayList<String> mMounts = new ArrayList<String>(10);
        ArrayList<String> mVold = new ArrayList<String>(10);
        mMounts.add("/mnt/sdcard");
        mVold.add("/mnt/sdcard");
        try {
            File mountFile = new File("/proc/mounts");
            if (mountFile.exists()) {
                scanner = new Scanner(mountFile);
                while (scanner.hasNext()) {
                    line = scanner.nextLine();
                    if (!line.startsWith("/dev/block/vold/") || (element = (lineElements = line.split(" "))[1]).equals("/mnt/sdcard")) continue;
                    mMounts.add(element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            File voldFile = new File("/system/etc/vold.fstab");
            if (voldFile.exists()) {
                scanner = new Scanner(voldFile);
                while (scanner.hasNext()) {
                    line = scanner.nextLine();
                    if (!line.startsWith("dev_mount")) continue;
                    lineElements = line.split(" ");
                    element = lineElements[2];
                    if (element.contains(":")) {
                        element = element.substring(0, element.indexOf(":"));
                    }
                    if (element.equals("/mnt/sdcard")) continue;
                    mVold.add(element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < mMounts.size(); ++i) {
            String mount = (String)mMounts.get(i);
            if (mVold.contains(mount)) continue;
            mMounts.remove(i--);
        }
        mVold.clear();
        ArrayList<String> mountHash = new ArrayList<String>(10);
        for (String mount : mMounts) {
            File root = new File(mount);
            if (!root.exists() || !root.isDirectory() || !root.canWrite()) continue;
            File[] list = root.listFiles();
            String hash = "[";
            if (list != null) {
                for (File f : list) {
                    hash = hash + f.getName().hashCode() + ":" + f.length() + ", ";
                }
            }
            if (mountHash.contains(hash = hash + "]")) continue;
            String key = "sdCard_" + map.size();
            if (map.size() == 0) {
                key = SD_CARD;
            } else if (map.size() == 1) {
                key = EXTERNAL_SD_CARD;
            }
            mountHash.add(hash);
            map.put(key, root);
        }
        mMounts.clear();
        if (map.isEmpty()) {
            map.put(SD_CARD, Environment.getExternalStorageDirectory());
        }
        return map;
    }
}

